/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class BasicIconFactory
implements Serializable {
    private static Icon frame_icon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon createEmptyFrameIcon() {
        if (frame_icon == null) {
            frame_icon = new EmptyFrameIcon(null);
        }
        return frame_icon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon(null);
        }
        return checkBoxIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon(null);
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon(null);
        }
        return menuArrowIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon(null);
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon(null);
        }
        return menuItemCheckIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon(null);
        }
        return radioButtonIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon(null);
        }
        return radioButtonMenuItemIcon;
    }

    class 1 {
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;

        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        private CheckBoxIcon() {
        }

        CheckBoxIcon(1 var1_1) {
            this();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        private CheckBoxMenuItemIcon() {
        }

        CheckBoxMenuItemIcon(1 var1_1) {
            this();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl2 = buttonModel.isSelected();
            if (bl2) {
                graphics.drawLine(n2 + 7, n3 + 1, n2 + 7, n3 + 3);
                graphics.drawLine(n2 + 6, n3 + 2, n2 + 6, n3 + 4);
                graphics.drawLine(n2 + 5, n3 + 3, n2 + 5, n3 + 5);
                graphics.drawLine(n2 + 4, n3 + 4, n2 + 4, n3 + 6);
                graphics.drawLine(n2 + 3, n3 + 5, n2 + 3, n3 + 7);
                graphics.drawLine(n2 + 2, n3 + 4, n2 + 2, n3 + 6);
                graphics.drawLine(n2 + 1, n3 + 3, n2 + 1, n3 + 5);
            }
        }
    }

    private static class EmptyFrameIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        private EmptyFrameIcon() {
        }

        EmptyFrameIcon(1 var1_1) {
            this();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 4;
        }

        private MenuArrowIcon() {
        }

        MenuArrowIcon(1 var1_1) {
            this();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Polygon polygon = new Polygon();
            polygon.addPoint(n2, n3);
            polygon.addPoint(n2 + this.getIconWidth(), n3 + this.getIconHeight() / 2);
            polygon.addPoint(n2, n3 + this.getIconHeight());
            graphics.fillPolygon(polygon);
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 4;
        }

        private MenuItemArrowIcon() {
        }

        MenuItemArrowIcon(1 var1_1) {
            this();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        private MenuItemCheckIcon() {
        }

        MenuItemCheckIcon(1 var1_1) {
            this();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        private RadioButtonIcon() {
        }

        RadioButtonIcon(1 var1_1) {
            this();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconHeight() {
            return 6;
        }

        public int getIconWidth() {
            return 6;
        }

        private RadioButtonMenuItemIcon() {
        }

        RadioButtonMenuItemIcon(1 var1_1) {
            this();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isSelected()) {
                graphics.fillOval(n2 + 1, n3 + 1, this.getIconWidth(), this.getIconHeight());
            }
        }
    }
}

