/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;

    public int getListenerCount() {
        return this.listenerList.length / 2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        this.listenerList = NULL_ARRAY;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            EventListener eventListener = (EventListener)objectInputStream.readObject();
            this.add(Class.forName((String)object, true, classLoader), eventListener);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = this.listenerList;
        objectOutputStream.defaultWriteObject();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Class clazz = (Class)objectArray[n2];
            EventListener eventListener = (EventListener)objectArray[n2 + 1];
            if (eventListener != null && eventListener instanceof Serializable) {
                objectOutputStream.writeObject(clazz.getName());
                objectOutputStream.writeObject(eventListener);
            }
            n2 += 2;
        }
        objectOutputStream.writeObject(null);
    }

    public int getListenerCount(Class clazz) {
        Object[] objectArray = this.listenerList;
        return this.getListenerCount(objectArray, clazz);
    }

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public String toString() {
        Object[] objectArray = this.listenerList;
        String string = "EventListenerList: ";
        string = string + objectArray.length / 2 + " listeners: ";
        int n2 = 0;
        while (n2 <= objectArray.length - 2) {
            string = string + " type " + ((Class)objectArray[n2]).getName();
            string = string + " listener " + objectArray[n2 + 1];
            n2 += 2;
        }
        return string;
    }

    private int getListenerCount(Object[] objectArray, Class clazz) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (clazz == (Class)objectArray[n3]) {
                ++n2;
            }
            n3 += 2;
        }
        return n2;
    }

    public EventListener[] getListeners(Class clazz) {
        Object[] objectArray = this.listenerList;
        int n2 = this.getListenerCount(objectArray, clazz);
        EventListener[] eventListenerArray = (EventListener[])Array.newInstance(clazz, n2);
        int n3 = 0;
        int n4 = objectArray.length - 2;
        while (n4 >= 0) {
            if (objectArray[n4] == clazz) {
                eventListenerArray[n3++] = (EventListener)objectArray[n4 + 1];
            }
            n4 -= 2;
        }
        return eventListenerArray;
    }

    public synchronized void add(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{clazz, eventListener};
        } else {
            int n2 = this.listenerList.length;
            Object[] objectArray = new Object[n2 + 2];
            System.arraycopy(this.listenerList, 0, objectArray, 0, n2);
            objectArray[n2] = clazz;
            objectArray[n2 + 1] = eventListener;
            this.listenerList = objectArray;
        }
    }

    public synchronized void remove(Class clazz, EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (!clazz.isInstance(eventListener)) {
            throw new IllegalArgumentException("Listener " + eventListener + " is not of type " + clazz);
        }
        int n2 = -1;
        int n3 = this.listenerList.length - 2;
        while (n3 >= 0) {
            if (this.listenerList[n3] == clazz && this.listenerList[n3 + 1].equals(eventListener)) {
                n2 = n3;
                break;
            }
            n3 -= 2;
        }
        if (n2 != -1) {
            Object[] objectArray = new Object[this.listenerList.length - 2];
            System.arraycopy(this.listenerList, 0, objectArray, 0, n2);
            if (n2 < objectArray.length) {
                System.arraycopy(this.listenerList, n2 + 2, objectArray, n2, objectArray.length - n2);
            }
            this.listenerList = objectArray.length == 0 ? NULL_ARRAY : objectArray;
        }
    }
}

