/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;
import sun.security.action.GetPropertyAction;

public class JPopupMenu
extends JComponent
implements Accessible,
MenuElement {
    private static final String uiClassID = "PopupMenuUI";
    private static final Object defaultLWPopupEnabledKey = new StringBuffer("JPopupMenu.defaultLWPopupEnabledKey");
    static boolean popupPostionFixDisabled = false;
    transient Component invoker;
    transient Popup popup;
    transient Frame frame;
    private int desiredLocationX;
    private int desiredLocationY;
    private String label = null;
    private boolean paintBorder = true;
    private Insets margin = null;
    private boolean lightWeightPopup = true;
    private SingleSelectionModel selectionModel;
    private static final Object classLock;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static Class class$javax$swing$event$PopupMenuListener;

    static {
        popupPostionFixDisabled = AccessController.doPrivileged(new GetPropertyAction("javax.swing.adjustPopupLocationToFit", "")).equals("false");
        classLock = new Object();
    }

    public JPopupMenu() {
        this(null);
    }

    public void addSeparator() {
        this.add(new Separator());
    }

    protected void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$PopupMenuListener == null ? JPopupMenu.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n2 + 1]).popupMenuCanceled(popupMenuEvent);
            }
            n2 -= 2;
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$PopupMenuListener == null ? JPopupMenu.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n2 + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
            }
            n2 -= 2;
        }
    }

    protected void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$PopupMenuListener == null ? JPopupMenu.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n2 + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
            }
            n2 -= 2;
        }
    }

    public void pack() {
        if (this.popup != null) {
            Dimension dimension = this.getPreferredSize();
            if (dimension == null || dimension.width != this.getWidth() || dimension.height != this.getHeight()) {
                this.popup = this.getPopup();
            } else {
                this.validate();
            }
        }
    }

    public void updateUI() {
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    boolean alwaysOnTop() {
        return true;
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        Boolean bl2 = (Boolean)SwingUtilities.appContextGet(defaultLWPopupEnabledKey);
        if (bl2 == null) {
            SwingUtilities.appContextPut(defaultLWPopupEnabledKey, Boolean.TRUE);
            return true;
        }
        return bl2;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopup;
    }

    private boolean isPopupMenu() {
        return this.invoker != null && !(this.invoker instanceof JMenu);
    }

    public boolean isVisible() {
        return this.popup != null;
    }

    public void remove(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n2 > this.getComponentCount() - 1) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        super.remove(n2);
    }

    public void setLocation(int n2, int n3) {
        int n4 = this.desiredLocationX;
        int n5 = this.desiredLocationY;
        this.desiredLocationX = n2;
        this.desiredLocationY = n3;
        if (this.popup != null && (n2 != n4 || n3 != n5)) {
            this.popup = this.getPopup();
        }
    }

    public void setPopupSize(int n2, int n3) {
        this.setPopupSize(new Dimension(n2, n3));
    }

    public void menuSelectionChanged(boolean bl2) {
        if (this.invoker instanceof JMenu) {
            JMenu jMenu = (JMenu)this.invoker;
            if (bl2) {
                jMenu.setPopupMenuVisible(true);
            } else {
                jMenu.setPopupMenuVisible(false);
            }
        }
        if (this.isPopupMenu() && !bl2) {
            this.setVisible(false);
        }
    }

    public void setBorderPainted(boolean bl2) {
        this.paintBorder = bl2;
        this.repaint();
    }

    public static void setDefaultLightWeightPopupEnabled(boolean bl2) {
        SwingUtilities.appContextPut(defaultLWPopupEnabledKey, bl2);
    }

    public void setLightWeightPopupEnabled(boolean bl2) {
        this.lightWeightPopup = bl2;
    }

    public void setVisible(boolean bl2) {
        if (bl2 == this.isVisible()) {
            return;
        }
        if (!bl2) {
            this.getSelectionModel().clearSelection();
        } else if (this.isPopupMenu()) {
            if (this.getSubElements().length > 0) {
                MenuElement[] menuElementArray = new MenuElement[]{this, this.getSubElements()[0]};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            } else {
                MenuElement[] menuElementArray = new MenuElement[]{this};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            }
        }
        if (bl2) {
            this.firePopupMenuWillBecomeVisible();
            this.popup = this.getPopup();
            this.firePropertyChange("visible", Boolean.FALSE, Boolean.TRUE);
        } else if (this.popup != null) {
            this.firePopupMenuWillBecomeInvisible();
            this.popup.hide();
            this.popup = null;
            this.firePropertyChange("visible", Boolean.TRUE, Boolean.FALSE);
        }
        if (this.accessibleContext != null) {
            if (bl2) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }
        }
    }

    public Component getComponent() {
        return this;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public Component getComponentAtIndex(int n2) {
        return this.getComponent(n2);
    }

    public int getComponentIndex(Component component) {
        int n2 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        while (n3 < n2) {
            Component component2 = componentArray[n3];
            if (component2 == component) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void setInvoker(Component component) {
        Component component2 = this.invoker;
        this.invoker = component;
        if (component2 != this.invoker && this.ui != null) {
            this.ui.uninstallUI(this);
            this.ui.installUI(this);
        }
        this.invalidate();
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n2 = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n2);
    }

    public void insert(Component component, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n3 = this.getComponentCount();
        Vector vector = new Vector();
        int n4 = n2;
        while (n4 < n3) {
            vector.addElement(this.getComponent(n2));
            this.remove(n2);
            ++n4;
        }
        this.add(component);
        int n5 = 0;
        while (n5 < vector.size()) {
            this.add((Component)vector.elementAt(n5));
            ++n5;
        }
    }

    public void show(Component component, int n2, int n3) {
        this.setInvoker(component);
        Frame frame = JPopupMenu.getFrame(component);
        if (frame != this.frame && frame != null) {
            this.frame = frame;
            if (this.popup != null) {
                this.setVisible(false);
            }
        }
        if (component != null) {
            Point point = component.getLocationOnScreen();
            this.setLocation(point.x + n2, point.y + n3);
        } else {
            this.setLocation(n2, n3);
        }
        this.setVisible(true);
    }

    public void setPopupSize(Dimension dimension) {
        Dimension dimension2;
        Dimension dimension3 = this.getPreferredSize();
        this.setPreferredSize(dimension);
        if (this.popup != null && !dimension3.equals(dimension2 = this.getPreferredSize())) {
            this.popup = this.getPopup();
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    Point adjustPopupLocationToFitScreen(int n2, int n3) {
        Rectangle rectangle;
        Insets insets;
        Point point = new Point(n2, n3);
        if (popupPostionFixDisabled || GraphicsEnvironment.isHeadless()) {
            return point;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n4 = 0;
        while (n4 < graphicsDeviceArray.length) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDeviceArray[n4].getType() == 0 && (graphicsConfiguration2 = graphicsDeviceArray[n4].getDefaultConfiguration()).getBounds().contains(point)) {
                graphicsConfiguration = graphicsConfiguration2;
                break;
            }
            ++n4;
        }
        if (graphicsConfiguration == null && this.getInvoker() != null) {
            graphicsConfiguration = this.getInvoker().getGraphicsConfiguration();
        }
        if (graphicsConfiguration != null) {
            insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
        } else {
            insets = new Insets(0, 0, 0, 0);
            rectangle = new Rectangle(toolkit.getScreenSize());
        }
        int n5 = rectangle.width - Math.abs(insets.left + insets.right);
        int n6 = rectangle.height - Math.abs(insets.top + insets.bottom);
        Dimension dimension = this.getPreferredSize();
        if (point.x + dimension.width > rectangle.x + n5) {
            point.x = rectangle.x + n5 - dimension.width;
        }
        if (point.y + dimension.height > rectangle.y + n6) {
            point.y = rectangle.y + n6 - dimension.height;
        }
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        return point;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return this.getUI().isPopupTrigger(mouseEvent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n2 = 0;
        int n3 = vector.size();
        if (n2 < n3 && vector.elementAt(n2).equals("invoker")) {
            this.invoker = (Component)vector.elementAt(++n2);
            ++n2;
        }
        if (n2 < n3 && vector.elementAt(n2).equals("popup")) {
            this.popup = (Popup)vector.elementAt(++n2);
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector = new Vector();
        objectOutputStream.defaultWriteObject();
        if (this.invoker != null && this.invoker instanceof Serializable) {
            vector.addElement("invoker");
            vector.addElement(this.invoker);
        }
        if (this.popup != null && this.popup instanceof Serializable) {
            vector.addElement("popup");
            vector.addElement(this.popup);
        }
        objectOutputStream.writeObject(vector);
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.label != null ? this.label : "";
        String string2 = this.paintBorder ? "true" : "false";
        String string3 = this.margin != null ? this.margin.toString() : "";
        String string4 = this.isLightWeightPopupEnabled() ? "true" : "false";
        return super.paramString() + ",desiredLocationX=" + this.desiredLocationX + ",desiredLocationY=" + this.desiredLocationY + ",label=" + string + ",lightWeightPopupEnabled=" + string4 + ",margin=" + string3 + ",paintBorder=" + string2;
    }

    public JPopupMenu(String string) {
        this.label = string;
        this.lightWeightPopup = JPopupMenu.getDefaultLightWeightPopupEnabled();
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.addMouseListener(new MouseAdapter(this){
            private final JPopupMenu this$0;
            {
                this.this$0 = jPopupMenu;
            }
        });
        this.setFocusTraversalKeysEnabled(false);
        this.updateUI();
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.firePropertyChange("label", string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        this.invalidate();
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPopupMenu(this);
        }
        return this.accessibleContext;
    }

    public void insert(Action action, int n2) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.insert(jMenuItem, n2);
    }

    JPopupMenu getRootPopupMenu() {
        JPopupMenu jPopupMenu = this;
        while (jPopupMenu != null && !jPopupMenu.isPopupMenu() && jPopupMenu.getInvoker() != null && jPopupMenu.getInvoker().getParent() != null && jPopupMenu.getInvoker().getParent() instanceof JPopupMenu) {
            jPopupMenu = (JPopupMenu)jPopupMenu.getInvoker().getParent();
        }
        return jPopupMenu;
    }

    boolean isSubPopupMenu(JPopupMenu jPopupMenu) {
        int n2 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        while (n3 < n2) {
            Component component = componentArray[n3];
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                JPopupMenu jPopupMenu2 = jMenu.getPopupMenu();
                if (jPopupMenu2 == jPopupMenu) {
                    return true;
                }
                if (jPopupMenu2.isSubPopupMenu(jPopupMenu)) {
                    return true;
                }
            }
            ++n3;
        }
        return false;
    }

    public MenuElement[] getSubElements() {
        Vector vector = new Vector();
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            Component component = this.getComponent(n3);
            if (component instanceof MenuElement) {
                vector.addElement(component);
            }
            ++n3;
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n3 = 0;
        n2 = vector.size();
        while (n3 < n2) {
            menuElementArray[n3] = (MenuElement)vector.elementAt(n3);
            ++n3;
        }
        return menuElementArray;
    }

    private Popup getPopup() {
        Popup popup = this.popup;
        if (popup != null) {
            popup.hide();
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        if (this.isLightWeightPopupEnabled()) {
            popupFactory.setPopupType(0);
        } else {
            popupFactory.setPopupType(1);
        }
        Point point = this.adjustPopupLocationToFitScreen(this.desiredLocationX, this.desiredLocationY);
        this.desiredLocationX = point.x;
        this.desiredLocationY = point.y;
        Popup popup2 = this.getUI().getPopup(this, this.desiredLocationX, this.desiredLocationY);
        popupFactory.setPopupType(0);
        popup2.show();
        return popup2;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.selectionModel = singleSelectionModel;
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JPopupMenu.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener);
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JPopupMenu.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JPopupMenu.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener, popupMenuListener);
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.ui;
    }

    public void setUI(PopupMenuUI popupMenuUI) {
        super.setUI(popupMenuUI);
    }

    private static Frame getFrame(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Frame) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Frame)component2;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(this, jMenuItem);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem createActionComponent(Action action) {
        JMenuItem jMenuItem = new JMenuItem(this, (String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){
            private final JPopupMenu this$0;

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = this.this$0.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
            {
                this.this$0 = jPopupMenu;
                super(string, icon);
            }
        };
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        return jMenuItem;
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        super.add(jMenuItem);
        return jMenuItem;
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    protected class AccessibleJPopupMenu
    extends JComponent.AccessibleJComponent {
        private final JPopupMenu this$0;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }

        protected AccessibleJPopupMenu(JPopupMenu jPopupMenu) {
            this.this$0 = jPopupMenu;
            super(jPopupMenu);
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener,
    Serializable {
        private JMenuItem menuItem;
        private final JPopupMenu this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl2);
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }

        public void setTarget(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }

        public ActionChangedListener(JPopupMenu jPopupMenu, JMenuItem jMenuItem) {
            this.this$0 = jPopupMenu;
            this.setTarget(jMenuItem);
        }
    }

    public static class Separator
    extends JSeparator {
        public Separator() {
            super(0);
        }

        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }
    }
}

