/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.NumberFormatter;
import javax.swing.text.TextAction;

public class JFormattedTextField
extends JTextField {
    private static final String uiClassID = "FormattedTextFieldUI";
    private static final Action[] defaultActions = new Action[]{new CommitAction(), new CancelAction()};
    public static final int COMMIT = 0;
    public static final int COMMIT_OR_REVERT = 1;
    public static final int REVERT = 2;
    public static final int PERSIST = 3;
    private AbstractFormatterFactory factory;
    private AbstractFormatter format;
    private Object value;
    private boolean editValid;
    private int focusLostBehavior;
    private boolean edited;
    private DocumentListener documentListener;
    private Object mask;
    private ActionMap textFormatterActionMap;
    static Class class$javax$swing$text$DocumentFilter;

    public int getFocusLostBehavior() {
        return this.focusLostBehavior;
    }

    public JFormattedTextField() {
        this.enableEvents(4L);
        this.setFocusLostBehavior(1);
    }

    public void commitEdit() throws ParseException {
        AbstractFormatter abstractFormatter = this.getFormatter();
        if (abstractFormatter != null) {
            this.setValue(abstractFormatter.stringToValue(this.getText()), false);
        }
    }

    protected void invalidEdit() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    public boolean isEditValid() {
        return this.editValid;
    }

    private boolean isEdited() {
        return this.edited;
    }

    public void setFocusLostBehavior(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 3 && n2 != 2) {
            throw new IllegalArgumentException("setFocusLostBehavior must be one of: JFormattedTextField.COMMIT, JFormattedTextField.COMMIT_OR_REVERT, JFormattedTextField.PERSIST or JFormattedTextField.REVERT");
        }
        this.focusLostBehavior = n2;
    }

    private void setEditValid(boolean bl2) {
        if (bl2 != this.editValid) {
            this.editValid = bl2;
            this.firePropertyChange("editValid", (Object)(!bl2 ? 1 : 0), (Object)bl2);
        }
    }

    private void setEdited(boolean bl2) {
        this.edited = bl2;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (this.isEdited() && focusEvent.getID() == 1005) {
            int n2 = this.getFocusLostBehavior();
            if (n2 == 0 || n2 == 1) {
                try {
                    this.commitEdit();
                    this.setValue(this.getValue(), true);
                }
                catch (ParseException parseException) {
                    if (n2 == 1) {
                        this.setValue(this.getValue(), true);
                    }
                }
            } else if (n2 == 2) {
                this.setValue(this.getValue(), true);
            }
        } else if (!this.isEdited()) {
            this.setValue(this.getValue(), true);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public JFormattedTextField(Object object) {
        this();
        this.setValue(object);
    }

    public void setValue(Object object) {
        if (object != null && this.getFormatterFactory() == null) {
            this.setFormatterFactory(this.getDefaultFormatterFactory(object));
        }
        this.setValue(object, true);
    }

    private void setValue(Object object, boolean bl2) {
        Object object2 = this.value;
        this.value = object;
        if (bl2) {
            AbstractFormatterFactory abstractFormatterFactory = this.getFormatterFactory();
            AbstractFormatter abstractFormatter = abstractFormatterFactory != null ? abstractFormatterFactory.getFormatter(this) : null;
            this.setFormatter(abstractFormatter);
        } else {
            this.setEditValid(true);
        }
        this.setEdited(false);
        this.firePropertyChange("value", object2, object);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public JFormattedTextField(Format format) {
        this();
        this.setFormatterFactory(this.getDefaultFormatterFactory(format));
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    private void setFormatterActions(Action[] actionArray) {
        if (actionArray == null) {
            if (this.textFormatterActionMap != null) {
                this.textFormatterActionMap.clear();
            }
        } else {
            Object object;
            if (this.textFormatterActionMap == null) {
                Object object2 = this.getActionMap();
                this.textFormatterActionMap = new ActionMap();
                while (object2 != null) {
                    object = ((ActionMap)object2).getParent();
                    if (object instanceof UIResource || object == null) {
                        ((ActionMap)object2).setParent(this.textFormatterActionMap);
                        this.textFormatterActionMap.setParent((ActionMap)object);
                        break;
                    }
                    object2 = object;
                }
            }
            int n2 = actionArray.length - 1;
            while (n2 >= 0) {
                object = actionArray[n2].getValue("Name");
                if (object != null) {
                    this.textFormatterActionMap.put(object, actionArray[n2]);
                }
                --n2;
            }
        }
    }

    static void access$200(JFormattedTextField jFormattedTextField, boolean bl2) {
        jFormattedTextField.setEditValid(bl2);
    }

    static void access$300(JFormattedTextField jFormattedTextField, boolean bl2) {
        jFormattedTextField.setEdited(bl2);
    }

    public AbstractFormatter getFormatter() {
        return this.format;
    }

    public JFormattedTextField(AbstractFormatter abstractFormatter) {
        this(new DefaultFormatterFactory(abstractFormatter));
    }

    protected void setFormatter(AbstractFormatter abstractFormatter) {
        AbstractFormatter abstractFormatter2 = this.format;
        if (abstractFormatter2 != null) {
            abstractFormatter2.uninstall();
        }
        this.setEditValid(true);
        this.format = abstractFormatter;
        if (abstractFormatter != null) {
            abstractFormatter.install(this);
        }
        this.setEdited(false);
        this.firePropertyChange("textFormatter", abstractFormatter2, abstractFormatter);
    }

    public AbstractFormatterFactory getFormatterFactory() {
        return this.factory;
    }

    public JFormattedTextField(AbstractFormatterFactory abstractFormatterFactory) {
        this();
        this.setFormatterFactory(abstractFormatterFactory);
    }

    public void setFormatterFactory(AbstractFormatterFactory abstractFormatterFactory) {
        AbstractFormatterFactory abstractFormatterFactory2 = this.factory;
        this.factory = abstractFormatterFactory;
        this.firePropertyChange("formatterFactory", abstractFormatterFactory2, abstractFormatterFactory);
        this.setValue(this.getValue(), true);
    }

    public void setDocument(Document document) {
        if (this.documentListener != null && this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this.documentListener);
        }
        super.setDocument(document);
        if (this.documentListener == null) {
            this.documentListener = new DocumentHandler(this, null);
        }
        document.addDocumentListener(this.documentListener);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JFormattedTextField(AbstractFormatterFactory abstractFormatterFactory, Object object) {
        this(object);
        this.setFormatterFactory(abstractFormatterFactory);
    }

    static void access$100(JFormattedTextField jFormattedTextField, Action[] actionArray) {
        jFormattedTextField.setFormatterActions(actionArray);
    }

    private AbstractFormatterFactory getDefaultFormatterFactory(Object object) {
        if (object instanceof DateFormat) {
            return new DefaultFormatterFactory(new DateFormatter((DateFormat)object));
        }
        if (object instanceof NumberFormat) {
            return new DefaultFormatterFactory(new NumberFormatter((NumberFormat)object));
        }
        if (object instanceof Format) {
            return new DefaultFormatterFactory(new InternationalFormatter((Format)object));
        }
        if (object instanceof Date) {
            return new DefaultFormatterFactory(new DateFormatter());
        }
        if (object instanceof Number) {
            NumberFormatter numberFormatter = new NumberFormatter();
            NumberFormatter numberFormatter2 = new NumberFormatter(new DecimalFormat("#.#"));
            return new DefaultFormatterFactory(numberFormatter, numberFormatter, numberFormatter2);
        }
        return new DefaultFormatterFactory(new DefaultFormatter());
    }

    class 1 {
    }

    public static abstract class AbstractFormatter
    implements Serializable {
        private JFormattedTextField ftf;

        protected void invalidEdit() {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            if (jFormattedTextField != null) {
                jFormattedTextField.invalidEdit();
            }
        }

        public void uninstall() {
            if (this.ftf != null) {
                this.installDocumentFilter(null);
                this.ftf.setNavigationFilter(null);
                JFormattedTextField.access$100(this.ftf, null);
            }
        }

        protected void setEditValid(boolean bl2) {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            if (jFormattedTextField != null) {
                JFormattedTextField.access$200(jFormattedTextField, bl2);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            AbstractFormatter abstractFormatter = (AbstractFormatter)super.clone();
            abstractFormatter.ftf = null;
            return abstractFormatter;
        }

        protected Action[] getActions() {
            return null;
        }

        protected JFormattedTextField getFormattedTextField() {
            return this.ftf;
        }

        public void install(JFormattedTextField jFormattedTextField) {
            if (this.ftf != null) {
                this.uninstall();
            }
            this.ftf = jFormattedTextField;
            if (jFormattedTextField != null) {
                try {
                    jFormattedTextField.setText(this.valueToString(jFormattedTextField.getValue()));
                }
                catch (ParseException parseException) {
                    jFormattedTextField.setText("");
                    this.setEditValid(false);
                }
                this.installDocumentFilter(this.getDocumentFilter());
                jFormattedTextField.setNavigationFilter(this.getNavigationFilter());
                JFormattedTextField.access$100(jFormattedTextField, this.getActions());
            }
        }

        protected DocumentFilter getDocumentFilter() {
            return null;
        }

        private void installDocumentFilter(DocumentFilter documentFilter) {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            if (jFormattedTextField != null) {
                Document document = jFormattedTextField.getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).setDocumentFilter(documentFilter);
                }
                document.putProperty(class$javax$swing$text$DocumentFilter == null ? (class$javax$swing$text$DocumentFilter = JFormattedTextField.class$("javax.swing.text.DocumentFilter")) : class$javax$swing$text$DocumentFilter, null);
            }
        }

        protected NavigationFilter getNavigationFilter() {
            return null;
        }

        public abstract Object stringToValue(String var1) throws ParseException;

        public abstract String valueToString(Object var1) throws ParseException;
    }

    public static abstract class AbstractFormatterFactory {
        public abstract AbstractFormatter getFormatter(JFormattedTextField var1);
    }

    private static class CancelAction
    extends TextAction {
        public CancelAction() {
            super("reset-field-edit");
        }

        public boolean isEnabled() {
            JTextComponent jTextComponent = this.getFocusedComponent();
            return jTextComponent instanceof JFormattedTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JFormattedTextField) {
                JFormattedTextField jFormattedTextField = (JFormattedTextField)jTextComponent;
                jFormattedTextField.setValue(jFormattedTextField.getValue());
            }
        }
    }

    static class CommitAction
    extends JTextField.NotifyAction {
        CommitAction() {
        }

        public boolean isEnabled() {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JFormattedTextField) {
                return true;
            }
            return super.isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JFormattedTextField) {
                try {
                    ((JFormattedTextField)jTextComponent).commitEdit();
                }
                catch (ParseException parseException) {
                    return;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }

    private class DocumentHandler
    implements DocumentListener,
    Serializable {
        private final JFormattedTextField this$0;

        private DocumentHandler(JFormattedTextField jFormattedTextField) {
            this.this$0 = jFormattedTextField;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JFormattedTextField.access$300(this.this$0, true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JFormattedTextField.access$300(this.this$0, true);
        }

        DocumentHandler(JFormattedTextField jFormattedTextField, 1 var2_2) {
            this(jFormattedTextField);
        }
    }
}

