/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String MNEMONIC_CHANGED_PROPERTY = "mnemonic";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String CONTENT_AREA_FILLED_CHANGED_PROPERTY = "contentAreaFilled";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String PRESSED_ICON_CHANGED_PROPERTY = "pressedIcon";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISABLED_SELECTED_ICON_CHANGED_PROPERTY = "disabledSelectedIcon";
    protected ButtonModel model = null;
    private String text = "";
    private Insets margin = null;
    private Insets defaultMargin = null;
    private Icon defaultIcon = null;
    private Icon pressedIcon = null;
    private Icon disabledIcon = null;
    private Icon selectedIcon = null;
    private Icon disabledSelectedIcon = null;
    private Icon rolloverIcon = null;
    private Icon rolloverSelectedIcon = null;
    private boolean paintBorder = true;
    private boolean paintFocus = true;
    private boolean rolloverEnabled = false;
    private boolean contentAreaFilled = true;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 0;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 11;
    private int iconTextGap = 4;
    private int mnemonic;
    private int mnemonicIndex = -1;
    private long multiClickThreshhold = 0L;
    private AccessibleIcon accessibleIcon = null;
    protected ChangeListener changeListener = null;
    protected ActionListener actionListener = null;
    protected ItemListener itemListener = null;
    protected transient ChangeEvent changeEvent;
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    static Class class$java$awt$event$ActionListener;
    static Class class$javax$swing$event$ChangeListener;
    static Class class$java$awt$event$ItemListener;

    public int getDisplayedMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public long getMultiClickThreshhold() {
        return this.multiClickThreshhold;
    }

    public void doClick() {
        this.doClick(68);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$ChangeListener == null ? AbstractButton.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n2 + 1]).stateChanged(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    private void updateMnemonicProperties() {
        int n2 = this.model.getMnemonic();
        if (this.mnemonic != n2) {
            int n3 = this.mnemonic;
            this.mnemonic = n2;
            this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, n3, this.mnemonic);
            this.updateDisplayedMnemonicIndex(this.getText(), this.mnemonic);
            this.revalidate();
            this.repaint();
        }
    }

    public void updateUI() {
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public boolean isFocusPainted() {
        return this.paintFocus;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    public boolean isSelected() {
        return this.model.isSelected();
    }

    public void setMnemonic(char n2) {
        int n3 = n2;
        if (n3 >= 97 && n3 <= 122) {
            n3 -= 32;
        }
        this.setMnemonic(n3);
    }

    public void doClick(int n2) {
        Dimension dimension = this.getSize();
        this.model.setArmed(true);
        this.model.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, dimension.width, dimension.height));
        try {
            Thread.currentThread();
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.model.setPressed(false);
        this.model.setArmed(false);
    }

    public void setDisplayedMnemonicIndex(int n2) throws IllegalArgumentException {
        int n3 = this.mnemonicIndex;
        if (n2 == -1) {
            this.mnemonicIndex = -1;
        } else {
            int n4;
            String string = this.getText();
            int n5 = n4 = string == null ? 0 : string.length();
            if (n2 < -1 || n2 >= n4) {
                throw new IllegalArgumentException("index == " + n2);
            }
        }
        this.mnemonicIndex = n2;
        this.firePropertyChange("displayedMnemonicIndex", n3, n2);
        if (n2 != n3) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setHorizontalAlignment(int n2) {
        if (n2 == this.horizontalAlignment) {
            return;
        }
        int n3 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n2, HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, n3, this.horizontalAlignment);
        this.repaint();
    }

    public void setHorizontalTextPosition(int n2) {
        if (n2 == this.horizontalTextPosition) {
            return;
        }
        int n3 = this.horizontalTextPosition;
        this.horizontalTextPosition = this.checkHorizontalKey(n2, HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, n3, this.horizontalTextPosition);
        this.repaint();
    }

    public void setIconTextGap(int n2) {
        int n3 = this.iconTextGap;
        this.iconTextGap = n2;
        this.firePropertyChange("iconTextGap", n3, n2);
        if (n2 != n3) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setMnemonic(int n2) {
        int n3 = this.getMnemonic();
        this.model.setMnemonic(n2);
        this.updateMnemonicProperties();
    }

    public void setVerticalAlignment(int n2) {
        if (n2 == this.verticalAlignment) {
            return;
        }
        int n3 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n2, VERTICAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, n3, this.verticalAlignment);
        this.repaint();
    }

    public void setVerticalTextPosition(int n2) {
        if (n2 == this.verticalTextPosition) {
            return;
        }
        int n3 = this.verticalTextPosition;
        this.verticalTextPosition = this.checkVerticalKey(n2, VERTICAL_TEXT_POSITION_CHANGED_PROPERTY);
        this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, n3, this.verticalTextPosition);
        this.repaint();
    }

    public void setMultiClickThreshhold(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("threshhold must be >= 0");
        }
        this.multiClickThreshhold = l2;
    }

    public void setBorderPainted(boolean bl2) {
        boolean bl3 = this.paintBorder;
        this.paintBorder = bl2;
        this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, bl3, this.paintBorder);
        if (bl2 != bl3) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setContentAreaFilled(boolean bl2) {
        boolean bl3 = this.contentAreaFilled;
        this.contentAreaFilled = bl2;
        this.firePropertyChange(CONTENT_AREA_FILLED_CHANGED_PROPERTY, bl3, this.contentAreaFilled);
        if (bl2 != bl3) {
            this.repaint();
        }
    }

    public void setEnabled(boolean bl2) {
        if (!bl2 && this.model.isRollover()) {
            this.model.setRollover(false);
        }
        super.setEnabled(bl2);
        this.model.setEnabled(bl2);
    }

    public void setFocusPainted(boolean bl2) {
        boolean bl3 = this.paintFocus;
        this.paintFocus = bl2;
        this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, bl3, this.paintFocus);
        if (bl2 != bl3 && this.isFocusOwner()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setRolloverEnabled(boolean bl2) {
        boolean bl3 = this.rolloverEnabled;
        this.rolloverEnabled = bl2;
        this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, bl3, this.rolloverEnabled);
        if (bl2 != bl3) {
            this.repaint();
        }
    }

    public void setSelected(boolean bl2) {
        boolean bl3 = this.isSelected();
        if (this.accessibleContext != null && bl3 != bl2) {
            if (bl2) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        this.model.setSelected(bl2);
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        Icon icon = this.getIcon();
        if (icon == null) {
            return false;
        }
        if (!this.model.isEnabled()) {
            icon = this.model.isSelected() ? this.getDisabledSelectedIcon() : this.getDisabledIcon();
        } else if (this.model.isPressed() && this.model.isArmed()) {
            icon = this.getPressedIcon();
        } else if (this.isRolloverEnabled() && this.model.isRollover()) {
            icon = this.model.isSelected() ? this.getRolloverSelectedIcon() : this.getRolloverIcon();
        } else if (this.model.isSelected()) {
            icon = this.getSelectedIcon();
        }
        if (!SwingUtilities.doesIconReferenceImage(icon, image)) {
            return false;
        }
        return super.imageUpdate(image, n2, n3, n4, n5, n6);
    }

    public Insets getMargin() {
        return this.margin == null ? null : (Insets)this.margin.clone();
    }

    public void setMargin(Insets insets) {
        if (insets instanceof UIResource) {
            this.defaultMargin = insets;
        } else if (this.margin instanceof UIResource) {
            this.defaultMargin = this.margin;
        }
        if (insets == null && this.defaultMargin != null) {
            insets = this.defaultMargin;
        }
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange(MARGIN_CHANGED_PROPERTY, insets2, insets);
        if (insets2 == null || !insets.equals(insets2)) {
            this.revalidate();
            this.repaint();
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent2 = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$ActionListener == null ? AbstractButton.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                if (actionEvent2 == null) {
                    String string = actionEvent.getActionCommand();
                    if (string == null) {
                        string = this.getActionCommand();
                    }
                    actionEvent2 = new ActionEvent(this, 1001, string, actionEvent.getWhen(), actionEvent.getModifiers());
                }
                ((ActionListener)objectArray[n2 + 1]).actionPerformed(actionEvent2);
            }
            n2 -= 2;
        }
    }

    protected ActionListener createActionListener() {
        return new ForwardActionEvents(this, null);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$ItemListener == null ? AbstractButton.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                if (itemEvent2 == null) {
                    itemEvent2 = new ItemEvent(this, 701, this, itemEvent.getStateChange());
                }
                ((ItemListener)objectArray[n2 + 1]).itemStateChanged(itemEvent2);
            }
            n2 -= 2;
        }
        if (this.accessibleContext != null) {
            if (itemEvent.getStateChange() == 1) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
                this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(0), new Integer(1));
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
                this.accessibleContext.firePropertyChange("AccessibleValue", new Integer(1), new Integer(0));
            }
        }
    }

    protected ItemListener createItemListener() {
        return new ForwardItemEvents(this, null);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        if (!this.isSelected()) {
            return null;
        }
        Object[] objectArray = new Object[]{this.getText()};
        return objectArray;
    }

    public String getActionCommand() {
        String string = this.getModel().getActionCommand();
        if (string == null) {
            string = this.getText();
        }
        return string;
    }

    public String getLabel() {
        return this.getText();
    }

    public String getText() {
        return this.text;
    }

    protected String paramString() {
        String string = this.defaultIcon != null && this.defaultIcon != this ? this.defaultIcon.toString() : "";
        String string2 = this.pressedIcon != null && this.pressedIcon != this ? this.pressedIcon.toString() : "";
        String string3 = this.disabledIcon != null && this.disabledIcon != this ? this.disabledIcon.toString() : "";
        String string4 = this.selectedIcon != null && this.selectedIcon != this ? this.selectedIcon.toString() : "";
        String string5 = this.disabledSelectedIcon != null && this.disabledSelectedIcon != this ? this.disabledSelectedIcon.toString() : "";
        String string6 = this.rolloverIcon != null && this.rolloverIcon != this ? this.rolloverIcon.toString() : "";
        String string7 = this.rolloverSelectedIcon != null && this.rolloverSelectedIcon != this ? this.rolloverSelectedIcon.toString() : "";
        String string8 = this.paintBorder ? "true" : "false";
        String string9 = this.paintFocus ? "true" : "false";
        String string10 = this.rolloverEnabled ? "true" : "false";
        return super.paramString() + ",defaultIcon=" + string + ",disabledIcon=" + string3 + ",disabledSelectedIcon=" + string5 + ",margin=" + this.margin + ",paintBorder=" + string8 + ",paintFocus=" + string9 + ",pressedIcon=" + string2 + ",rolloverEnabled=" + string10 + ",rolloverIcon=" + string6 + ",rolloverSelectedIcon=" + string7 + ",selectedIcon=" + string4 + ",text=" + this.text;
    }

    protected int checkHorizontalKey(int n2, String string) {
        if (n2 == 2 || n2 == 0 || n2 == 4 || n2 == 10 || n2 == 11) {
            return n2;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n2, String string) {
        if (n2 == 1 || n2 == 0 || n2 == 3) {
            return n2;
        }
        throw new IllegalArgumentException(string);
    }

    public void setActionCommand(String string) {
        this.getModel().setActionCommand(string);
    }

    public void setLabel(String string) {
        this.setText(string);
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, string2, string);
        this.updateDisplayedMnemonicIndex(string, this.getMnemonic());
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        if (string == null || string2 == null || !string.equals(string2)) {
            this.revalidate();
            this.repaint();
        }
    }

    private void updateDisplayedMnemonicIndex(String string, int n2) {
        this.setDisplayedMnemonicIndex(SwingUtilities.findDisplayedMnemonicIndex(string, n2));
    }

    static void access$000(AbstractButton abstractButton) {
        abstractButton.updateMnemonicProperties();
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        this.configurePropertiesFromAction(action, null);
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        if (buttonModel2 != null) {
            buttonModel2.removeChangeListener(this.changeListener);
            buttonModel2.removeActionListener(this.actionListener);
            this.changeListener = null;
            this.actionListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.changeListener = this.createChangeListener();
            this.actionListener = this.createActionListener();
            this.itemListener = this.createItemListener();
            buttonModel.addChangeListener(this.changeListener);
            buttonModel.addActionListener(this.actionListener);
            buttonModel.addItemListener(this.itemListener);
            this.mnemonic = buttonModel.getMnemonic();
        } else {
            this.mnemonic = 0;
        }
        this.updateDisplayedMnemonicIndex(this.getText(), this.mnemonic);
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, buttonModel2, buttonModel);
        if (buttonModel != buttonModel2) {
            this.revalidate();
            this.repaint();
        }
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.defaultIcon != null && this.defaultIcon instanceof ImageIcon) {
            this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.defaultIcon).getImage()));
        }
        return this.disabledIcon;
    }

    public Icon getDisabledSelectedIcon() {
        if (this.disabledSelectedIcon == null) {
            if (this.selectedIcon != null && this.selectedIcon instanceof ImageIcon) {
                this.disabledSelectedIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.selectedIcon).getImage()));
            } else {
                return this.getDisabledIcon();
            }
        }
        return this.disabledSelectedIcon;
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    public Icon getPressedIcon() {
        return this.pressedIcon;
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.disabledIcon;
        this.disabledIcon = icon;
        this.firePropertyChange(DISABLED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2 && !this.isEnabled()) {
            this.repaint();
        }
    }

    public void setDisabledSelectedIcon(Icon icon) {
        Icon icon2 = this.disabledSelectedIcon;
        this.disabledSelectedIcon = icon;
        this.firePropertyChange(DISABLED_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2) {
            if (icon == null || icon2 == null || icon.getIconWidth() != icon2.getIconWidth() || icon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            if (!this.isEnabled() && this.isSelected()) {
                this.repaint();
            }
        }
    }

    public void setIcon(Icon icon) {
        AccessibleContext accessibleContext;
        Icon icon2 = this.defaultIcon;
        this.defaultIcon = icon;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.pressedIcon);
        }
        if (icon != icon2) {
            if (icon == null || icon2 == null || icon.getIconWidth() != icon2.getIconWidth() || icon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
        this.accessibleIcon = null;
        if (icon instanceof Accessible && (accessibleContext = ((Accessible)((Object)icon)).getAccessibleContext()) != null && accessibleContext instanceof AccessibleIcon) {
            this.accessibleIcon = (AccessibleIcon)((Object)accessibleContext);
        }
    }

    public void setPressedIcon(Icon icon) {
        Icon icon2 = this.pressedIcon;
        this.pressedIcon = icon;
        this.firePropertyChange(PRESSED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.defaultIcon);
        }
        if (icon != icon2 && this.getModel().isPressed()) {
            this.repaint();
        }
    }

    public void setRolloverIcon(Icon icon) {
        Icon icon2 = this.rolloverIcon;
        this.rolloverIcon = icon;
        this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.setRolloverEnabled(true);
        if (icon != icon2) {
            this.repaint();
        }
    }

    public void setRolloverSelectedIcon(Icon icon) {
        Icon icon2 = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = icon;
        this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.setRolloverEnabled(true);
        if (icon != icon2 && this.isSelected()) {
            this.repaint();
        }
    }

    public void setSelectedIcon(Icon icon) {
        Icon icon2 = this.selectedIcon;
        this.selectedIcon = icon;
        this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2 && this.isSelected()) {
            this.repaint();
        }
    }

    protected ChangeListener createChangeListener() {
        return new ButtonChangeListener(this);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbstractButton.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbstractButton.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AbstractButton.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl2 = false;
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == clazz && objectArray[n2 + 1] == actionListener) {
                bl2 = true;
            }
            n2 -= 2;
        }
        return bl2;
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new ButtonActionPropertyChangeListener(this, action);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void configurePropertiesFromAction(Action action, String[] stringArray) {
        if (stringArray == null) {
            String[] stringArray2 = new String[]{"MnemonicKey", "Name", "ShortDescription", "SmallIcon", "ActionCommandKey", "enabled"};
            stringArray = stringArray2;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (string != null) {
                if (string.equals("MnemonicKey")) {
                    Integer n3 = action == null ? null : (Integer)action.getValue(string);
                    this.setMnemonic(n3 == null ? 0 : n3);
                } else if (string.equals("Name")) {
                    this.setText(action != null ? (String)action.getValue(string) : null);
                } else if (string.equals("ShortDescription")) {
                    this.setToolTipText(action != null ? (String)action.getValue(string) : null);
                } else if (string.equals("SmallIcon")) {
                    this.setIcon(action != null ? (Icon)action.getValue(string) : null);
                } else if (string.equals("ActionCommandKey")) {
                    this.setActionCommand(action != null ? (String)action.getValue(string) : null);
                } else if (string.equals("enabled")) {
                    this.setEnabled(action != null ? action.isEnabled() : true);
                }
            }
            ++n2;
        }
    }

    static AccessibleIcon access$300(AbstractButton abstractButton) {
        return abstractButton.accessibleIcon;
    }

    protected void init(String string, Icon icon) {
        this.setLayout(new OverlayLayout(this));
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.updateUI();
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.5f);
    }

    class 1 {
    }

    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue,
    AccessibleText,
    AccessibleExtendedComponent {
        private final AbstractButton this$0;

        public int getAccessibleActionCount() {
            return 1;
        }

        public int getCaretPosition() {
            return -1;
        }

        public int getCharCount() {
            Document document;
            View view = (View)this.this$0.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                return styledDocument.getLength();
            }
            return this.this$0.accessibleContext.getAccessibleName().length();
        }

        public int getSelectionEnd() {
            return -1;
        }

        public int getSelectionStart() {
            return -1;
        }

        public boolean doAccessibleAction(int n2) {
            if (n2 == 0) {
                this.this$0.doClick();
                return true;
            }
            return false;
        }

        public int getIndexAtPoint(Point point) {
            View view = (View)this.this$0.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = this.getTextRectangle();
                if (rectangle == null) {
                    return -1;
                }
                Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Position.Bias[] biasArray = new Position.Bias[1];
                return view.viewToModel(point.x, point.y, float_, biasArray);
            }
            return -1;
        }

        private Rectangle getTextRectangle() {
            Icon icon;
            String string = this.this$0.getText();
            Icon icon2 = icon = this.this$0.isEnabled() ? this.this$0.getIcon() : this.this$0.getDisabledIcon();
            if (icon == null && string == null) {
                return null;
            }
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            Insets insets = new Insets(0, 0, 0, 0);
            insets = this.this$0.getInsets(insets);
            rectangle3.x = insets.left;
            rectangle3.y = insets.top;
            rectangle3.width = this.this$0.getWidth() - (insets.left + insets.right);
            rectangle3.height = this.this$0.getHeight() - (insets.top + insets.bottom);
            Graphics graphics = this.this$0.getGraphics();
            if (graphics == null) {
                return null;
            }
            String string2 = SwingUtilities.layoutCompoundLabel(this.this$0, graphics.getFontMetrics(), string, icon, this.this$0.getVerticalAlignment(), this.this$0.getHorizontalAlignment(), this.this$0.getVerticalTextPosition(), this.this$0.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, 0);
            return rectangle2;
        }

        public Rectangle getCharacterBounds(int n2) {
            View view = (View)this.this$0.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = this.getTextRectangle();
                if (rectangle == null) {
                    return null;
                }
                Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                try {
                    Shape shape = view.modelToView(n2, float_, Position.Bias.Forward);
                    return shape.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return null;
        }

        public Number getCurrentAccessibleValue() {
            if (this.this$0.isSelected()) {
                return new Integer(1);
            }
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(1);
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                int n2 = number.intValue();
                if (n2 == 0) {
                    this.this$0.setSelected(false);
                } else {
                    this.this$0.setSelected(true);
                }
                return true;
            }
            return false;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.this$0.getText() == null) {
                return super.getAccessibleName();
            }
            return this.this$0.getText();
        }

        public String getSelectedText() {
            return null;
        }

        public String getTitledBorderText() {
            return super.getTitledBorderText();
        }

        public String getToolTipText() {
            return this.this$0.getToolTipText();
        }

        public String getAccessibleActionDescription(int n2) {
            if (n2 == 0) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        public String getAfterIndex(int n2, int n3) {
            if (n3 < 0 || n3 >= this.getCharCount()) {
                return null;
            }
            switch (n2) {
                case 1: {
                    if (n3 + 1 >= this.getCharCount()) {
                        return null;
                    }
                    try {
                        return this.getText(n3 + 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n3);
                        if (n4 == -1 || n4 >= string.length()) {
                            return null;
                        }
                        int n5 = breakIterator.following(n4);
                        if (n5 == -1 || n5 >= string.length()) {
                            return null;
                        }
                        return string.substring(n4, n5);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n6 = breakIterator.following(n3);
                        if (n6 == -1 || n6 >= string.length()) {
                            return null;
                        }
                        int n7 = breakIterator.following(n6);
                        if (n7 == -1 || n7 >= string.length()) {
                            return null;
                        }
                        return string.substring(n6, n7);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getAtIndex(int n2, int n3) {
            if (n3 < 0 || n3 >= this.getCharCount()) {
                return null;
            }
            switch (n2) {
                case 1: {
                    try {
                        return this.getText(n3, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n3);
                        return string.substring(breakIterator.previous(), n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n5 = breakIterator.following(n3);
                        return string.substring(breakIterator.previous(), n5);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getBeforeIndex(int n2, int n3) {
            if (n3 < 0 || n3 > this.getCharCount() - 1) {
                return null;
            }
            switch (n2) {
                case 1: {
                    if (n3 == 0) {
                        return null;
                    }
                    try {
                        return this.getText(n3 - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n3);
                        n4 = breakIterator.previous();
                        int n5 = breakIterator.previous();
                        if (n5 == -1) {
                            return null;
                        }
                        return string.substring(n5, n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n6 = breakIterator.following(n3);
                        n6 = breakIterator.previous();
                        int n7 = breakIterator.previous();
                        if (n7 == -1) {
                            return null;
                        }
                        return string.substring(n7, n6);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        private String getText(int n2, int n3) throws BadLocationException {
            Document document;
            View view = (View)this.this$0.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                return styledDocument.getText(n2, n3);
            }
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        AccessibleExtendedComponent getAccessibleExtendedComponent() {
            return this;
        }

        public AccessibleIcon[] getAccessibleIcon() {
            if (AbstractButton.access$300(this.this$0) == null) {
                return null;
            }
            AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{AbstractButton.access$300(this.this$0)};
            return accessibleIconArray;
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            int n2 = this.this$0.getMnemonic();
            if (n2 == 0) {
                return null;
            }
            return new ButtonKeyBinding(this, n2);
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            ButtonGroup buttonGroup;
            ButtonModel buttonModel;
            AccessibleRelationSet accessibleRelationSet = super.getAccessibleRelationSet();
            if (!accessibleRelationSet.contains(AccessibleRelation.MEMBER_OF) && (buttonModel = this.this$0.getModel()) != null && buttonModel instanceof DefaultButtonModel && (buttonGroup = ((DefaultButtonModel)buttonModel).getGroup()) != null) {
                int n2 = buttonGroup.getButtonCount();
                Object[] objectArray = new Object[n2];
                Enumeration enumeration = buttonGroup.getElements();
                int n3 = 0;
                while (n3 < n2) {
                    if (enumeration.hasMoreElements()) {
                        objectArray[n3] = enumeration.nextElement();
                    }
                    ++n3;
                }
                AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.MEMBER_OF);
                accessibleRelation.setTarget(objectArray);
                accessibleRelationSet.add(accessibleRelation);
            }
            return accessibleRelationSet;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getModel().isArmed()) {
                accessibleStateSet.add(AccessibleState.ARMED);
            }
            if (this.this$0.isFocusOwner()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (this.this$0.getModel().isPressed()) {
                accessibleStateSet.add(AccessibleState.PRESSED);
            }
            if (this.this$0.isSelected()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        public AccessibleText getAccessibleText() {
            View view = (View)this.this$0.getClientProperty("html");
            if (view != null) {
                return this;
            }
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        protected AccessibleAbstractButton(AbstractButton abstractButton) {
            this.this$0 = abstractButton;
            super(abstractButton);
        }

        public AttributeSet getCharacterAttribute(int n2) {
            StyledDocument styledDocument;
            Element element;
            Document document;
            View view = (View)this.this$0.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument && (element = (styledDocument = (StyledDocument)document).getCharacterElement(n2)) != null) {
                return element.getAttributes();
            }
            return null;
        }

        class ButtonKeyBinding
        implements AccessibleKeyBinding {
            int mnemonic;
            private final AccessibleAbstractButton this$1;

            public int getAccessibleKeyBindingCount() {
                return 1;
            }

            public Object getAccessibleKeyBinding(int n2) {
                if (n2 != 0) {
                    throw new IllegalArgumentException();
                }
                return KeyStroke.getKeyStroke(this.mnemonic, 0);
            }

            ButtonKeyBinding(AccessibleAbstractButton accessibleAbstractButton, int n2) {
                this.this$1 = accessibleAbstractButton;
                this.mnemonic = n2;
            }
        }
    }

    private static class ButtonActionPropertyChangeListener
    extends AbstractActionPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            AbstractButton abstractButton = (AbstractButton)this.getTarget();
            if (abstractButton == null) {
                Action action = (Action)propertyChangeEvent.getSource();
                action.removePropertyChangeListener(this);
            } else if (propertyChangeEvent.getPropertyName().equals("Name")) {
                Boolean bl2 = (Boolean)abstractButton.getClientProperty("hideActionText");
                if (bl2 == null || bl2 == Boolean.FALSE) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    abstractButton.setText(string2);
                    abstractButton.repaint();
                }
            } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                String string3 = (String)propertyChangeEvent.getNewValue();
                abstractButton.setToolTipText(string3);
            } else if (string.equals("enabled")) {
                Boolean bl3 = (Boolean)propertyChangeEvent.getNewValue();
                abstractButton.setEnabled(bl3);
                abstractButton.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                abstractButton.setIcon(icon);
                abstractButton.invalidate();
                abstractButton.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("MnemonicKey")) {
                Integer n2 = (Integer)propertyChangeEvent.getNewValue();
                abstractButton.setMnemonic(n2);
                abstractButton.invalidate();
                abstractButton.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("ActionCommandKey")) {
                abstractButton.setActionCommand((String)propertyChangeEvent.getNewValue());
            }
        }

        ButtonActionPropertyChangeListener(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
        }
    }

    protected class ButtonChangeListener
    implements ChangeListener,
    Serializable {
        private final AbstractButton this$0;

        ButtonChangeListener(AbstractButton abstractButton) {
            this.this$0 = abstractButton;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            AbstractButton.access$000(this.this$0);
            this.this$0.fireStateChanged();
            this.this$0.repaint();
        }
    }

    private class ForwardActionEvents
    implements ActionListener,
    Serializable {
        private final AbstractButton this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.fireActionPerformed(actionEvent);
        }

        private ForwardActionEvents(AbstractButton abstractButton) {
            this.this$0 = abstractButton;
        }

        ForwardActionEvents(AbstractButton abstractButton, 1 var2_2) {
            this(abstractButton);
        }
    }

    private class ForwardItemEvents
    implements ItemListener,
    Serializable {
        private final AbstractButton this$0;

        public void itemStateChanged(ItemEvent itemEvent) {
            this.this$0.fireItemStateChanged(itemEvent);
        }

        private ForwardItemEvents(AbstractButton abstractButton) {
            this.this$0 = abstractButton;
        }

        ForwardItemEvents(AbstractButton abstractButton, 1 var2_2) {
            this(abstractButton);
        }
    }
}

