/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled.spi;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class FormatConversionProvider {
    public abstract AudioFormat.Encoding[] getSourceEncodings();

    public abstract AudioFormat.Encoding[] getTargetEncodings();

    public boolean isSourceEncodingSupported(AudioFormat.Encoding encoding) {
        AudioFormat.Encoding[] encodingArray = this.getSourceEncodings();
        int n2 = 0;
        while (n2 < encodingArray.length) {
            if (encoding.equals(encodingArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding encoding) {
        AudioFormat.Encoding[] encodingArray = this.getTargetEncodings();
        int n2 = 0;
        while (n2 < encodingArray.length) {
            if (encoding.equals(encodingArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        AudioFormat[] audioFormatArray = this.getTargetFormats(audioFormat.getEncoding(), audioFormat2);
        int n2 = 0;
        while (n2 < audioFormatArray.length) {
            if (audioFormat.matches(audioFormatArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        AudioFormat.Encoding[] encodingArray = this.getTargetEncodings(audioFormat);
        int n2 = 0;
        while (n2 < encodingArray.length) {
            if (encoding.equals(encodingArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public abstract AudioFormat.Encoding[] getTargetEncodings(AudioFormat var1);

    public abstract AudioFormat[] getTargetFormats(AudioFormat.Encoding var1, AudioFormat var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat var1, AudioInputStream var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat.Encoding var1, AudioInputStream var2);
}

