/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;
    private static final String defaultServicesClassName = "com.sun.media.sound.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.media.sound.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AudioSystem.class$("java.lang.String")) : class$java$lang$String};
    static Class class$java$lang$String;

    private AudioSystem() {
    }

    private static Vector getMixerProviders() {
        Vector vector = null;
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.MixerProvider");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.MixerProvider");
        }
        return vector;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] typeArrayArray = new AudioFileFormat.Type[audioFileWriterArray.length][];
        AudioFileFormat.Type[] typeArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < audioFileWriterArray.length) {
            typeArrayArray[n4] = audioFileWriterArray[n4].getAudioFileTypes();
            n2 += typeArrayArray[n4].length;
            ++n4;
        }
        typeArray = new AudioFileFormat.Type[n2];
        int n5 = 0;
        while (n5 < audioFileWriterArray.length) {
            int n6 = 0;
            while (n6 < typeArrayArray[n5].length) {
                typeArray[n3] = typeArrayArray[n5][n6];
                ++n3;
                ++n6;
            }
            ++n5;
        }
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < audioFileWriterArray.length) {
            bl2 = audioFileWriterArray[n2].isFileTypeSupported(type);
            if (bl2) {
                return bl2;
            }
            ++n2;
        }
        return bl2;
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n2 = 0;
        while (n2 < infoArray.length) {
            Mixer mixer;
            if (infoArray[n2] != null && (mixer = AudioSystem.getMixer(infoArray[n2])).isLineSupported(info)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Mixer.Info[] getMixerInfo() {
        Vector vector = AudioSystem.getMixerProviders();
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < vector.size()) {
            Mixer.Info[] infoArray = ((MixerProvider)vector.elementAt(n2)).getMixerInfo();
            int n3 = 0;
            while (n3 < infoArray.length) {
                vector2.addElement(infoArray[n3]);
                ++n3;
            }
            ++n2;
        }
        Mixer.Info[] infoArray = new Mixer.Info[vector2.size()];
        n2 = 0;
        while (n2 < infoArray.length) {
            infoArray[n2] = (Mixer.Info)vector2.elementAt(n2);
            ++n2;
        }
        return infoArray;
    }

    private static AudioFileReader[] getAudioFileReaders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileReader");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileReader");
        }
        AudioFileReader[] audioFileReaderArray = new AudioFileReader[vector.size()];
        int n2 = 0;
        while (n2 < audioFileReaderArray.length) {
            audioFileReaderArray[n2] = (AudioFileReader)vector.elementAt(n2);
            ++n2;
        }
        return audioFileReaderArray;
    }

    private static AudioFileWriter[] getAudioFileWriters() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.AudioFileWriter");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.AudioFileWriter");
        }
        AudioFileWriter[] audioFileWriterArray = new AudioFileWriter[vector.size()];
        int n2 = 0;
        while (n2 < audioFileWriterArray.length) {
            audioFileWriterArray[n2] = (AudioFileWriter)vector.elementAt(n2);
            ++n2;
        }
        return audioFileWriterArray;
    }

    private static FormatConversionProvider[] getFormatConversionProviders() {
        Vector vector = new Vector();
        try {
            Class.forName("sun.misc.Service");
            vector = AudioSystem.getJDK13Services("javax.sound.sampled.spi.FormatConversionProvider");
        }
        catch (Exception exception) {
            vector = AudioSystem.getDefaultServices("javax.sound.sampled.spi.FormatConversionProvider");
        }
        FormatConversionProvider[] formatConversionProviderArray = new FormatConversionProvider[vector.size()];
        int n2 = 0;
        while (n2 < formatConversionProviderArray.length) {
            formatConversionProviderArray[n2] = (FormatConversionProvider)vector.elementAt(n2);
            ++n2;
        }
        return formatConversionProviderArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static Vector getDefaultServices(String string) {
        Vector vector = null;
        try {
            Class clazz = Class.forName(defaultServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    private static Vector getJDK13Services(String string) {
        Vector vector = null;
        try {
            Class clazz = Class.forName(jdk13ServicesClassName);
            Method method = clazz.getMethod(servicesMethodName, servicesParamTypes);
            Object[] objectArray = new Object[]{string};
            vector = (Vector)method.invoke(clazz, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            vector = new Vector();
        }
        catch (ClassNotFoundException classNotFoundException) {
            vector = new Vector();
        }
        catch (IllegalAccessException illegalAccessException) {
            vector = new Vector();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector = new Vector();
        }
        return vector;
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        int n2 = audioFileReaderArray.length - 1;
        while (n2 >= 0) {
            try {
                audioFileFormat = audioFileReaderArray[n2].getAudioFileFormat(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n2;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        int n2 = audioFileReaderArray.length - 1;
        while (n2 >= 0) {
            try {
                audioFileFormat = audioFileReaderArray[n2].getAudioFileFormat(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n2;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        int n2 = audioFileReaderArray.length - 1;
        while (n2 >= 0) {
            try {
                audioFileFormat = audioFileReaderArray[n2].getAudioFileFormat(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n2;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        AudioFileFormat.Type[][] typeArrayArray = new AudioFileFormat.Type[audioFileWriterArray.length][];
        AudioFileFormat.Type[] typeArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < audioFileWriterArray.length) {
            typeArrayArray[n4] = audioFileWriterArray[n4].getAudioFileTypes(audioInputStream);
            n2 += typeArrayArray[n4].length;
            ++n4;
        }
        typeArray = new AudioFileFormat.Type[n2];
        int n5 = 0;
        while (n5 < audioFileWriterArray.length) {
            int n6 = 0;
            while (n6 < typeArrayArray[n5].length) {
                typeArray[n3] = typeArrayArray[n5][n6];
                ++n3;
                ++n6;
            }
            ++n5;
        }
        return typeArray;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        int n2 = 0;
        while (n2 < formatConversionProviderArray.length) {
            if (formatConversionProviderArray[n2].isConversionSupported(audioFormat, audioFormat2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        int n2 = 0;
        while (n2 < formatConversionProviderArray.length) {
            if (formatConversionProviderArray[n2].isConversionSupported(encoding, audioFormat)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        int n4 = 0;
        while (n4 < formatConversionProviderArray.length) {
            encodingArray = formatConversionProviderArray[n4].getTargetEncodings(audioFormat);
            n2 += encodingArray.length;
            vector.addElement(encodingArray);
            ++n4;
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n2];
        int n5 = 0;
        while (n5 < vector.size()) {
            encodingArray = (AudioFormat.Encoding[])vector.elementAt(n5);
            int n6 = 0;
            while (n6 < encodingArray.length) {
                encodingArray2[n3++] = encodingArray[n6];
                ++n6;
            }
            ++n5;
        }
        return encodingArray2;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        int n4 = 0;
        while (n4 < formatConversionProviderArray.length) {
            if (formatConversionProviderArray[n4].isSourceEncodingSupported(encoding)) {
                encodingArray = formatConversionProviderArray[n4].getTargetEncodings();
                n2 += encodingArray.length;
                vector.addElement(encodingArray);
            }
            ++n4;
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n2];
        int n5 = 0;
        while (n5 < vector.size()) {
            encodingArray = (AudioFormat.Encoding[])vector.elementAt(n5);
            int n6 = 0;
            while (n6 < encodingArray.length) {
                encodingArray2[n3++] = encodingArray[n6];
                ++n6;
            }
            ++n5;
        }
        return encodingArray2;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        int n2 = audioFileReaderArray.length - 1;
        while (n2 >= 0) {
            try {
                audioInputStream = audioFileReaderArray[n2].getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n2;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        int n2 = audioFileReaderArray.length - 1;
        while (n2 >= 0) {
            try {
                audioInputStream = audioFileReaderArray[n2].getAudioInputStream(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n2;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileReader[] audioFileReaderArray = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        int n2 = audioFileReaderArray.length - 1;
        while (n2 >= 0) {
            try {
                audioInputStream = audioFileReaderArray[n2].getAudioInputStream(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                --n2;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioInputStream;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < audioFileWriterArray.length) {
            bl2 = audioFileWriterArray[n2].isFileTypeSupported(type, audioInputStream);
            if (bl2) {
                return bl2;
            }
            ++n2;
        }
        return bl2;
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        LineUnavailableException lineUnavailableException = null;
        int n2 = 0;
        while (n2 < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n2]);
            if (mixer.isLineSupported(info)) {
                try {
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException lineUnavailableException2) {
                    lineUnavailableException = lineUnavailableException2;
                }
            }
            ++n2;
        }
        if (lineUnavailableException != null) {
            throw lineUnavailableException;
        }
        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector vector = new Vector();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n2 = 0;
        while (n2 < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n2]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo(info);
            int n3 = 0;
            while (n3 < infoArray2.length) {
                vector.addElement(infoArray2[n3]);
                ++n3;
            }
            ++n2;
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        int n4 = 0;
        while (n4 < infoArray3.length) {
            infoArray3[n4] = (Line.Info)vector.elementAt(n4);
            ++n4;
        }
        return infoArray3;
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector vector = new Vector();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n2 = 0;
        while (n2 < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n2]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo(info);
            int n3 = 0;
            while (n3 < infoArray2.length) {
                vector.addElement(infoArray2[n3]);
                ++n3;
            }
            ++n2;
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        int n4 = 0;
        while (n4 < infoArray3.length) {
            infoArray3[n4] = (Line.Info)vector.elementAt(n4);
            ++n4;
        }
        return infoArray3;
    }

    public static Mixer getMixer(Mixer.Info info) {
        Object var1_1 = null;
        Vector vector = AudioSystem.getMixerProviders();
        int n2 = 0;
        while (n2 < vector.size()) {
            try {
                return ((MixerProvider)vector.elementAt(n2)).getMixer(info);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++n2;
        }
        throw new IllegalArgumentException("Mixer not supported: " + info.toString());
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        int n2 = 0;
        boolean bl2 = false;
        int n3 = audioFileWriterArray.length - 1;
        while (n3 >= 0) {
            try {
                n2 = audioFileWriterArray[n3].write(audioInputStream, type, file);
                bl2 = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                --n3;
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n2;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        AudioFileWriter[] audioFileWriterArray = AudioSystem.getAudioFileWriters();
        int n2 = 0;
        boolean bl2 = false;
        int n3 = audioFileWriterArray.length - 1;
        while (n3 >= 0) {
            try {
                n2 = audioFileWriterArray[n3].write(audioInputStream, type, outputStream);
                bl2 = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                --n3;
            }
        }
        if (!bl2) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n2;
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 0;
        AudioFormat[] audioFormatArray = null;
        int n4 = 0;
        while (n4 < formatConversionProviderArray.length) {
            audioFormatArray = formatConversionProviderArray[n4].getTargetFormats(encoding, audioFormat);
            n2 += audioFormatArray.length;
            vector.addElement(audioFormatArray);
            ++n4;
        }
        AudioFormat[] audioFormatArray2 = new AudioFormat[n2];
        int n5 = 0;
        while (n5 < vector.size()) {
            audioFormatArray = (AudioFormat[])vector.elementAt(n5);
            int n6 = 0;
            while (n6 < audioFormatArray.length) {
                audioFormatArray2[n3++] = audioFormatArray[n6];
                ++n6;
            }
            ++n5;
        }
        return audioFormatArray2;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().matches(audioFormat)) {
            return audioInputStream;
        }
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        int n2 = formatConversionProviderArray.length - 1;
        while (n2 >= 0) {
            if (formatConversionProviderArray[n2].isConversionSupported(audioFormat, audioInputStream.getFormat())) {
                return formatConversionProviderArray[n2].getAudioInputStream(audioFormat, audioInputStream);
            }
            --n2;
        }
        throw new IllegalArgumentException("Unsupported conversion: " + audioFormat + " from " + audioInputStream.getFormat());
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        FormatConversionProvider[] formatConversionProviderArray = AudioSystem.getFormatConversionProviders();
        int n2 = formatConversionProviderArray.length - 1;
        while (n2 >= 0) {
            if (formatConversionProviderArray[n2].isConversionSupported(encoding, audioInputStream.getFormat())) {
                return formatConversionProviderArray[n2].getAudioInputStream(encoding, audioInputStream);
            }
            --n2;
        }
        throw new IllegalArgumentException("Unsupported conversion: " + encoding + " from " + audioInputStream.getFormat());
    }
}

