/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageTypeSpecifier;

public class ImageReadParam
extends IIOParam {
    protected boolean canSetSourceRenderSize = false;
    protected Dimension sourceRenderSize = null;
    protected BufferedImage destination = null;
    protected int[] destinationBands = null;
    protected int minProgressivePass = 0;
    protected int numProgressivePasses = Integer.MAX_VALUE;

    public int getSourceMaxProgressivePass() {
        if (this.numProgressivePasses == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.minProgressivePass + this.numProgressivePasses - 1;
    }

    public int getSourceMinProgressivePass() {
        return this.minProgressivePass;
    }

    public int getSourceNumProgressivePasses() {
        return this.numProgressivePasses;
    }

    public boolean canSetSourceRenderSize() {
        return this.canSetSourceRenderSize;
    }

    public int[] getDestinationBands() {
        if (this.destinationBands == null) {
            return null;
        }
        return (int[])this.destinationBands.clone();
    }

    public void setSourceProgressivePasses(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("minPass < 0!");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("numPasses <= 0!");
        }
        if (n3 != Integer.MAX_VALUE && (n2 + n3 - 1 & Integer.MIN_VALUE) != 0) {
            throw new IllegalArgumentException("minPass + numPasses - 1 > INTEGER.MAX_VALUE!");
        }
        this.minProgressivePass = n2;
        this.numProgressivePasses = n3;
    }

    public void setDestinationBands(int[] nArray) {
        if (nArray == null) {
            this.destinationBands = null;
        } else {
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n3];
                if (n4 < 0) {
                    throw new IllegalArgumentException("Band value < 0!");
                }
                int n5 = n3 + 1;
                while (n5 < n2) {
                    if (n4 == nArray[n5]) {
                        throw new IllegalArgumentException("Duplicate band value!");
                    }
                    ++n5;
                }
                ++n3;
            }
            this.destinationBands = (int[])nArray.clone();
        }
    }

    public Dimension getSourceRenderSize() {
        return this.sourceRenderSize == null ? null : (Dimension)this.sourceRenderSize.clone();
    }

    public void setSourceRenderSize(Dimension dimension) throws UnsupportedOperationException {
        if (!this.canSetSourceRenderSize()) {
            throw new UnsupportedOperationException("Can't set source render size!");
        }
        if (dimension == null) {
            this.sourceRenderSize = null;
        } else {
            if (dimension.width <= 0 || dimension.height <= 0) {
                throw new IllegalArgumentException("width or height <= 0!");
            }
            this.sourceRenderSize = (Dimension)dimension.clone();
        }
    }

    public BufferedImage getDestination() {
        return this.destination;
    }

    public void setDestination(BufferedImage bufferedImage) {
        this.destination = bufferedImage;
    }

    public void setDestinationType(ImageTypeSpecifier imageTypeSpecifier) {
        super.setDestinationType(imageTypeSpecifier);
        this.setDestination(null);
    }
}

