/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;

public abstract class AccessibleContext {
    public static final String ACCESSIBLE_NAME_PROPERTY = "AccessibleName";
    public static final String ACCESSIBLE_DESCRIPTION_PROPERTY = "AccessibleDescription";
    public static final String ACCESSIBLE_STATE_PROPERTY = "AccessibleState";
    public static final String ACCESSIBLE_VALUE_PROPERTY = "AccessibleValue";
    public static final String ACCESSIBLE_SELECTION_PROPERTY = "AccessibleSelection";
    public static final String ACCESSIBLE_TEXT_PROPERTY = "AccessibleText";
    public static final String ACCESSIBLE_CARET_PROPERTY = "AccessibleCaret";
    public static final String ACCESSIBLE_VISIBLE_DATA_PROPERTY = "AccessibleVisibleData";
    public static final String ACCESSIBLE_CHILD_PROPERTY = "AccessibleChild";
    public static final String ACCESSIBLE_ACTIVE_DESCENDANT_PROPERTY = "AccessibleActiveDescendant";
    public static final String ACCESSIBLE_TABLE_CAPTION_CHANGED = "accessibleTableCaptionChanged";
    public static final String ACCESSIBLE_TABLE_SUMMARY_CHANGED = "accessibleTableSummaryChanged";
    public static final String ACCESSIBLE_TABLE_MODEL_CHANGED = "accessibleTableModelChanged";
    public static final String ACCESSIBLE_TABLE_ROW_HEADER_CHANGED = "accessibleTableRowHeaderChanged";
    public static final String ACCESSIBLE_TABLE_ROW_DESCRIPTION_CHANGED = "accessibleTableRowDescriptionChanged";
    public static final String ACCESSIBLE_TABLE_COLUMN_HEADER_CHANGED = "accessibleTableColumnHeaderChanged";
    public static final String ACCESSIBLE_TABLE_COLUMN_DESCRIPTION_CHANGED = "accessibleTableColumnDescriptionChanged";
    public static final String ACCESSIBLE_ACTION_PROPERTY = "accessibleActionProperty";
    public static final String ACCESSIBLE_HYPERTEXT_OFFSET = "AccessibleHypertextOffset";
    protected Accessible accessibleParent = null;
    protected String accessibleName = null;
    protected String accessibleDescription = null;
    private PropertyChangeSupport accessibleChangeSupport = null;
    private AccessibleRelationSet relationSet = new AccessibleRelationSet();

    public abstract int getAccessibleChildrenCount();

    public abstract int getAccessibleIndexInParent();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.accessibleChangeSupport == null) {
            this.accessibleChangeSupport = new PropertyChangeSupport(this);
        }
        this.accessibleChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.accessibleChangeSupport != null) {
            this.accessibleChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public String getAccessibleDescription() {
        return this.accessibleDescription;
    }

    public String getAccessibleName() {
        return this.accessibleName;
    }

    public void setAccessibleDescription(String string) {
        String string2 = this.accessibleDescription;
        this.accessibleDescription = string;
        this.firePropertyChange(ACCESSIBLE_DESCRIPTION_PROPERTY, string2, this.accessibleDescription);
    }

    public void setAccessibleName(String string) {
        String string2 = this.accessibleName;
        this.accessibleName = string;
        this.firePropertyChange(ACCESSIBLE_NAME_PROPERTY, string2, this.accessibleName);
    }

    public abstract Locale getLocale() throws IllegalComponentStateException;

    public Accessible getAccessibleParent() {
        return this.accessibleParent;
    }

    public abstract Accessible getAccessibleChild(int var1);

    public void setAccessibleParent(Accessible accessible) {
        this.accessibleParent = accessible;
    }

    public AccessibleAction getAccessibleAction() {
        return null;
    }

    public AccessibleComponent getAccessibleComponent() {
        return null;
    }

    public AccessibleEditableText getAccessibleEditableText() {
        return null;
    }

    public AccessibleIcon[] getAccessibleIcon() {
        return null;
    }

    public AccessibleRelationSet getAccessibleRelationSet() {
        return this.relationSet;
    }

    public abstract AccessibleRole getAccessibleRole();

    public AccessibleSelection getAccessibleSelection() {
        return null;
    }

    public abstract AccessibleStateSet getAccessibleStateSet();

    public AccessibleTable getAccessibleTable() {
        return null;
    }

    public AccessibleText getAccessibleText() {
        return null;
    }

    public AccessibleValue getAccessibleValue() {
        return null;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (this.accessibleChangeSupport != null) {
            this.accessibleChangeSupport.firePropertyChange(string, object, object2);
        }
    }
}

