/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class Vector
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public synchronized int capacity() {
        return this.elementData.length;
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public Vector() {
        this(10);
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized void removeAllElements() {
        ++this.modCount;
        int n2 = 0;
        while (n2 < this.elementCount) {
            this.elementData[n2] = null;
            ++n2;
        }
        this.elementCount = 0;
    }

    public synchronized void trimToSize() {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (this.elementCount < n2) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Vector(int n2) {
        this(n2, 0);
    }

    public synchronized void ensureCapacity(int n2) {
        ++this.modCount;
        this.ensureCapacityHelper(n2);
    }

    private void ensureCapacityHelper(int n2) {
        int n3 = this.elementData.length;
        if (n2 > n3) {
            int n4;
            Object[] objectArray = this.elementData;
            int n5 = n4 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 2;
            if (n4 < n2) {
                n4 = n2;
            }
            this.elementData = new Object[n4];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public synchronized void removeElementAt(int n2) {
        ++this.modCount;
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public synchronized void setSize(int n2) {
        ++this.modCount;
        if (n2 > this.elementCount) {
            this.ensureCapacityHelper(n2);
        } else {
            int n3 = n2;
            while (n3 < this.elementCount) {
                this.elementData[n3] = null;
                ++n3;
            }
        }
        this.elementCount = n2;
    }

    public Vector(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        this.elementData = new Object[n2];
        this.capacityIncrement = n3;
    }

    protected void removeRange(int n2, int n3) {
        ++this.modCount;
        int n4 = this.elementCount - n3;
        System.arraycopy(this.elementData, n3, this.elementData, n2, n4);
        int n5 = this.elementCount - (n3 - n2);
        while (this.elementCount != n5) {
            this.elementData[--this.elementCount] = null;
        }
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = new Object[this.elementCount];
            System.arraycopy(this.elementData, 0, vector.elementData, 0, this.elementCount);
            vector.modCount = 0;
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public synchronized Object elementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0");
        }
    }

    public synchronized Object get(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.elementData[n2];
    }

    public synchronized Object remove(int n2) {
        ++this.modCount;
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        Object object = this.elementData[n2];
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        this.elementData[--this.elementCount] = null;
        return object;
    }

    public void add(int n2, Object object) {
        this.insertElementAt(object, n2);
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized void addElement(Object object) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
    }

    public synchronized boolean add(Object object) {
        ++this.modCount;
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = object;
        return true;
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    public boolean remove(Object object) {
        return this.removeElement(object);
    }

    public synchronized boolean removeElement(Object object) {
        ++this.modCount;
        int n2 = this.indexOf(object);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public synchronized int indexOf(Object object, int n2) {
        if (object == null) {
            int n3 = n2;
            while (n3 < this.elementCount) {
                if (this.elementData[n3] == null) {
                    return n3;
                }
                ++n3;
            }
        } else {
            int n4 = n2;
            while (n4 < this.elementCount) {
                if (object.equals(this.elementData[n4])) {
                    return n4;
                }
                ++n4;
            }
        }
        return -1;
    }

    public synchronized int lastIndexOf(Object object, int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        if (object == null) {
            int n3 = n2;
            while (n3 >= 0) {
                if (this.elementData[n3] == null) {
                    return n3;
                }
                --n3;
            }
        } else {
            int n4 = n2;
            while (n4 >= 0) {
                if (object.equals(this.elementData[n4])) {
                    return n4;
                }
                --n4;
            }
        }
        return -1;
    }

    public synchronized void insertElementAt(Object object, int n2) {
        ++this.modCount;
        if (n2 >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " > " + this.elementCount);
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = object;
        ++this.elementCount;
    }

    public synchronized void setElementAt(Object object, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        this.elementData[n2] = object;
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized String toString() {
        return super.toString();
    }

    public synchronized boolean addAll(int n2, Collection collection) {
        ++this.modCount;
        if (n2 < 0 || n2 > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        int n3 = collection.size();
        this.ensureCapacityHelper(this.elementCount + n3);
        int n4 = this.elementCount - n2;
        if (n4 > 0) {
            System.arraycopy(this.elementData, n2, this.elementData, n2 + n3, n4);
        }
        Iterator iterator = collection.iterator();
        int n5 = 0;
        while (n5 < n3) {
            this.elementData[n2++] = iterator.next();
            ++n5;
        }
        this.elementCount += n3;
        return n3 != 0;
    }

    public Vector(Collection collection) {
        this.elementCount = collection.size();
        this.elementData = new Object[(int)Math.min((long)this.elementCount * 110L / 100L, Integer.MAX_VALUE)];
        collection.toArray(this.elementData);
    }

    public synchronized boolean addAll(Collection collection) {
        ++this.modCount;
        int n2 = collection.size();
        this.ensureCapacityHelper(this.elementCount + n2);
        Iterator iterator = collection.iterator();
        int n3 = 0;
        while (n3 < n2) {
            this.elementData[this.elementCount++] = iterator.next();
            ++n3;
        }
        return n2 != 0;
    }

    public synchronized boolean containsAll(Collection collection) {
        return super.containsAll(collection);
    }

    public synchronized boolean removeAll(Collection collection) {
        return super.removeAll(collection);
    }

    public synchronized boolean retainAll(Collection collection) {
        return super.retainAll(collection);
    }

    public Enumeration elements() {
        return new Enumeration(this){
            int count;
            private final Vector this$0;

            public boolean hasMoreElements() {
                return this.count < this.this$0.elementCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                Vector vector = this.this$0;
                synchronized (vector) {
                    if (this.count < this.this$0.elementCount) {
                        return this.this$0.elementData[this.count++];
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
            {
                this.this$0 = vector;
                this.count = 0;
            }
        };
    }

    public synchronized List subList(int n2, int n3) {
        return Collections.synchronizedList(super.subList(n2, n3), this);
    }

    public synchronized Object set(int n2, Object object) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        Object object2 = this.elementData[n2];
        this.elementData[n2] = object;
        return object2;
    }

    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        if (objectArray.length > this.elementCount) {
            objectArray[this.elementCount] = null;
        }
        return objectArray;
    }
}

