/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.TimerTask;

class TaskQueue {
    private TimerTask[] queue = new TimerTask[128];
    private int size = 0;

    TaskQueue() {
    }

    void clear() {
        int n2 = 1;
        while (n2 <= this.size) {
            this.queue[n2] = null;
            ++n2;
        }
        this.size = 0;
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    private void fixDown(int n2) {
        int n3;
        while ((n3 = n2 << 1) <= this.size) {
            if (n3 < this.size && this.queue[n3].nextExecutionTime > this.queue[n3 + 1].nextExecutionTime) {
                ++n3;
            }
            if (this.queue[n2].nextExecutionTime <= this.queue[n3].nextExecutionTime) break;
            TimerTask timerTask = this.queue[n3];
            this.queue[n3] = this.queue[n2];
            this.queue[n2] = timerTask;
            n2 = n3;
        }
    }

    private void fixUp(int n2) {
        while (n2 > 1) {
            int n3 = n2 >> 1;
            if (this.queue[n3].nextExecutionTime <= this.queue[n2].nextExecutionTime) break;
            TimerTask timerTask = this.queue[n3];
            this.queue[n3] = this.queue[n2];
            this.queue[n2] = timerTask;
            n2 = n3;
        }
    }

    void rescheduleMin(long l2) {
        this.queue[1].nextExecutionTime = l2;
        this.fixDown(1);
    }

    TimerTask getMin() {
        return this.queue[1];
    }

    void add(TimerTask timerTask) {
        if (++this.size == this.queue.length) {
            TimerTask[] timerTaskArray = new TimerTask[2 * this.queue.length];
            System.arraycopy(this.queue, 0, timerTaskArray, 0, this.size);
            this.queue = timerTaskArray;
        }
        this.queue[this.size] = timerTask;
        this.fixUp(this.size);
    }
}

