/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.EntryPair;
import java.text.RBCollationTables;
import java.text.RuleBasedCollator;
import java.util.Vector;
import sun.text.Normalizer;
import sun.text.NormalizerUtilities;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private Normalizer text = null;
    private int[] buffer = null;
    private int expIndex = 0;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder = 0;
    private RBCollationTables ordering;
    private RuleBasedCollator owner;

    public int getOffset() {
        return this.text != null ? this.text.getIndex() : 0;
    }

    public int next() {
        Normalizer.Mode mode;
        if (this.text == null) {
            return -1;
        }
        Normalizer.Mode mode2 = this.text.getMode();
        if (mode2 != (mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(mode);
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            int n2 = this.swapOrder << 16;
            this.swapOrder = 0;
            return n2;
        }
        char c2 = this.text.next();
        if (c2 == '\uffff') {
            return -1;
        }
        int n3 = this.ordering.getUnicodeOrder(c2);
        if (n3 == -1) {
            this.swapOrder = c2;
            return 0x7FFF0000;
        }
        if (n3 >= 0x7F000000) {
            n3 = this.nextContractChar(c2);
        }
        if (n3 >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n3);
            this.expIndex = 0;
            n3 = this.buffer[this.expIndex++];
        }
        if (this.ordering.isSEAsianSwapping()) {
            char c3;
            if (CollationElementIterator.isThaiPreVowel(c2)) {
                c3 = this.text.next();
                if (CollationElementIterator.isThaiBaseConsonant(c3)) {
                    this.buffer = this.makeReorderedBuffer(c3, n3, this.buffer, true);
                    n3 = this.buffer[0];
                    this.expIndex = 1;
                } else {
                    this.text.previous();
                }
            }
            if (CollationElementIterator.isLaoPreVowel(c2)) {
                c3 = this.text.next();
                if (CollationElementIterator.isLaoBaseConsonant(c3)) {
                    this.buffer = this.makeReorderedBuffer(c3, n3, this.buffer, true);
                    n3 = this.buffer[0];
                    this.expIndex = 1;
                } else {
                    this.text.previous();
                }
            }
        }
        return this.strengthOrder(n3);
    }

    public int previous() {
        Normalizer.Mode mode;
        if (this.text == null) {
            return -1;
        }
        Normalizer.Mode mode2 = this.text.getMode();
        if (mode2 != (mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(mode);
        }
        if (this.buffer != null) {
            if (this.expIndex > 0) {
                return this.strengthOrder(this.buffer[--this.expIndex]);
            }
            this.buffer = null;
            this.expIndex = 0;
        } else if (this.swapOrder != 0) {
            int n2 = this.swapOrder << 16;
            this.swapOrder = 0;
            return n2;
        }
        char c2 = this.text.previous();
        if (c2 == '\uffff') {
            return -1;
        }
        int n3 = this.ordering.getUnicodeOrder(c2);
        if (n3 == -1) {
            this.swapOrder = 0x7FFF0000;
            return c2;
        }
        if (n3 >= 0x7F000000) {
            n3 = this.prevContractChar(c2);
        }
        if (n3 >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n3);
            this.expIndex = this.buffer.length;
            n3 = this.buffer[--this.expIndex];
        }
        if (this.ordering.isSEAsianSwapping()) {
            char c3;
            if (CollationElementIterator.isThaiBaseConsonant(c2)) {
                c3 = this.text.previous();
                if (CollationElementIterator.isThaiPreVowel(c3)) {
                    this.buffer = this.makeReorderedBuffer(c3, n3, this.buffer, false);
                    this.expIndex = this.buffer.length - 1;
                    n3 = this.buffer[this.expIndex];
                } else {
                    this.text.next();
                }
            }
            if (CollationElementIterator.isLaoBaseConsonant(c2)) {
                c3 = this.text.previous();
                if (CollationElementIterator.isLaoPreVowel(c3)) {
                    this.buffer = this.makeReorderedBuffer(c3, n3, this.buffer, false);
                    this.expIndex = this.buffer.length - 1;
                    n3 = this.buffer[this.expIndex];
                } else {
                    this.text.next();
                }
            }
        }
        return this.strengthOrder(n3);
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
            Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
            this.text.setMode(mode);
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    private int nextContractChar(char c2) {
        Vector vector = this.ordering.getContractValues(c2);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n2 = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        int n3 = entryPair.entryName.length();
        Normalizer normalizer = (Normalizer)this.text.clone();
        normalizer.previous();
        this.key.setLength(0);
        char c3 = normalizer.next();
        while (n3 > 0 && c3 != '\uffff') {
            this.key.append(c3);
            --n3;
            c3 = normalizer.next();
        }
        String string = this.key.toString();
        n3 = 1;
        int n4 = vector.size() - 1;
        while (n4 > 0) {
            entryPair = (EntryPair)vector.elementAt(n4);
            if (entryPair.fwd && string.startsWith(entryPair.entryName) && entryPair.entryName.length() > n3) {
                n3 = entryPair.entryName.length();
                n2 = entryPair.value;
            }
            --n4;
        }
        while (n3 > 1) {
            this.text.next();
            --n3;
        }
        return n2;
    }

    private int prevContractChar(char c2) {
        Vector vector = this.ordering.getContractValues(c2);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n2 = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        int n3 = entryPair.entryName.length();
        Normalizer normalizer = (Normalizer)this.text.clone();
        normalizer.next();
        this.key.setLength(0);
        char c3 = normalizer.previous();
        while (n3 > 0 && c3 != '\uffff') {
            this.key.append(c3);
            --n3;
            c3 = normalizer.previous();
        }
        String string = this.key.toString();
        n3 = 1;
        int n4 = vector.size() - 1;
        while (n4 > 0) {
            entryPair = (EntryPair)vector.elementAt(n4);
            if (!entryPair.fwd && string.startsWith(entryPair.entryName) && entryPair.entryName.length() > n3) {
                n3 = entryPair.entryName.length();
                n2 = entryPair.value;
            }
            --n4;
        }
        while (n3 > 1) {
            this.text.previous();
            --n3;
        }
        return n2;
    }

    private static final boolean isLaoBaseConsonant(char c2) {
        return c2 >= '\u0e81' && c2 <= '\u0eae';
    }

    private static final boolean isLaoPreVowel(char c2) {
        return c2 >= '\u0ec0' && c2 <= '\u0ec4';
    }

    private static final boolean isThaiBaseConsonant(char c2) {
        return c2 >= '\u0e01' && c2 <= '\u0e2e';
    }

    private static final boolean isThaiPreVowel(char c2) {
        return c2 >= '\u0e40' && c2 <= '\u0e44';
    }

    private int[] makeReorderedBuffer(char c2, int n2, int[] nArray, boolean bl2) {
        int[] nArray2;
        int n3;
        int n4 = this.ordering.getUnicodeOrder(c2);
        if (n4 >= 0x7F000000) {
            n4 = bl2 ? this.nextContractChar(c2) : this.prevContractChar(c2);
        }
        int[] nArray3 = null;
        if (n4 >= 0x7E000000) {
            nArray3 = this.ordering.getExpandValueList(n4);
        }
        if (!bl2) {
            n3 = n4;
            n4 = n2;
            n2 = n3;
            int[] nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
        }
        if (nArray3 == null && nArray == null) {
            nArray2 = new int[]{n4, n2};
        } else {
            n3 = nArray3 == null ? 1 : nArray3.length;
            int n5 = nArray == null ? 1 : nArray.length;
            nArray2 = new int[n3 + n5];
            if (nArray3 == null) {
                nArray2[0] = n4;
            } else {
                System.arraycopy(nArray3, 0, nArray2, 0, n3);
            }
            if (nArray == null) {
                nArray2[n3] = n2;
            } else {
                System.arraycopy(nArray, 0, nArray2, n3, n5);
            }
        }
        return nArray2;
    }

    public int getMaxExpansion(int n2) {
        return this.ordering.getMaxExpansion(n2);
    }

    public static final int primaryOrder(int n2) {
        return (n2 &= 0xFFFF0000) >>> 16;
    }

    final int strengthOrder(int n2) {
        int n3 = this.owner.getStrength();
        if (n3 == 0) {
            n2 &= 0xFFFF0000;
        } else if (n3 == 1) {
            n2 &= 0xFFFFFF00;
        }
        return n2;
    }

    public static final short secondaryOrder(int n2) {
        return (short)((n2 &= 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int n2) {
        return (short)(n2 &= 0xFF);
    }

    public void setOffset(int n2) {
        if (this.text != null) {
            if (n2 < this.text.getBeginIndex() || n2 >= this.text.getEndIndex()) {
                this.text.setIndexOnly(n2);
            } else {
                char c2 = this.text.setIndex(n2);
                if (this.ordering.usedInContractSeq(c2)) {
                    while (this.ordering.usedInContractSeq(c2)) {
                        c2 = this.text.previous();
                    }
                    int n3 = this.text.getIndex();
                    while (this.text.getIndex() <= n2) {
                        n3 = this.text.getIndex();
                        this.next();
                    }
                    this.text.setIndexOnly(n3);
                }
            }
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    static final boolean isIgnorable(int n2) {
        return CollationElementIterator.primaryOrder(n2) == 0;
    }

    public void setText(String string) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new Normalizer(string, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(string);
        }
    }

    public void setText(CharacterIterator characterIterator) {
        this.buffer = null;
        this.swapOrder = 0;
        this.expIndex = 0;
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new Normalizer(characterIterator, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(characterIterator);
        }
    }

    CollationElementIterator(String string, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        if (string.length() != 0) {
            Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(ruleBasedCollator.getDecomposition());
            this.text = new Normalizer(string, mode);
        }
    }

    CollationElementIterator(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(ruleBasedCollator.getDecomposition());
        this.text = new Normalizer(characterIterator, mode);
    }
}

