/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import sun.security.action.LoadLibraryAction;

public final class Bidi {
    byte dir;
    byte baselevel;
    int length;
    int[] runs;
    int[] cws;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    private static final int DIR_MIXED = 2;
    private static final char NUMLEVELS = '>';
    private static final int RMASK = 57378;

    public int getBaseLevel() {
        return this.baselevel;
    }

    public int getLength() {
        return this.length;
    }

    public int getRunCount() {
        return this.runs == null ? 1 : this.runs.length / 2;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        AccessController.doPrivileged(new LoadLibraryAction("fontmanager"));
    }

    public boolean baseIsLeftToRight() {
        return (this.baselevel & 1) == 0;
    }

    public boolean isLeftToRight() {
        return this.dir == 0;
    }

    public boolean isMixed() {
        return this.dir == 2;
    }

    public boolean isRightToLeft() {
        return this.dir == 1;
    }

    private static native int nativeGetDirectionCode(char var0);

    public int getLevelAt(int n2) {
        if (this.runs == null || n2 < 0 || n2 >= this.length) {
            return this.baselevel;
        }
        int n3 = 0;
        while (n2 >= this.runs[n3]) {
            n3 += 2;
        }
        return this.runs[n3 + 1];
    }

    public int getRunLevel(int n2) {
        return this.runs == null ? this.baselevel : this.runs[n2 * 2 + 1];
    }

    public int getRunLimit(int n2) {
        return this.runs == null ? this.length : this.runs[n2 * 2];
    }

    public int getRunStart(int n2) {
        return this.runs == null || n2 == 0 ? 0 : this.runs[n2 * 2 - 2];
    }

    private Bidi(int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        this.reset(n2, n3, n4, nArray, nArray2);
    }

    private void reset(int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        this.dir = (byte)n2;
        this.baselevel = (byte)n3;
        this.length = n4;
        this.runs = nArray;
        this.cws = nArray2;
    }

    public static boolean requiresBidi(char[] cArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n3) {
            int n5;
            char c2 = cArray[n4];
            if (c2 >= '\u0591' && c2 <= '\u202e' && (0xE022 & 1 << (n5 = Bidi.nativeGetDirectionCode(c2))) != 0) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public Bidi(char[] cArray, int n2, byte[] byArray, int n3, int n4, int n5) {
        if (cArray == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("bad length: " + n4);
        }
        if (n2 < 0 || n2 + n4 > cArray.length) {
            throw new IllegalArgumentException("bad range: " + n2 + " to " + (n2 + n4) + " for text of length: " + cArray.length);
        }
        if (byArray != null && (n3 < 0 || n3 + n4 > byArray.length)) {
            throw new IllegalArgumentException("bad range: " + n3 + " to " + (n3 + n4) + " for embeddings of length: " + cArray.length);
        }
        if (byArray != null) {
            int n6 = n3;
            int n7 = n3 + n4;
            while (n6 < n7) {
                if (byArray[n6] < 0) {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, n3, byArray2, 0, n4);
                    n6 -= n3;
                    while (n6 < n4) {
                        if (byArray2[n6] < 0) {
                            byArray2[n6] = (byte)(-byArray2[n6] | 0x80);
                        }
                        ++n6;
                    }
                    byArray = byArray2;
                    n3 = 0;
                    break;
                }
                ++n6;
            }
        }
        Bidi.nativeBidiChars(this, cArray, n2, byArray, n3, n4, n5);
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] var0, int var1_1, Object[] var2_2, int var3_3, int var4_4) {
        if (var4_4 < 0) {
            throw new IllegalArgumentException("count " + var4_4 + " must be >= 0");
        }
        if (var1_1 < 0 || var1_1 + var4_4 > var0.length) {
            throw new IllegalArgumentException("levelStart " + var1_1 + " and count " + var4_4 + " out of range [0, " + var0.length + "]");
        }
        if (var3_3 < 0 || var3_3 + var4_4 > var2_2.length) {
            throw new IllegalArgumentException("objectStart " + var3_3 + " and count " + var4_4 + " out of range [0, " + var2_2.length + "]");
        }
        var5_5 = 63;
        var6_6 = 0;
        var7_7 = var1_1 + var4_4;
        var8_8 = var1_1;
        while (var8_8 < var7_7) {
            var9_9 = var0[var8_8];
            if (var9_9 > var6_6) {
                var6_6 = var9_9;
            }
            if ((var9_9 & 1) != 0 && var9_9 < var5_5) {
                var5_5 = var9_9;
            }
            ++var8_8;
        }
        var9_9 = var3_3 - var1_1;
        while (var6_6 >= var5_5) {
            var10_10 = var1_1;
            block2: while (true) {
                if (var10_10 < var7_7 && var0[var10_10] < var6_6) {
                    ++var10_10;
                    continue;
                }
                if ((var11_11 = var10_10++) != var7_7) ** GOTO lbl29
                break;
lbl-1000:
                // 1 sources

                {
                    ++var10_10;
lbl29:
                    // 2 sources

                    ** while (var10_10 < var7_7 && var0[var10_10] >= var6_6)
                }
lbl30:
                // 1 sources

                var12_12 = var10_10 - 1;
                var11_11 += var9_9;
                var12_12 += var9_9;
                while (true) {
                    if (var11_11 < var12_12) ** break;
                    continue block2;
                    var13_13 = var2_2[var11_11];
                    var2_2[var11_11] = var2_2[var12_12];
                    var2_2[var12_12] = var13_13;
                    ++var11_11;
                    --var12_12;
                }
                break;
            }
            var6_6 = (byte)(var6_6 - 1);
        }
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("[dir: " + this.dir);
        stringBuffer.append(" baselevel: " + this.baselevel);
        stringBuffer.append(" length: " + this.length);
        if (this.runs == null) {
            stringBuffer.append(" runs: null");
        } else {
            stringBuffer.append(" runs: [");
            n2 = 0;
            while (n2 < this.runs.length) {
                if (n2 != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.runs[n2]);
                stringBuffer.append('/');
                stringBuffer.append(this.runs[n2 + 1]);
                n2 += 2;
            }
            stringBuffer.append(']');
        }
        if (this.cws == null) {
            stringBuffer.append(" cws: null");
        } else {
            n2 = 0;
            while (n2 < this.cws.length) {
                if (n2 != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(Integer.toHexString(this.cws[n2]));
                ++n2;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Bidi(String string, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        Bidi.nativeBidiChars(this, string.toCharArray(), 0, null, 0, string.length(), n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bidi(AttributedCharacterIterator attributedCharacterIterator) {
        int n2;
        Serializable serializable;
        if (attributedCharacterIterator == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        int n3 = -2;
        byte[] byArray = null;
        int n4 = attributedCharacterIterator.getBeginIndex();
        int n5 = attributedCharacterIterator.getEndIndex();
        int n6 = n5 - n4;
        int n7 = 0;
        char[] cArray = new char[n6];
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            cArray[n7++] = c2;
            c2 = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        try {
            serializable = (Boolean)attributedCharacterIterator.getAttribute(TextAttribute.RUN_DIRECTION);
            if (serializable != null) {
                n3 = TextAttribute.RUN_DIRECTION_LTR.equals(serializable) ? 0 : 1;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            serializable = (NumericShaper)attributedCharacterIterator.getAttribute(TextAttribute.NUMERIC_SHAPING);
            if (serializable != null) {
                ((NumericShaper)serializable).shape(cArray, 0, cArray.length);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int n8 = n4;
        do {
            attributedCharacterIterator.setIndex(n8);
            Object object = attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING);
            n2 = attributedCharacterIterator.getRunLimit(TextAttribute.BIDI_EMBEDDING);
            if (object == null) continue;
            try {
                int n9 = (Integer)object;
                if (n9 < -61 || n9 >= 61) continue;
                byte by = (byte)(n9 < 0 ? -n9 | 0x80 : n9);
                if (byArray == null) {
                    byArray = new byte[n6];
                }
                int n10 = n8 - n4;
                while (n10 < n2 - n4) {
                    byArray[n10] = by;
                    ++n10;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        } while ((n8 = n2) < n5);
        Bidi.nativeBidiChars(this, cArray, 0, byArray, 0, cArray.length, n3);
    }

    public Bidi createLineBidi(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 == 0 && n3 == this.length) {
            return this;
        }
        int n8 = n3 - n2;
        if (n2 < 0 || n3 < n2 || n3 > this.length) {
            throw new IllegalArgumentException("range " + n2 + " to " + n3 + " is invalid for paragraph of length " + this.length);
        }
        if (this.runs == null) {
            return new Bidi(this.dir, this.baselevel, n8, null, null);
        }
        int n9 = -1;
        int[] nArray = null;
        if (this.cws != null) {
            int n10 = 0;
            n7 = this.cws.length;
            while (n10 < n7) {
                if (this.cws[n10] >= n2) {
                    n7 = n10;
                    while (n7 < this.cws.length && this.cws[n7] < n3) {
                        ++n7;
                    }
                    n6 = n3 - 1;
                    while (n7 > n10 && this.cws[n7 - 1] == n6) {
                        n9 = n6--;
                        --n7;
                    }
                    if (n9 == n2) {
                        return new Bidi(this.dir, this.baselevel, n8, null, null);
                    }
                    n5 = n7 - n10;
                    if (n5 <= 0) break;
                    nArray = new int[n5];
                    n4 = 0;
                    while (n4 < n5) {
                        nArray[n4] = this.cws[n10 + n4] - n2;
                        ++n4;
                    }
                    break;
                }
                ++n10;
            }
        }
        int[] nArray2 = null;
        n7 = this.baselevel;
        n6 = n9 == -1 ? n3 : n9;
        n5 = 0;
        n4 = this.runs.length;
        byte by = this.dir;
        while (n5 < this.runs.length) {
            if (this.runs[n5] > n2) {
                n4 = n5;
                while (n4 < this.runs.length && this.runs[n4] < n6) {
                    n4 += 2;
                }
                if (n4 > n5 || this.runs[n5 + 1] != this.baselevel) {
                    if (n9 != -1 && (n4 += 2) > n5 && this.runs[n4 - 1] != this.baselevel) {
                        nArray2 = new int[n4 - n5 + 2];
                        nArray2[n4 - n5] = n8;
                        nArray2[n4 - n5 + 1] = this.baselevel;
                    } else {
                        n6 = n3;
                        nArray2 = new int[n4 - n5];
                    }
                    int n11 = 0;
                    int n12 = n5;
                    while (n12 < n4) {
                        nArray2[n11++] = this.runs[n12] - n2;
                        nArray2[n11++] = this.runs[n12 + 1];
                        n12 += 2;
                    }
                    nArray2[n11 - 2] = n6 - n2;
                    break;
                }
                by = (this.runs[n5 + 1] & 1) == 0 ? (byte)0 : 1;
                break;
            }
            n5 += 2;
        }
        return new Bidi(by, this.baselevel, n8, nArray2, nArray);
    }

    private static synchronized native void nativeBidiChars(Bidi var0, char[] var1, int var2, byte[] var3, int var4, int var5, int var6);
}

