/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.Vector;
import sun.security.util.Debug;

public final class AccessControlContext {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner = null;
    private static boolean debugInit = false;
    private static Debug debug = null;

    public int hashCode() {
        int n2 = 0;
        if (this.context == null) {
            return n2;
        }
        int n3 = 0;
        while (n3 < this.context.length) {
            if (this.context[n3] != null) {
                n2 ^= this.context[n3].hashCode();
            }
            ++n3;
        }
        return n2;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (this.context == null) {
            return accessControlContext.context == null;
        }
        if (accessControlContext.context == null) {
            return false;
        }
        if (!this.containsAllPDs(accessControlContext) || !accessControlContext.containsAllPDs(this)) {
            return false;
        }
        if (this.combiner == null) {
            return accessControlContext.combiner == null;
        }
        if (accessControlContext.combiner == null) {
            return false;
        }
        return this.combiner.equals(accessControlContext.combiner);
    }

    AccessControlContext optimize() {
        ProtectionDomain[] protectionDomainArray;
        boolean bl2;
        AccessControlContext accessControlContext = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        boolean bl3 = this.context == null;
        boolean bl4 = bl2 = accessControlContext == null || accessControlContext.context == null;
        if (bl2 && bl3) {
            return accessControlContext != null ? accessControlContext : this;
        }
        if (accessControlContext != null && accessControlContext.combiner != null) {
            return this.goCombiner(this.context, accessControlContext);
        }
        if (bl3) {
            return accessControlContext;
        }
        int n2 = this.context.length;
        if (bl2 && n2 <= 2) {
            return this;
        }
        if (n2 == 1 && this.context[0] == accessControlContext.context[0]) {
            return accessControlContext;
        }
        int n3 = bl2 ? 0 : accessControlContext.context.length;
        ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n2 + n3];
        if (!bl2) {
            System.arraycopy(accessControlContext.context, 0, protectionDomainArray2, 0, n3);
        }
        int n4 = 0;
        while (n4 < this.context.length) {
            block13: {
                protectionDomainArray = this.context[n4];
                if (protectionDomainArray != null) {
                    int n5 = 0;
                    while (n5 < n3) {
                        if (protectionDomainArray != protectionDomainArray2[n5]) {
                            ++n5;
                            continue;
                        }
                        break block13;
                    }
                    protectionDomainArray2[n3++] = protectionDomainArray;
                }
            }
            ++n4;
        }
        if (n3 != protectionDomainArray2.length) {
            if (!bl2 && n3 == accessControlContext.context.length) {
                return accessControlContext;
            }
            if (bl2 && n3 == n2) {
                return this;
            }
            protectionDomainArray = new ProtectionDomain[n3];
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray, 0, n3);
            protectionDomainArray2 = protectionDomainArray;
        }
        return new AccessControlContext(protectionDomainArray2, false);
    }

    private boolean containsAllPDs(AccessControlContext accessControlContext) {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.context.length) {
            int n3;
            bl2 = false;
            if (this.context[n2] == null) {
                n3 = 0;
                while (n3 < accessControlContext.context.length && !bl2) {
                    bl2 = accessControlContext.context[n3] == null;
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < accessControlContext.context.length && !bl2) {
                    if (accessControlContext.context[n3] != null) {
                        bl2 = this.context[n2].getClass() == accessControlContext.context[n3].getClass() && this.context[n2].equals(accessControlContext.context[n3]);
                    }
                    ++n3;
                }
            }
            if (!bl2) {
                return false;
            }
            ++n2;
        }
        return bl2;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getDomainCombiner"));
        }
        return this.combiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        int n2;
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        if (AccessControlContext.getDebug() != null) {
            if (Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    n2 = 0;
                    while (n2 < this.context.length) {
                        debug.println("domain " + n2 + " " + this.context[n2]);
                        ++n2;
                    }
                }
            }
        }
        if (this.context == null) {
            return;
        }
        n2 = 0;
        while (n2 < this.context.length) {
            if (this.context[n2] != null && !this.context[n2].implies(permission)) {
                if (debug != null) {
                    debug.println("access denied " + permission);
                    if (Debug.isOn("failure")) {
                        Thread.currentThread();
                        Thread.dumpStack();
                        ProtectionDomain protectionDomain = this.context[n2];
                        Debug debug = AccessControlContext.debug;
                        AccessController.doPrivileged(new PrivilegedAction(this, debug, protectionDomain){
                            private final Debug val$db;
                            private final ProtectionDomain val$pd;
                            private final AccessControlContext this$0;

                            public Object run() {
                                this.val$db.println("domain that failed " + this.val$pd);
                                return null;
                            }
                            {
                                this.this$0 = accessControlContext;
                                this.val$db = debug;
                                this.val$pd = protectionDomain;
                            }
                        });
                    }
                }
                throw new AccessControlException("access denied " + permission, permission);
            }
            ++n2;
        }
        if (debug != null) {
            debug.println("access allowed " + permission);
        }
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray.length == 0) {
            this.context = null;
        } else if (protectionDomainArray.length == 1) {
            this.context = (ProtectionDomain[])protectionDomainArray.clone();
        } else {
            Vector vector = new Vector(protectionDomainArray.length);
            int n2 = 0;
            while (n2 < protectionDomainArray.length) {
                if (protectionDomainArray[n2] != null && !vector.contains(protectionDomainArray[n2])) {
                    vector.addElement(protectionDomainArray[n2]);
                }
                ++n2;
            }
            this.context = new ProtectionDomain[vector.size()];
            vector.copyInto(this.context);
        }
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl2) {
        this.context = protectionDomainArray;
        this.isPrivileged = bl2;
    }

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("createAccessControlContext"));
        }
        if (accessControlContext == null) {
            throw new NullPointerException("null AccessControlContext was provided");
        }
        this.context = accessControlContext.context;
        this.combiner = domainCombiner;
    }

    private AccessControlContext(ProtectionDomain[] protectionDomainArray, DomainCombiner domainCombiner) {
        this.context = (ProtectionDomain[])protectionDomainArray.clone();
        this.combiner = domainCombiner;
    }

    private AccessControlContext goCombiner(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        if (AccessControlContext.getDebug() != null) {
            debug.println("AccessControlContext invoking the Combiner");
        }
        ProtectionDomain[] protectionDomainArray2 = accessControlContext.combiner.combine(protectionDomainArray == null ? null : (ProtectionDomain[])protectionDomainArray.clone(), accessControlContext.context == null ? null : (ProtectionDomain[])accessControlContext.context.clone());
        return new AccessControlContext(protectionDomainArray2, accessControlContext.combiner);
    }
}

