/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

public abstract class URLStreamHandler {
    protected int getDefaultPort() {
        return -1;
    }

    protected int hashCode(URL uRL) {
        String string;
        InetAddress inetAddress;
        int n2 = 0;
        String string2 = uRL.getProtocol();
        if (string2 != null) {
            n2 += string2.hashCode();
        }
        if ((inetAddress = this.getHostAddress(uRL)) != null) {
            n2 += inetAddress.hashCode();
        } else {
            string = uRL.getHost();
            if (string != null) {
                n2 += string.toLowerCase().hashCode();
            }
        }
        string = uRL.getFile();
        if (string != null) {
            n2 += string.hashCode();
        }
        n2 = uRL.getPort() == -1 ? (n2 += this.getDefaultPort()) : (n2 += uRL.getPort());
        String string3 = uRL.getRef();
        if (string3 != null) {
            n2 += string3.hashCode();
        }
        return n2;
    }

    protected String toExternalForm(URL uRL) {
        int n2 = uRL.getProtocol().length() + 1;
        if (uRL.getAuthority() != null && uRL.getAuthority().length() > 0) {
            n2 += 2 + uRL.getAuthority().length();
        }
        if (uRL.getFile() != null) {
            n2 += uRL.getFile().length();
        }
        if (uRL.getRef() != null) {
            n2 += 1 + uRL.getRef().length();
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(":");
        if (uRL.getAuthority() != null && uRL.getAuthority().length() > 0) {
            stringBuffer.append("//");
            stringBuffer.append(uRL.getAuthority());
        }
        if (uRL.getFile() != null) {
            stringBuffer.append(uRL.getFile());
        }
        if (uRL.getRef() != null) {
            stringBuffer.append("#");
            stringBuffer.append(uRL.getRef());
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseURL(URL uRL, String string, int n2, int n3) {
        String string2;
        int n4;
        int n5;
        String string3 = uRL.getProtocol();
        String string4 = uRL.getAuthority();
        String string5 = uRL.getUserInfo();
        String string6 = uRL.getHost();
        int n6 = uRL.getPort();
        String string7 = uRL.getPath();
        String string8 = uRL.getQuery();
        String string9 = uRL.getRef();
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 < n3) {
            n5 = string.indexOf(63);
            boolean bl4 = bl3 = n5 == n2;
            if (n5 != -1 && n5 < n3) {
                string8 = string.substring(n5 + 1, n3);
                if (n3 > n5) {
                    n3 = n5;
                }
                string = string.substring(0, n5);
            }
        }
        n5 = 0;
        if (n2 <= n3 - 2 && string.charAt(n2) == '/' && string.charAt(n2 + 1) == '/') {
            n5 = string.indexOf(47, n2 += 2);
            if (n5 < 0 && (n5 = string.indexOf(63, n2)) < 0) {
                n5 = n3;
            }
            string6 = string4 = string.substring(n2, n5);
            n4 = string4.indexOf(64);
            if (n4 != -1) {
                string5 = string4.substring(0, n4);
                string6 = string4.substring(n4 + 1);
            } else {
                string5 = null;
            }
            if (string6 != null) {
                if (string6.length() > 0 && string6.charAt(0) == '[') {
                    n4 = string6.indexOf(93);
                    if (n4 <= 2) throw new IllegalArgumentException("Invalid authority field: " + string4);
                    string2 = string6;
                    if (Inet6Address.textToNumericFormat((string6 = string2.substring(0, n4 + 1)).substring(1, n4)) == null) {
                        throw new IllegalArgumentException("Invalid host: " + string6);
                    }
                    n6 = -1;
                    if (string2.length() > n4 + 1) {
                        if (string2.charAt(n4 + 1) != ':') throw new IllegalArgumentException("Invalid authority field: " + string4);
                        if (string2.length() > ++n4 + 1) {
                            n6 = Integer.parseInt(string2.substring(n4 + 1));
                        }
                    }
                } else {
                    n4 = string6.indexOf(58);
                    n6 = -1;
                    if (n4 >= 0) {
                        if (string6.length() > n4 + 1) {
                            n6 = Integer.parseInt(string6.substring(n4 + 1));
                        }
                        string6 = string6.substring(0, n4);
                    }
                }
            } else {
                string6 = "";
            }
            if (n6 < -1) {
                throw new IllegalArgumentException("Invalid port number :" + n6);
            }
            n2 = n5;
            if (string4 != null && string4.length() > 0) {
                string7 = "";
            }
        }
        if (string6 == null) {
            string6 = "";
        }
        if (n2 < n3) {
            if (string.charAt(n2) == '/') {
                string7 = string.substring(n2, n3);
            } else if (string7 != null && string7.length() > 0) {
                bl2 = true;
                n4 = string7.lastIndexOf(47);
                string2 = "";
                if (n4 == -1 && string4 != null) {
                    string2 = "/";
                }
                string7 = string7.substring(0, n4 + 1) + string2 + string.substring(n2, n3);
            } else {
                String string10 = string4 != null ? "/" : "";
                string7 = string10 + string.substring(n2, n3);
            }
        } else if (bl3 && string7 != null) {
            n4 = string7.lastIndexOf(47);
            if (n4 < 0) {
                n4 = 0;
            }
            string7 = string7.substring(0, n4) + "/";
        }
        if (string7 == null) {
            string7 = "";
        }
        if (bl2) {
            while ((n5 = string7.indexOf("/./")) >= 0) {
                string7 = string7.substring(0, n5) + string7.substring(n5 + 2);
            }
            n5 = 0;
            while ((n5 = string7.indexOf("/../", n5)) > 0) {
                n3 = string7.lastIndexOf(47, n5 - 1);
                if (n3 >= 0) {
                    string7 = string7.substring(0, n3) + string7.substring(n5 + 3);
                    n5 = 0;
                    continue;
                }
                n5 += 3;
            }
            while (string7.endsWith("/..")) {
                n5 = string7.indexOf("/..");
                n3 = string7.lastIndexOf(47, n5 - 1);
                if (n3 < 0) break;
                string7 = string7.substring(0, n3 + 1);
            }
            if (string7.startsWith("./") && string7.length() > 2) {
                string7 = string7.substring(2);
            }
            if (string7.endsWith("/.")) {
                string7 = string7.substring(0, string7.length() - 1);
            }
        }
        this.setURL(uRL, string3, string6, n6, string4, string5, string7, string8, string9);
    }

    protected synchronized InetAddress getHostAddress(URL uRL) {
        if (uRL.hostAddress != null) {
            return uRL.hostAddress;
        }
        String string = uRL.getHost();
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            uRL.hostAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        return uRL.hostAddress;
    }

    protected boolean equals(URL uRL, URL uRL2) {
        String string = uRL.getRef();
        String string2 = uRL2.getRef();
        return this.sameFile(uRL, uRL2) && (string == string2 || string != null && string.equals(string2));
    }

    protected boolean hostsEqual(URL uRL, URL uRL2) {
        InetAddress inetAddress = this.getHostAddress(uRL);
        InetAddress inetAddress2 = this.getHostAddress(uRL2);
        if (inetAddress != null && inetAddress2 != null) {
            return inetAddress.equals(inetAddress2);
        }
        if (uRL.getHost() != null && uRL2.getHost() != null) {
            return uRL.getHost().equalsIgnoreCase(uRL2.getHost());
        }
        return uRL.getHost() == null && uRL2.getHost() == null;
    }

    protected boolean sameFile(URL uRL, URL uRL2) {
        int n2;
        if (!(uRL.getProtocol() == uRL2.getProtocol() || uRL.getProtocol() != null && uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol()))) {
            return false;
        }
        if (!this.hostsEqual(uRL, uRL2)) {
            return false;
        }
        if (!(uRL.getFile() == uRL2.getFile() || uRL.getFile() != null && uRL.getFile().equals(uRL2.getFile()))) {
            return false;
        }
        int n3 = uRL.getPort() != -1 ? uRL.getPort() : uRL.handler.getDefaultPort();
        int n4 = n2 = uRL2.getPort() != -1 ? uRL2.getPort() : uRL2.handler.getDefaultPort();
        return n3 == n2;
    }

    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected void setURL(URL uRL, String string, String string2, int n2, String string3, String string4) {
        String string5 = null;
        String string6 = null;
        if (string2 != null && string2.length() != 0) {
            string5 = n2 == -1 ? string2 : string2 + ":" + n2;
            int n3 = string2.lastIndexOf(64);
            if (n3 != -1) {
                string6 = string2.substring(0, n3);
                string2 = string2.substring(n3 + 1);
            }
        }
        String string7 = null;
        String string8 = null;
        if (string3 != null) {
            int n4 = string3.lastIndexOf(63);
            if (n4 != -1) {
                string8 = string3.substring(n4 + 1);
                string7 = string3.substring(0, n4);
            } else {
                string7 = string3;
            }
        }
        this.setURL(uRL, string, string2, n2, string5, string6, string7, string8, string4);
    }

    protected void setURL(URL uRL, String string, String string2, int n2, String string3, String string4, String string5, String string6, String string7) {
        if (this != uRL.handler) {
            throw new SecurityException("handler for url different from this handler");
        }
        uRL.set(uRL.getProtocol(), string2, n2, string3, string4, string5, string6, string7);
    }
}

