/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;

public class MulticastSocket
extends DatagramSocket {
    private Object ttlLock = new Object();
    private Object infLock = new Object();
    private InetAddress infAddress = null;

    public byte getTTL() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getTTL();
    }

    public int getTimeToLive() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.getImpl().getTimeToLive();
    }

    public MulticastSocket() throws IOException {
        this(new InetSocketAddress(0));
    }

    public boolean getLoopbackMode() throws SocketException {
        return (Boolean)this.getImpl().getOption(18);
    }

    public void setTTL(byte by) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setTTL(by);
    }

    public MulticastSocket(int n2) throws IOException {
        this(new InetSocketAddress(n2));
    }

    public void setTimeToLive(int n2) throws IOException {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("ttl out of range");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        this.getImpl().setTimeToLive(n2);
    }

    public void setLoopbackMode(boolean bl2) throws SocketException {
        this.getImpl().setOption(18, new Boolean(bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(DatagramPacket datagramPacket, byte by) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.ttlLock;
        synchronized (object) {
            DatagramPacket datagramPacket2 = datagramPacket;
            synchronized (datagramPacket2) {
                Object object2;
                if (!this.connected) {
                    object2 = System.getSecurityManager();
                    if (object2 != null) {
                        if (datagramPacket.getAddress().isMulticastAddress()) {
                            ((SecurityManager)object2).checkMulticast(datagramPacket.getAddress(), by);
                        } else {
                            ((SecurityManager)object2).checkConnect(datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
                        }
                    }
                } else {
                    object2 = null;
                    object2 = datagramPacket.getAddress();
                    if (object2 == null) {
                        datagramPacket.setAddress(this.connectedAddress);
                        datagramPacket.setPort(this.connectedPort);
                    } else if (!((InetAddress)object2).equals(this.connectedAddress) || datagramPacket.getPort() != this.connectedPort) {
                        throw new SecurityException("connected address and packet address differ");
                    }
                }
                byte by2 = this.getTTL();
                try {
                    if (by != by2) {
                        this.getImpl().setTTL(by);
                    }
                    this.getImpl().send(datagramPacket);
                    Object var7_7 = null;
                    if (by == by2) return;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (by == by2) throw throwable;
                    this.getImpl().setTTL(by2);
                    throw throwable;
                }
                this.getImpl().setTTL(by2);
                {
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getInterface() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.infLock;
        synchronized (object) {
            InetAddress inetAddress = (InetAddress)this.getImpl().getOption(16);
            if (this.infAddress == null) {
                return inetAddress;
            }
            if (inetAddress.equals(this.infAddress)) {
                return inetAddress;
            }
            try {
                NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
                Enumeration enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress2 = (InetAddress)enumeration.nextElement();
                    if (!inetAddress2.equals(this.infAddress)) continue;
                    return this.infAddress;
                }
                this.infAddress = null;
                return inetAddress;
            }
            catch (Exception exception) {
                return inetAddress;
            }
        }
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        if (!inetAddress.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().join(inetAddress);
    }

    public void leaveGroup(InetAddress inetAddress) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        if (!inetAddress.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().leave(inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterface(InetAddress inetAddress) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        Object object = this.infLock;
        synchronized (object) {
            this.getImpl().setOption(16, inetAddress);
            this.infAddress = inetAddress;
        }
    }

    public NetworkInterface getNetworkInterface() throws SocketException {
        NetworkInterface networkInterface = (NetworkInterface)this.getImpl().getOption(31);
        if (networkInterface.getIndex() == 0) {
            InetAddress[] inetAddressArray = new InetAddress[]{InetAddress.anyLocalAddress()};
            return new NetworkInterface(inetAddressArray[0].getHostName(), 0, inetAddressArray);
        }
        return networkInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        Object object = this.infLock;
        synchronized (object) {
            this.getImpl().setOption(31, networkInterface);
            this.infAddress = null;
        }
    }

    public MulticastSocket(SocketAddress socketAddress) throws IOException {
        super((SocketAddress)null);
        this.setReuseAddress(true);
        if (socketAddress != null) {
            this.bind(socketAddress);
        }
    }

    public void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        if (this.oldImpl) {
            throw new UnsupportedOperationException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(((InetSocketAddress)socketAddress).getAddress());
        }
        if (!((InetSocketAddress)socketAddress).getAddress().isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().joinGroup(socketAddress, networkInterface);
    }

    public void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        if (this.oldImpl) {
            throw new UnsupportedOperationException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(((InetSocketAddress)socketAddress).getAddress());
        }
        if (!((InetSocketAddress)socketAddress).getAddress().isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        this.getImpl().leaveGroup(socketAddress, networkInterface);
    }
}

