/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import sun.misc.VM;

public class ThreadGroup {
    ThreadGroup parent;
    String name;
    int maxPriority;
    boolean destroyed;
    boolean daemon;
    boolean vmAllowSuspension;
    int nthreads;
    Thread[] threads;
    int ngroups;
    ThreadGroup[] groups;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeCount() {
        ThreadGroup[] threadGroupArray;
        int n2;
        int n3;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n3 = this.nthreads;
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        int n4 = 0;
        while (n4 < n2) {
            n3 += threadGroupArray[n4].activeCount();
            ++n4;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int activeGroupCount() {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = n2;
        int n4 = 0;
        while (n4 < n2) {
            n3 += threadGroupArray[n4].activeGroupCount();
            ++n4;
        }
        return n3;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    private ThreadGroup() {
        this.name = "system";
        this.maxPriority = 10;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (this.destroyed || this.nthreads > 0) {
                throw new IllegalThreadStateException();
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
            if (this.parent != null) {
                this.destroyed = true;
                this.ngroups = 0;
                this.groups = null;
                this.nthreads = 0;
                this.threads = null;
            }
        }
        int n3 = 0;
        while (n3 < n2) {
            threadGroupArray[n3].destroy();
            ++n3;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        ThreadGroup[] threadGroupArray;
        int n2;
        int n3;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            n3 = 0;
            while (n3 < this.nthreads) {
                this.threads[n3].interrupt();
                ++n3;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        n3 = 0;
        while (n3 < n2) {
            threadGroupArray[n3].interrupt();
            ++n3;
        }
    }

    public void list() {
        this.list(System.out, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        ThreadGroup[] threadGroupArray;
        int n2;
        int n3;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            n3 = 0;
            while (n3 < this.nthreads) {
                this.threads[n3].resume();
                ++n3;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        n3 = 0;
        while (n3 < n2) {
            threadGroupArray[n3].resume();
            ++n3;
        }
    }

    public final void stop() {
        if (this.stopOrSuspend(false)) {
            Thread.currentThread().stop();
        }
    }

    public final void suspend() {
        if (this.stopOrSuspend(true)) {
            Thread.currentThread().suspend();
        }
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxPriority(int n2) {
        ThreadGroup[] threadGroupArray;
        int n3;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (n2 < 1) {
                this.maxPriority = 1;
            } else if (n2 < this.maxPriority) {
                this.maxPriority = n2;
            }
            n3 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n3];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n3);
            } else {
                threadGroupArray = null;
            }
        }
        int n4 = 0;
        while (n4 < n3) {
            threadGroupArray[n4].setMaxPriority(n2);
            ++n4;
        }
    }

    public final void setDaemon(boolean bl2) {
        this.checkAccess();
        this.daemon = bl2;
    }

    public boolean allowThreadSuspension(boolean bl2) {
        this.vmAllowSuspension = bl2;
        if (!bl2) {
            VM.unsuspendSomeThreads();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopOrSuspend(boolean bl2) {
        int n2;
        int n3;
        boolean bl3 = false;
        Thread thread = Thread.currentThread();
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            n3 = 0;
            while (n3 < this.nthreads) {
                if (this.threads[n3] == thread) {
                    bl3 = true;
                } else if (bl2) {
                    this.threads[n3].suspend();
                } else {
                    this.threads[n3].stop();
                }
                ++n3;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            }
        }
        n3 = 0;
        while (n3 < n2) {
            bl3 = threadGroupArray[n3].stopOrSuspend(bl2) || bl3;
            ++n3;
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void list(PrintStream printStream, int n2) {
        ThreadGroup[] threadGroupArray;
        int n3;
        int n4;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            n4 = 0;
            while (n4 < n2) {
                printStream.print(" ");
                ++n4;
            }
            printStream.println(this);
            n2 += 4;
            int n5 = 0;
            while (n5 < this.nthreads) {
                int n6 = 0;
                while (n6 < n2) {
                    printStream.print(" ");
                    ++n6;
                }
                printStream.println(this.threads[n5]);
                ++n5;
            }
            n3 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n3];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n3);
            } else {
                threadGroupArray = null;
            }
        }
        n4 = 0;
        while (n4 < n3) {
            threadGroupArray[n4].list(printStream, n2);
            ++n4;
        }
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",maxpri=" + this.maxPriority + "]";
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.threads == null) {
                this.threads = new Thread[4];
            } else if (this.nthreads == this.threads.length) {
                Thread[] threadArray = new Thread[this.nthreads * 2];
                System.arraycopy(this.threads, 0, threadArray, 0, this.nthreads);
                this.threads = threadArray;
            }
            this.threads[this.nthreads] = thread;
            ++this.nthreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return;
            }
            int n2 = 0;
            while (n2 < this.nthreads) {
                if (this.threads[n2] == thread) {
                    System.arraycopy(this.threads, n2 + 1, this.threads, n2, --this.nthreads - n2);
                    this.threads[this.nthreads] = null;
                    break;
                }
                ++n2;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    public int enumerate(Thread[] threadArray) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(Thread[] threadArray, int n2, boolean bl2) {
        int n3;
        int n4 = 0;
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n3 = this.nthreads;
            if (n3 > threadArray.length - n2) {
                n3 = threadArray.length - n2;
            }
            int n5 = 0;
            while (n5 < n3) {
                if (this.threads[n5].isAlive()) {
                    threadArray[n2++] = this.threads[n5];
                }
                ++n5;
            }
            if (bl2) {
                n4 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray = new ThreadGroup[n4];
                    System.arraycopy(this.groups, 0, threadGroupArray, 0, n4);
                } else {
                    threadGroupArray = null;
                }
            }
        }
        if (bl2) {
            n3 = 0;
            while (n3 < n4) {
                n2 = threadGroupArray[n3].enumerate(threadArray, n2, true);
                ++n3;
            }
        }
        return n2;
    }

    public int enumerate(Thread[] threadArray, boolean bl2) {
        this.checkAccess();
        return this.enumerate(threadArray, 0, bl2);
    }

    public final ThreadGroup getParent() {
        if (this.parent != null) {
            this.parent.checkAccess();
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void add(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.groups == null) {
                this.groups = new ThreadGroup[4];
            } else if (this.ngroups == this.groups.length) {
                ThreadGroup[] threadGroupArray = new ThreadGroup[this.ngroups * 2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, this.ngroups);
                this.groups = threadGroupArray;
            }
            this.groups[this.ngroups] = threadGroup;
            ++this.ngroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                return;
            }
            int n2 = 0;
            while (n2 < this.ngroups) {
                if (this.groups[n2] == threadGroup) {
                    --this.ngroups;
                    System.arraycopy(this.groups, n2 + 1, this.groups, n2, this.ngroups - n2);
                    this.groups[this.ngroups] = null;
                    break;
                }
                ++n2;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
        }
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup == this) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enumerate(ThreadGroup[] threadGroupArray, int n2, boolean bl2) {
        int n3;
        int n4 = 0;
        ThreadGroup[] threadGroupArray2 = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                return 0;
            }
            n3 = this.ngroups;
            if (n3 > threadGroupArray.length - n2) {
                n3 = threadGroupArray.length - n2;
            }
            if (n3 > 0) {
                System.arraycopy(this.groups, 0, threadGroupArray, n2, n3);
                n2 += n3;
            }
            if (bl2) {
                n4 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray2 = new ThreadGroup[n4];
                    System.arraycopy(this.groups, 0, threadGroupArray2, 0, n4);
                } else {
                    threadGroupArray2 = null;
                }
            }
        }
        if (bl2) {
            n3 = 0;
            while (n3 < n4) {
                n2 = threadGroupArray2[n3].enumerate(threadGroupArray, n2, true);
                ++n3;
            }
        }
        return n2;
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl2) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, 0, bl2);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            throw new NullPointerException();
        }
        threadGroup.checkAccess();
        this.name = string;
        this.maxPriority = threadGroup.maxPriority;
        this.daemon = threadGroup.daemon;
        this.vmAllowSuspension = threadGroup.vmAllowSuspension;
        this.parent = threadGroup;
        threadGroup.add(this);
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        } else if (!(throwable instanceof ThreadDeath)) {
            throwable.printStackTrace(System.err);
        }
    }
}

