/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Vector;

public class Book
implements Pageable {
    private Vector mPages = new Vector();

    public int getNumberOfPages() {
        return this.mPages.size();
    }

    private BookPage getPage(int n2) throws ArrayIndexOutOfBoundsException {
        return (BookPage)this.mPages.elementAt(n2);
    }

    public PageFormat getPageFormat(int n2) throws IndexOutOfBoundsException {
        return this.getPage(n2).getPageFormat();
    }

    public Printable getPrintable(int n2) throws IndexOutOfBoundsException {
        return this.getPage(n2).getPrintable();
    }

    public void setPage(int n2, Printable printable, PageFormat pageFormat) throws IndexOutOfBoundsException {
        if (printable == null) {
            throw new NullPointerException("painter is null");
        }
        if (pageFormat == null) {
            throw new NullPointerException("page is null");
        }
        this.mPages.setElementAt(new BookPage(this, printable, pageFormat), n2);
    }

    public void append(Printable printable, PageFormat pageFormat) {
        this.mPages.addElement(new BookPage(this, printable, pageFormat));
    }

    public void append(Printable printable, PageFormat pageFormat, int n2) {
        BookPage bookPage = new BookPage(this, printable, pageFormat);
        int n3 = this.mPages.size();
        int n4 = n3 + n2;
        this.mPages.setSize(n4);
        int n5 = n3;
        while (n5 < n4) {
            this.mPages.setElementAt(bookPage, n5);
            ++n5;
        }
    }

    private class BookPage {
        private PageFormat mFormat;
        private Printable mPainter;
        private final Book this$0;

        PageFormat getPageFormat() {
            return this.mFormat;
        }

        Printable getPrintable() {
            return this.mPainter;
        }

        BookPage(Book book, Printable printable, PageFormat pageFormat) {
            this.this$0 = book;
            if (printable == null || pageFormat == null) {
                throw new NullPointerException();
            }
            this.mFormat = pageFormat;
            this.mPainter = printable;
        }
    }
}

