/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    public abstract int filterRGB(int var1, int var2, int var3);

    public void filterRGBPixels(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        int n8 = n6;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = 0;
            while (n10 < n4) {
                nArray[n8] = this.filterRGB(n2 + n10, n3 + n9, nArray[n8]);
                ++n8;
                ++n10;
            }
            n8 += n7 - n4;
            ++n9;
        }
        this.consumer.setPixels(n2, n3, n4, n5, ColorModel.getRGBdefault(), nArray, n6, n7);
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n2, n3, n4, n5, this.newmodel, byArray, n6, n7);
        } else {
            int[] nArray = new int[n4];
            int n8 = n6;
            int n9 = 0;
            while (n9 < n5) {
                int n10 = 0;
                while (n10 < n4) {
                    nArray[n10] = colorModel.getRGB(byArray[n8] & 0xFF);
                    ++n8;
                    ++n10;
                }
                n8 += n7 - n4;
                this.filterRGBPixels(n2, n3 + n9, n4, 1, nArray, 0, n4);
                ++n9;
            }
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        if (colorModel == this.origmodel) {
            this.consumer.setPixels(n2, n3, n4, n5, this.newmodel, nArray, n6, n7);
        } else {
            int[] nArray2 = new int[n4];
            int n8 = n6;
            int n9 = 0;
            while (n9 < n5) {
                int n10 = 0;
                while (n10 < n4) {
                    nArray2[n10] = colorModel.getRGB(nArray[n8]);
                    ++n8;
                    ++n10;
                }
                n8 += n7 - n4;
                this.filterRGBPixels(n2, n3 + n9, n4, 1, nArray2, 0, n4);
                ++n9;
            }
        }
    }

    public void setColorModel(ColorModel colorModel) {
        if (this.canFilterIndexColorModel && colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = this.filterIndexColorModel((IndexColorModel)colorModel);
            this.substituteColorModel(colorModel, indexColorModel);
            this.consumer.setColorModel(indexColorModel);
        } else {
            this.consumer.setColorModel(ColorModel.getRGBdefault());
        }
    }

    public void substituteColorModel(ColorModel colorModel, ColorModel colorModel2) {
        this.origmodel = colorModel;
        this.newmodel = colorModel2;
    }

    public IndexColorModel filterIndexColorModel(IndexColorModel indexColorModel) {
        int n2 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        indexColorModel.getAlphas(byArray4);
        int n3 = indexColorModel.getTransparentPixel();
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.filterRGB(-1, -1, indexColorModel.getRGB(n4));
            byArray4[n4] = (byte)(n5 >> 24);
            if (byArray4[n4] != -1 && n4 != n3) {
                bl2 = true;
            }
            byArray[n4] = (byte)(n5 >> 16);
            byArray2[n4] = (byte)(n5 >> 8);
            byArray3[n4] = (byte)(n5 >> 0);
            ++n4;
        }
        if (bl2) {
            return new IndexColorModel(indexColorModel.getPixelSize(), n2, byArray, byArray2, byArray3, byArray4);
        }
        return new IndexColorModel(indexColorModel.getPixelSize(), n2, byArray, byArray2, byArray3, n3);
    }
}

