/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

public abstract class DataBuffer {
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_USHORT = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DOUBLE = 5;
    public static final int TYPE_UNDEFINED = 32;
    protected int dataType;
    protected int banks;
    protected int offset;
    protected int size;
    protected int[] offsets;
    private static final int[] dataTypeSize = new int[]{8, 16, 16, 32, 32, 64};

    public int getDataType() {
        return this.dataType;
    }

    public int getNumBanks() {
        return this.banks;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int[] getOffsets() {
        return (int[])this.offsets.clone();
    }

    public double getElemDouble(int n2) {
        return this.getElem(n2);
    }

    public float getElemFloat(int n2) {
        return this.getElem(n2);
    }

    public static int getDataTypeSize(int n2) {
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException("Unknown data type " + n2);
        }
        return dataTypeSize[n2];
    }

    public int getElem(int n2) {
        return this.getElem(0, n2);
    }

    public void setElemDouble(int n2, double d2) {
        this.setElem(n2, (int)d2);
    }

    public void setElemFloat(int n2, float f2) {
        this.setElem(n2, (int)f2);
    }

    public double getElemDouble(int n2, int n3) {
        return this.getElem(n2, n3);
    }

    public float getElemFloat(int n2, int n3) {
        return this.getElem(n2, n3);
    }

    public abstract int getElem(int var1, int var2);

    protected DataBuffer(int n2, int n3) {
        this.dataType = n2;
        this.banks = 1;
        this.size = n3;
        this.offset = 0;
        this.offsets = new int[1];
    }

    public void setElem(int n2, int n3) {
        this.setElem(0, n2, n3);
    }

    public void setElemDouble(int n2, int n3, double d2) {
        this.setElem(n2, n3, (int)d2);
    }

    public void setElemFloat(int n2, int n3, float f2) {
        this.setElem(n2, n3, (int)f2);
    }

    protected DataBuffer(int n2, int n3, int n4) {
        this.dataType = n2;
        this.banks = n4;
        this.size = n3;
        this.offset = 0;
        this.offsets = new int[this.banks];
    }

    public abstract void setElem(int var1, int var2, int var3);

    protected DataBuffer(int n2, int n3, int n4, int n5) {
        this.dataType = n2;
        this.banks = n4;
        this.size = n3;
        this.offset = n5;
        this.offsets = new int[n4];
        int n6 = 0;
        while (n6 < n4) {
            this.offsets[n6] = n5;
            ++n6;
        }
    }

    protected DataBuffer(int n2, int n3, int n4, int[] nArray) {
        if (n4 != nArray.length) {
            throw new ArrayIndexOutOfBoundsException("Number of banks does not match number of bank offsets");
        }
        this.dataType = n2;
        this.banks = n4;
        this.size = n3;
        this.offset = nArray[0];
        this.offsets = (int[])nArray.clone();
    }

    static int[] toIntArray(Object object) {
        if (object instanceof int[]) {
            return (int[])object;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int[] nArray = new int[sArray.length];
            int n2 = 0;
            while (n2 < sArray.length) {
                nArray[n2] = sArray[n2] & 0xFFFF;
                ++n2;
            }
            return nArray;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int[] nArray = new int[byArray.length];
            int n3 = 0;
            while (n3 < byArray.length) {
                nArray[n3] = 0xFF & byArray[n3];
                ++n3;
            }
            return nArray;
        }
        return null;
    }
}

