/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

class ArcIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    double angStRad;
    double angExtDeg;
    AffineTransform affine;
    int index;
    int arcSegs;
    int lineSegs;

    public int getWindingRule() {
        return 1;
    }

    public void next() {
        ++this.index;
    }

    public boolean isDone() {
        return this.index > this.arcSegs + this.lineSegs;
    }

    private static double btan(double d2) {
        double d3 = 1.0 - Math.cos(d2 /= 2.0);
        double d4 = Math.tan(d2);
        double d5 = Math.sqrt(1.0 + d4 * d4) - 1.0 + d3;
        return 1.3333333333333333 * d3 * d4 / d5;
    }

    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("arc iterator out of bounds");
        }
        double d2 = this.angStRad;
        if (this.index == 0) {
            dArray[0] = this.x + Math.cos(d2) * this.w;
            dArray[1] = this.y + Math.sin(d2) * this.h;
            if (this.affine != null) {
                this.affine.transform(dArray, 0, dArray, 0, 1);
            }
            return 0;
        }
        if (this.index > this.arcSegs) {
            if (this.index == this.arcSegs + this.lineSegs) {
                return 4;
            }
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.affine != null) {
                this.affine.transform(dArray, 0, dArray, 0, 1);
            }
            return 1;
        }
        double d3 = this.angExtDeg;
        if (d3 > 360.0) {
            d3 = 360.0;
        } else if (d3 < -360.0) {
            d3 = -360.0;
        }
        d3 /= (double)this.arcSegs;
        d3 = Math.toRadians(d3);
        double d4 = Math.cos(d2 += d3 * (double)(this.index - 1));
        double d5 = Math.sin(d2);
        double d6 = ArcIterator.btan(d3);
        dArray[0] = this.x + (d4 - d6 * d5) * this.w;
        dArray[1] = this.y + (d5 + d6 * d4) * this.h;
        d4 = Math.cos(d2 += d3);
        d5 = Math.sin(d2);
        dArray[2] = this.x + (d4 + d6 * d5) * this.w;
        dArray[3] = this.y + (d5 - d6 * d4) * this.h;
        dArray[4] = this.x + d4 * this.w;
        dArray[5] = this.y + d5 * this.h;
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, 3);
        }
        return 3;
    }

    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("arc iterator out of bounds");
        }
        double d2 = this.angStRad;
        if (this.index == 0) {
            fArray[0] = (float)(this.x + Math.cos(d2) * this.w);
            fArray[1] = (float)(this.y + Math.sin(d2) * this.h);
            if (this.affine != null) {
                this.affine.transform(fArray, 0, fArray, 0, 1);
            }
            return 0;
        }
        if (this.index > this.arcSegs) {
            if (this.index == this.arcSegs + this.lineSegs) {
                return 4;
            }
            fArray[0] = (float)this.x;
            fArray[1] = (float)this.y;
            if (this.affine != null) {
                this.affine.transform(fArray, 0, fArray, 0, 1);
            }
            return 1;
        }
        double d3 = this.angExtDeg;
        if (d3 > 360.0) {
            d3 = 360.0;
        } else if (d3 < -360.0) {
            d3 = -360.0;
        }
        d3 /= (double)this.arcSegs;
        d3 = Math.toRadians(d3);
        double d4 = Math.cos(d2 += d3 * (double)(this.index - 1));
        double d5 = Math.sin(d2);
        double d6 = ArcIterator.btan(d3);
        fArray[0] = (float)(this.x + (d4 - d6 * d5) * this.w);
        fArray[1] = (float)(this.y + (d5 + d6 * d4) * this.h);
        d4 = Math.cos(d2 += d3);
        d5 = Math.sin(d2);
        fArray[2] = (float)(this.x + (d4 + d6 * d5) * this.w);
        fArray[3] = (float)(this.y + (d5 - d6 * d4) * this.h);
        fArray[4] = (float)(this.x + d4 * this.w);
        fArray[5] = (float)(this.y + d5 * this.h);
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, 3);
        }
        return 3;
    }

    ArcIterator(Arc2D arc2D, AffineTransform affineTransform) {
        this.w = arc2D.getWidth() / 2.0;
        this.h = arc2D.getHeight() / 2.0;
        this.x = arc2D.getX() + this.w;
        this.y = arc2D.getY() + this.h;
        this.angStRad = -Math.toRadians(arc2D.getAngleStart());
        this.angExtDeg = -arc2D.getAngleExtent();
        this.affine = affineTransform;
        double d2 = Math.abs(this.angExtDeg);
        this.arcSegs = d2 >= 360.0 ? 4 : (int)Math.ceil(d2 / 90.0);
        switch (arc2D.getArcType()) {
            case 0: {
                this.lineSegs = 0;
                break;
            }
            case 1: {
                this.lineSegs = 1;
                break;
            }
            case 2: {
                this.lineSegs = 2;
            }
        }
        if (this.w < 0.0 || this.h < 0.0) {
            this.lineSegs = -1;
            this.arcSegs = -1;
        }
    }
}

