/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.peer.TextComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.BreakIterator;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import sun.awt.InputMethodSupport;

public class TextComponent
extends Component
implements Accessible {
    String text;
    boolean editable = true;
    int selectionStart;
    int selectionEnd;
    boolean backgroundSetByClientCode = false;
    private transient boolean canAccessClipboard;
    protected transient TextListener textListener;
    private static final long serialVersionUID = -2214773872412987419L;
    private int textComponentSerializedDataVersion = 1;
    private boolean checkForEnableIM = true;
    static Class class$java$awt$event$TextListener;

    public synchronized int getCaretPosition() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        int n2 = 0;
        if (textComponentPeer != null) {
            n2 = textComponentPeer.getCaretPosition();
        }
        return n2;
    }

    public synchronized int getSelectionEnd() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        return this.selectionEnd;
    }

    public synchronized int getSelectionStart() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.selectionStart = textComponentPeer.getSelectionStart();
        }
        return this.selectionStart;
    }

    public void addNotify() {
        super.addNotify();
        this.enableInputMethodsIfNecessary();
    }

    private void checkSystemClipboardAccess() {
        block2: {
            this.canAccessClipboard = true;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) break block2;
            try {
                securityManager.checkSystemClipboardAccess();
            }
            catch (SecurityException securityException) {
                this.canAccessClipboard = false;
            }
        }
    }

    private void enableInputMethodsIfNecessary() {
        block3: {
            if (!this.checkForEnableIM) break block3;
            this.checkForEnableIM = false;
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                boolean bl2 = false;
                if (toolkit instanceof InputMethodSupport) {
                    bl2 = ((InputMethodSupport)((Object)toolkit)).enableInputMethodsForTextComponent();
                }
                this.enableInputMethods(bl2);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
            if (textComponentPeer != null) {
                this.text = textComponentPeer.getText();
                this.selectionStart = textComponentPeer.getSelectionStart();
                this.selectionEnd = textComponentPeer.getSelectionEnd();
            }
            super.removeNotify();
        }
    }

    public synchronized void selectAll() {
        String string = this.getText();
        this.selectionStart = 0;
        this.selectionEnd = this.getText().length();
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(this.selectionStart, this.selectionEnd);
        }
    }

    boolean areInputMethodsEnabled() {
        if (this.checkForEnableIM) {
            this.enableInputMethodsIfNecessary();
        }
        return (this.eventMask & 0x1000L) != 0L;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setCaretPosition(int n2) {
        TextComponentPeer textComponentPeer;
        if (n2 < 0) {
            throw new IllegalArgumentException("position less than zero.");
        }
        int n3 = this.getText().length();
        if (n2 > n3) {
            n2 = n3;
        }
        if ((textComponentPeer = (TextComponentPeer)this.peer) == null) {
            throw new IllegalComponentStateException("Cannot set caret position until after the peer has been created");
        }
        textComponentPeer.setCaretPosition(n2);
    }

    public synchronized void setSelectionEnd(int n2) {
        this.select(this.getSelectionStart(), n2);
    }

    public synchronized void setSelectionStart(int n2) {
        this.select(n2, this.getSelectionEnd());
    }

    public synchronized void select(int n2, int n3) {
        String string = this.getText();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n3 > string.length()) {
            n3 = string.length();
        }
        if (n3 < n2) {
            n3 = n2;
        }
        this.selectionStart = n2;
        this.selectionEnd = n3;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.select(n2, n3);
        }
    }

    public void enableInputMethods(boolean bl2) {
        this.checkForEnableIM = false;
        super.enableInputMethods(bl2);
    }

    public synchronized void setEditable(boolean bl2) {
        if (this.editable == bl2) {
            return;
        }
        this.editable = bl2;
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setEditable(bl2);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 900) {
            return (this.eventMask & 0x400L) != 0L || this.textListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public Color getBackground() {
        if (!this.editable && !this.backgroundSetByClientCode) {
            return SystemColor.control;
        }
        return super.getBackground();
    }

    public void setBackground(Color color) {
        this.backgroundSetByClientCode = true;
        super.setBackground(color);
    }

    int getIndexAtPoint(Point point) {
        return -1;
    }

    Rectangle getCharacterBounds(int n2) {
        return null;
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (this.textListener != null) {
            int n2 = textEvent.getID();
            switch (n2) {
                case 900: {
                    this.textListener.textValueChanged(textEvent);
                }
            }
        }
    }

    public synchronized TextListener[] getTextListeners() {
        return (TextListener[])this.getListeners(class$java$awt$event$TextListener == null ? (class$java$awt$event$TextListener = TextComponent.class$("java.awt.event.TextListener")) : class$java$awt$event$TextListener);
    }

    public synchronized void addTextListener(TextListener textListener) {
        if (textListener == null) {
            return;
        }
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeTextListener(TextListener textListener) {
        if (textListener == null) {
            return;
        }
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        this.text = this.text != null ? this.text : "";
        this.select(this.selectionStart, this.selectionEnd);
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("textL" == string) {
                this.addTextListener((TextListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
        this.enableInputMethodsIfNecessary();
        this.checkSystemClipboardAccess();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
            this.selectionStart = textComponentPeer.getSelectionStart();
            this.selectionEnd = textComponentPeer.getSelectionEnd();
        }
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "textL", this.textListener);
        objectOutputStream.writeObject(null);
    }

    public synchronized String getSelectedText() {
        return this.getText().substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public synchronized String getText() {
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            this.text = textComponentPeer.getText();
        }
        return this.text;
    }

    protected String paramString() {
        String string = super.paramString() + ",text=" + this.getText();
        if (this.editable) {
            string = string + ",editable";
        }
        return string + ",selection=" + this.getSelectionStart() + "-" + this.getSelectionEnd();
    }

    TextComponent(String string) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.text = string != null ? string : "";
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.checkSystemClipboardAccess();
    }

    public synchronized void setText(String string) {
        this.text = string != null ? string : "";
        TextComponentPeer textComponentPeer = (TextComponentPeer)this.peer;
        if (textComponentPeer != null) {
            textComponentPeer.setText(this.text);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextComponent(this);
        }
        return this.accessibleContext;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        TextListener textListener = null;
        if (clazz != (class$java$awt$event$TextListener == null ? (class$java$awt$event$TextListener = TextComponent.class$("java.awt.event.TextListener")) : class$java$awt$event$TextListener)) {
            return super.getListeners(clazz);
        }
        textListener = this.textListener;
        return AWTEventMulticaster.getListeners(textListener, clazz);
    }

    protected class AccessibleAWTTextComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleText,
    TextListener {
        private final TextComponent this$0;

        public int getCaretPosition() {
            return this.this$0.getCaretPosition();
        }

        public int getCharCount() {
            return this.this$0.getText().length();
        }

        public int getSelectionEnd() {
            return this.this$0.getSelectionEnd();
        }

        public int getSelectionStart() {
            return this.this$0.getSelectionStart();
        }

        public int getIndexAtPoint(Point point) {
            return this.this$0.getIndexAtPoint(point);
        }

        public Rectangle getCharacterBounds(int n2) {
            return this.this$0.getCharacterBounds(n2);
        }

        public AccessibleAWTTextComponent(TextComponent textComponent) {
            this.this$0 = textComponent;
            super(textComponent);
            textComponent.addTextListener(this);
        }

        public void textValueChanged(TextEvent textEvent) {
            Integer n2 = new Integer(this.this$0.getCaretPosition());
            this.firePropertyChange("AccessibleText", null, n2);
        }

        public String getSelectedText() {
            return this.this$0.getSelectedText();
        }

        public String getAfterIndex(int n2, int n3) {
            if (n3 < 0 || n3 >= this.this$0.getText().length()) {
                return null;
            }
            switch (n2) {
                case 1: {
                    if (n3 + 1 >= this.this$0.getText().length()) {
                        return null;
                    }
                    return this.this$0.getText().substring(n3 + 1, n3 + 2);
                }
                case 2: {
                    String string = this.this$0.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n4 = breakIterator.following(n3);
                    if (n4 == -1 || n4 >= string.length()) {
                        return null;
                    }
                    int n5 = breakIterator.following(n4);
                    if (n5 == -1 || n5 >= string.length()) {
                        return null;
                    }
                    return string.substring(n4, n5);
                }
                case 3: {
                    String string = this.this$0.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n6 = breakIterator.following(n3);
                    if (n6 == -1 || n6 >= string.length()) {
                        return null;
                    }
                    int n7 = breakIterator.following(n6);
                    if (n7 == -1 || n7 >= string.length()) {
                        return null;
                    }
                    return string.substring(n6, n7);
                }
            }
            return null;
        }

        public String getAtIndex(int n2, int n3) {
            if (n3 < 0 || n3 >= this.this$0.getText().length()) {
                return null;
            }
            switch (n2) {
                case 1: {
                    return this.this$0.getText().substring(n3, n3 + 1);
                }
                case 2: {
                    String string = this.this$0.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n4 = breakIterator.following(n3);
                    return string.substring(breakIterator.previous(), n4);
                }
                case 3: {
                    String string = this.this$0.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n5 = breakIterator.following(n3);
                    return string.substring(breakIterator.previous(), n5);
                }
            }
            return null;
        }

        public String getBeforeIndex(int n2, int n3) {
            if (n3 < 0 || n3 > this.this$0.getText().length() - 1) {
                return null;
            }
            switch (n2) {
                case 1: {
                    if (n3 == 0) {
                        return null;
                    }
                    return this.this$0.getText().substring(n3 - 1, n3);
                }
                case 2: {
                    String string = this.this$0.getText();
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string);
                    int n4 = breakIterator.following(n3);
                    n4 = breakIterator.previous();
                    int n5 = breakIterator.previous();
                    if (n5 == -1) {
                        return null;
                    }
                    return string.substring(n5, n4);
                }
                case 3: {
                    String string = this.this$0.getText();
                    BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                    breakIterator.setText(string);
                    int n6 = breakIterator.following(n3);
                    n6 = breakIterator.previous();
                    int n7 = breakIterator.previous();
                    if (n7 == -1) {
                        return null;
                    }
                    return string.substring(n7, n6);
                }
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public AttributeSet getCharacterAttribute(int n2) {
            return null;
        }
    }
}

