/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int newAlign;
    int hgap;
    int vgap;
    private static final long serialVersionUID = -7262534875583282631L;
    private static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;

    public int getAlignment() {
        return this.newAlign;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int n2) {
        this(n2, 5, 5);
    }

    public void setAlignment(int n2) {
        this.newAlign = n2;
        switch (n2) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = n2;
            }
        }
    }

    public void setHgap(int n2) {
        this.hgap = n2;
    }

    public void setVgap(int n2) {
        this.vgap = n2;
    }

    public FlowLayout(int n2, int n3, int n4) {
        this.hgap = n3;
        this.vgap = n4;
        this.setAlignment(n2);
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n2 = container.width - (insets.left + insets.right + this.hgap * 2);
            int n3 = container.getComponentCount();
            int n4 = 0;
            int n5 = insets.top + this.vgap;
            int n6 = 0;
            int n7 = 0;
            boolean bl2 = container.getComponentOrientation().isLeftToRight();
            int n8 = 0;
            while (n8 < n3) {
                Component component = container.getComponent(n8);
                if (component.visible) {
                    Dimension dimension = component.getPreferredSize();
                    component.setSize(dimension.width, dimension.height);
                    if (n4 == 0 || n4 + dimension.width <= n2) {
                        if (n4 > 0) {
                            n4 += this.hgap;
                        }
                        n4 += dimension.width;
                        n6 = Math.max(n6, dimension.height);
                    } else {
                        this.moveComponents(container, insets.left + this.hgap, n5, n2 - n4, n6, n7, n8, bl2);
                        n4 = dimension.width;
                        n5 += this.vgap + n6;
                        n6 = dimension.height;
                        n7 = n8;
                    }
                }
                ++n8;
            }
            this.moveComponents(container, insets.left + this.hgap, n5, n2 - n4, n6, n7, n3, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container container, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    n2 += bl2 ? 0 : n4;
                    break;
                }
                case 1: {
                    n2 += n4 / 2;
                    break;
                }
                case 2: {
                    n2 += bl2 ? n4 : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    n2 += n4;
                }
            }
            int n8 = n6;
            while (n8 < n7) {
                Component component = container.getComponent(n8);
                if (component.visible) {
                    if (bl2) {
                        component.setLocation(n2, n3 + (n5 - component.height) / 2);
                    } else {
                        component.setLocation(container.width - n2 - component.width, n3 + (n5 - component.height) / 2);
                    }
                    n2 += component.width + this.hgap;
                }
                ++n8;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.setAlignment(this.align);
        }
        this.serialVersionOnStream = 1;
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=left";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=right";
                break;
            }
            case 3: {
                string = ",align=leading";
                break;
            }
            case 4: {
                string = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }

    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Serializable serializable;
            Dimension dimension = new Dimension(0, 0);
            int n2 = container.getComponentCount();
            int n3 = 0;
            while (n3 < n2) {
                serializable = container.getComponent(n3);
                if (((Component)serializable).visible) {
                    Dimension dimension2 = ((Component)serializable).getMinimumSize();
                    dimension.height = Math.max(dimension.height, dimension2.height);
                    if (n3 > 0) {
                        dimension.width += this.hgap;
                    }
                    dimension.width += dimension2.width;
                }
                ++n3;
            }
            serializable = container.getInsets();
            dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
            dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Serializable serializable;
            Dimension dimension = new Dimension(0, 0);
            int n2 = container.getComponentCount();
            boolean bl2 = true;
            int n3 = 0;
            while (n3 < n2) {
                serializable = container.getComponent(n3);
                if (((Component)serializable).visible) {
                    Dimension dimension2 = ((Component)serializable).getPreferredSize();
                    dimension.height = Math.max(dimension.height, dimension2.height);
                    if (bl2) {
                        bl2 = false;
                    } else {
                        dimension.width += this.hgap;
                    }
                    dimension.width += dimension2.width;
                }
                ++n3;
            }
            serializable = container.getInsets();
            dimension.width += ((Insets)serializable).left + ((Insets)serializable).right + this.hgap * 2;
            dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom + this.vgap * 2;
            return dimension;
        }
    }
}

