/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CardLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = -4328196481005934313L;
    Vector vector = new Vector();
    int currentCard = 0;
    int hgap;
    int vgap;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("tab", class$java$util$Hashtable == null ? (class$java$util$Hashtable = CardLayout.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("hgap", Integer.TYPE), new ObjectStreamField("vgap", Integer.TYPE), new ObjectStreamField("vector", class$java$util$Vector == null ? (class$java$util$Vector = CardLayout.class$("java.util.Vector")) : class$java$util$Vector), new ObjectStreamField("currentCard", Integer.TYPE)};
    static Class class$java$util$Hashtable;
    static Class class$java$util$Vector;

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public CardLayout() {
        this(0, 0);
    }

    public void setHgap(int n2) {
        this.hgap = n2;
    }

    public void setVgap(int n2) {
        this.vgap = n2;
    }

    public CardLayout(int n2, int n3) {
        this.hgap = n2;
        this.vgap = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.vector.size()) {
                if (((Card)this.vector.get((int)n2)).comp == component) {
                    Container container;
                    if (component.isVisible() && (container = component.getParent()) != null) {
                        this.next(container);
                    }
                    this.vector.remove(n2);
                    if (n2 >= this.currentCard) break;
                    --this.currentCard;
                    break;
                }
                ++n2;
            }
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    void checkLayout(Container container) {
        if (container.getLayout() != this) {
            throw new IllegalArgumentException("wrong parent for CardLayout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void first(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            this.show(container, 0);
        }
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void last(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            this.show(container, this.vector.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            if (!this.vector.isEmpty()) {
                Component component = ((Card)this.vector.get((int)this.currentCard)).comp;
                component.setBounds(this.hgap + insets.left, this.vgap + insets.top, container.width - (this.hgap * 2 + insets.left + insets.right), container.height - (this.vgap * 2 + insets.top + insets.bottom));
                if (!component.isVisible()) {
                    component.setVisible(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            this.show(container, (this.currentCard + 1) % this.vector.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previous(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            int n2 = (this.currentCard + this.vector.size() - 1) % this.vector.size();
            this.show(container, n2);
        }
    }

    void show(Container container, int n2) {
        if (!this.vector.isEmpty() && this.currentCard != n2) {
            ((Card)this.vector.get((int)this.currentCard)).comp.setVisible(false);
            this.currentCard = n2;
            ((Card)this.vector.get((int)this.currentCard)).comp.setVisible(true);
            container.validate();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.hgap = getField.get("hgap", 0);
        this.vgap = getField.get("vgap", 0);
        if (getField.defaulted("vector")) {
            Hashtable hashtable = (Hashtable)getField.get("tab", null);
            this.vector = new Vector();
            if (hashtable != null && !hashtable.isEmpty()) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Component component = (Component)hashtable.get(string);
                    this.vector.add(new Card(this, string, component));
                    if (!component.isVisible()) continue;
                    this.currentCard = this.vector.size() - 1;
                }
            }
        } else {
            this.vector = (Vector)getField.get("vector", null);
            this.currentCard = getField.get("currentCard", 0);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        Hashtable hashtable = new Hashtable();
        int n2 = this.vector.size();
        int n3 = 0;
        while (n3 < n2) {
            object = (Card)this.vector.get(n3);
            hashtable.put(((Card)object).name, ((Card)object).comp);
            ++n3;
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("hgap", this.hgap);
        ((ObjectOutputStream.PutField)object).put("vgap", this.vgap);
        ((ObjectOutputStream.PutField)object).put("vector", this.vector);
        ((ObjectOutputStream.PutField)object).put("currentCard", this.currentCard);
        ((ObjectOutputStream.PutField)object).put("tab", hashtable);
        objectOutputStream.writeFields();
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String string, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (!this.vector.isEmpty()) {
                component.setVisible(false);
            }
            int n2 = 0;
            while (n2 < this.vector.size()) {
                if (((Card)this.vector.get((int)n2)).name.equals(string)) {
                    this.vector.remove(n2);
                    break;
                }
                ++n2;
            }
            this.vector.add(new Card(this, string, component));
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n2 = this.vector.size();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                Component component = ((Card)this.vector.get((int)n5)).comp;
                Dimension dimension = component.getMinimumSize();
                if (dimension.width > n3) {
                    n3 = dimension.width;
                }
                if (dimension.height > n4) {
                    n4 = dimension.height;
                }
                ++n5;
            }
            return new Dimension(insets.left + insets.right + n3 + this.hgap * 2, insets.top + insets.bottom + n4 + this.vgap * 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n2 = this.vector.size();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                Component component = ((Card)this.vector.get((int)n5)).comp;
                Dimension dimension = component.getPreferredSize();
                if (dimension.width > n3) {
                    n3 = dimension.width;
                }
                if (dimension.height > n4) {
                    n4 = dimension.height;
                }
                ++n5;
            }
            return new Dimension(insets.left + insets.right + n3 + this.hgap * 2, insets.top + insets.bottom + n4 + this.vgap * 2);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
            }
            this.addLayoutComponent((String)object, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Container container, String string) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkLayout(container);
            if (((Card)this.vector.get((int)this.currentCard)).name.equals(string)) {
                return;
            }
            int n2 = this.vector.size();
            int n3 = 0;
            while (n3 < n2) {
                Card card = (Card)this.vector.get(n3);
                if (card.name.equals(string)) {
                    this.show(container, n3);
                    break;
                }
                ++n3;
            }
        }
    }

    class Card
    implements Serializable {
        static final long serialVersionUID = 6640330810709497518L;
        public String name;
        public Component comp;
        private final CardLayout this$0;

        public Card(CardLayout cardLayout, String string, Component component) {
            this.this$0 = cardLayout;
            this.name = string;
            this.comp = component;
        }
    }
}

