/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DataPusher;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class JavaSoundAudioClip
implements AudioClip,
MetaEventListener,
LineListener {
    private Clip clip = null;
    private Sequencer sequencer = null;
    private SourceDataLine sourceline = null;
    private DataPusher datapusher = null;
    private boolean sequencerloop = false;
    private boolean streamloop = false;
    private byte[] loadedAudio = null;
    private long clipthresh = 0x100000L;
    static Class class$javax$sound$sampled$SourceDataLine;
    static Class class$javax$sound$sampled$Clip;

    protected void finalize() {
        if (this.clip != null) {
            this.clip.close();
        }
        if (this.sourceline != null) {
            this.sourceline.close();
        }
    }

    public synchronized void loop() {
        if (this.clip != null) {
            this.stop();
            this.clip.loop(-1);
        } else if (this.datapusher != null) {
            this.stop();
            this.streamloop = true;
            this.sourceline.start();
            this.datapusher.start();
        } else if (this.sequencer != null) {
            this.stop();
            this.sequencerloop = true;
            this.sequencer.start();
        }
    }

    public synchronized void play() {
        if (this.clip != null) {
            this.stop();
            this.clip.start();
        } else if (this.datapusher != null) {
            this.stop();
            this.streamloop = false;
            this.sourceline.start();
            this.datapusher.start();
        } else if (this.sequencer != null) {
            this.stop();
            this.sequencerloop = false;
            this.sequencer.start();
        }
    }

    public synchronized void stop() {
        if (this.clip != null) {
            this.clip.stop();
            this.clip.setFramePosition(0);
        } else if (this.datapusher != null) {
            this.streamloop = false;
            this.datapusher.stop();
        } else if (this.sequencer != null) {
            this.sequencer.stop();
            this.sequencer.setMicrosecondPosition(0L);
        }
    }

    private int openAsSequence(BufferedInputStream bufferedInputStream) throws IOException {
        try {
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            return -1;
        }
        if (this.sequencer == null) {
            return -1;
        }
        this.sequencer.addMetaEventListener(this);
        try {
            this.sequencer.open();
            this.sequencer.setSequence(bufferedInputStream);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return -1;
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
            return -1;
        }
        return 0;
    }

    public JavaSoundAudioClip(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        int n2 = 1024;
        AudioInputStream audioInputStream = null;
        AudioFormat audioFormat = null;
        bufferedInputStream = new BufferedInputStream(inputStream, n2);
        bufferedInputStream.mark(n2);
        try {
            audioInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);
            audioFormat = audioInputStream.getFormat();
            long l2 = audioInputStream.getFrameLength();
            if (l2 != -1L && l2 > 0L && l2 < this.clipthresh ? this.openAsClip(audioInputStream) < 0 : this.openAsStream(audioInputStream) < 0) {
                throw new IOException("Unable to create AudioClip from input stream");
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            try {
                MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(bufferedInputStream);
                if (this.openAsSequence(bufferedInputStream) < 0) {
                    throw new IOException("Unable to create AudioClip from input stream");
                }
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                throw new IOException("Unable to create AudioClip from input stream");
            }
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    public synchronized void meta(MetaMessage metaMessage) {
        if (metaMessage.getType() == 47) {
            if (this.sequencerloop) {
                this.sequencer.setMicrosecondPosition(0L);
                this.loop();
            } else {
                this.stop();
            }
        }
    }

    private int loadStreamIntoMemory(AudioInputStream audioInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16834];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if ((n2 = audioInputStream.read(byArray, 0, byArray.length)) <= 0) break;
            n3 += n2;
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        audioInputStream.close();
        this.loadedAudio = byteArrayOutputStream.toByteArray();
        return n3;
    }

    private int openAsClip(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        DataLine.Info info = null;
        if ((audioInputStream = this.convertToPlayableStream(audioInputStream)) == null) {
            return -1;
        }
        try {
            info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = JavaSoundAudioClip.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength());
            if (!AudioSystem.isLineSupported(info)) {
                return -1;
            }
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(audioInputStream);
        }
        catch (LineUnavailableException lineUnavailableException) {
            return -1;
        }
        if (this.clip == null) {
            return -1;
        }
        return 0;
    }

    private int openAsStream(AudioInputStream audioInputStream) throws IOException, UnsupportedAudioFileException {
        DataLine.Info info = null;
        AudioFormat audioFormat = audioInputStream.getFormat();
        if ((audioInputStream = this.convertToPlayableStream(audioInputStream)) == null) {
            return -1;
        }
        if (this.loadStreamIntoMemory(audioInputStream) <= 0) {
            return -1;
        }
        try {
            info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = JavaSoundAudioClip.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioInputStream.getFormat());
            if (!AudioSystem.isLineSupported(info)) {
                return -1;
            }
            this.sourceline = (SourceDataLine)AudioSystem.getLine(info);
            this.sourceline.addLineListener(this);
            this.datapusher = new DataPusher(this.sourceline, this.loadedAudio);
            this.sourceline.open();
        }
        catch (LineUnavailableException lineUnavailableException) {
            return -1;
        }
        if (this.datapusher == null) {
            return -1;
        }
        return 0;
    }

    public synchronized void update(LineEvent lineEvent) {
        if (this.streamloop && this.datapusher != null && lineEvent.getType() == LineEvent.Type.STOP) {
            this.loop();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private AudioInputStream convertToPlayableStream(AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().getEncoding() == AudioFormat.Encoding.ULAW || audioInputStream.getFormat().getEncoding() == AudioFormat.Encoding.ALAW) {
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioInputStream audioInputStream2 = audioInputStream;
            audioInputStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() * 2, audioFormat.getChannels(), audioFormat.getFrameSize() * 2, audioFormat.getFrameRate(), true), audioInputStream2);
        }
        return audioInputStream;
    }
}

