/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.MixerClip;
import com.sun.media.sound.MixerSourceLine;
import com.sun.media.sound.Platform;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.ReverbType;

class HeadspaceMixer
extends AbstractMixer {
    public static final int INTERPOLATION_DROP_SAMPLE = 0;
    public static final int INTERPOLATION_2_POINT = 1;
    public static final int INTERPOLATION_LINEAR = 2;
    private static int TOTAL_VOICES;
    private static int DEFAULT_BUFFER_SIZE;
    static final int MAX_SAMPLES = 0x100000;
    static final int MAX_FRAME_SIZE = 4;
    private static final AudioFormat.Encoding encoding8;
    private static final AudioFormat.Encoding encoding16;
    private static final AudioFormat[] sourceLineFormats;
    private static final AudioFormat[] mixFormats;
    private DataLine.Info sourceDataLineInfo = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = HeadspaceMixer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, sourceLineFormats, 0, -1);
    private final DataLine.Info clipInfo = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = HeadspaceMixer.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, sourceLineFormats, 0, 0x400000);
    private final DataLine.Info[] supportedInGroup = new DataLine.Info[]{this.sourceDataLineInfo, this.clipInfo};
    private final DataLine.Info targetDeviceLineInfo = new DataLine.Info(class$javax$sound$sampled$DataLine == null ? (class$javax$sound$sampled$DataLine = HeadspaceMixer.class$("javax.sound.sampled.DataLine")) : class$javax$sound$sampled$DataLine, mixFormats, 0, -1);
    private static final AudioFormat defaultFormat;
    private static final int defaultMixLevel = 6;
    private static final int defaultInterpolationMode = 2;
    private int sampledVoices;
    private int midiVoices;
    private int mixLevel;
    private int terpMode;
    Vector openMidiDevices = new Vector();
    private static final HeadspaceMixer mixerInstance;
    static Class class$javax$sound$sampled$SourceDataLine;
    static Class class$javax$sound$sampled$Clip;
    static Class class$javax$sound$sampled$DataLine;
    static Class class$com$sun$media$sound$MixerSourceLine;
    static Class class$com$sun$media$sound$MixerClip;

    public float getCpuLoad() {
        return this.nGetCpuLoad();
    }

    private native float nGetCpuLoad();

    private native float nGetLevel();

    public int getInterpolationMode() {
        return this.terpMode;
    }

    public int getMidiVoices() {
        return this.midiVoices;
    }

    public int getMixLevel() {
        return this.mixLevel;
    }

    public int getSampledVoices() {
        return this.sampledVoices;
    }

    public int getSystemVoices() {
        return TOTAL_VOICES;
    }

    private static native int nGetDefaultBufferSize();

    private static native int nGetTotalVoices();

    private native long nGetPosition();

    static {
        DEFAULT_BUFFER_SIZE = -1;
        encoding8 = Platform.isSigned8() ? AudioFormat.Encoding.PCM_SIGNED : AudioFormat.Encoding.PCM_UNSIGNED;
        encoding16 = AudioFormat.Encoding.PCM_SIGNED;
        sourceLineFormats = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 2, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 2, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false)};
        mixFormats = new AudioFormat[]{new AudioFormat(encoding16, 11025.0f, 16, 1, 2, 11025.0f, false), new AudioFormat(encoding16, 11025.0f, 16, 2, 4, 11025.0f, false), new AudioFormat(encoding8, 11025.0f, 8, 1, 1, 11025.0f, true), new AudioFormat(encoding8, 11025.0f, 8, 2, 2, 11025.0f, true), new AudioFormat(encoding16, 11025.0f, 16, 1, 2, 11025.0f, true), new AudioFormat(encoding16, 11025.0f, 16, 2, 4, 11025.0f, true), new AudioFormat(encoding8, 22050.0f, 8, 1, 1, 22050.0f, false), new AudioFormat(encoding8, 22050.0f, 8, 2, 2, 22050.0f, false), new AudioFormat(encoding16, 22050.0f, 16, 1, 2, 22050.0f, false), new AudioFormat(encoding16, 22050.0f, 16, 2, 4, 22050.0f, false), new AudioFormat(encoding8, 22050.0f, 8, 1, 1, 22050.0f, true), new AudioFormat(encoding8, 22050.0f, 8, 2, 2, 22050.0f, true), new AudioFormat(encoding16, 22050.0f, 16, 1, 2, 22050.0f, true), new AudioFormat(encoding16, 22050.0f, 16, 2, 4, 22050.0f, true), new AudioFormat(encoding8, 44100.0f, 8, 1, 1, 44100.0f, false), new AudioFormat(encoding8, 44100.0f, 8, 2, 2, 44100.0f, false), new AudioFormat(encoding16, 44100.0f, 16, 1, 2, 44100.0f, false), new AudioFormat(encoding16, 44100.0f, 16, 2, 4, 44100.0f, false), new AudioFormat(encoding8, 44100.0f, 8, 1, 1, 44100.0f, true), new AudioFormat(encoding8, 44100.0f, 8, 2, 2, 44100.0f, true), new AudioFormat(encoding16, 44100.0f, 16, 1, 2, 44100.0f, true), new AudioFormat(encoding16, 44100.0f, 16, 2, 4, 44100.0f, true)};
        defaultFormat = mixFormats.length > 0 ? mixFormats[mixFormats.length - 1] : null;
        mixerInstance = new HeadspaceMixer();
    }

    private HeadspaceMixer() {
        super(null, new Control[1], defaultFormat, DEFAULT_BUFFER_SIZE, new MixerInfo(null), null, null);
        this.info = new DataLine.Info(class$javax$sound$sampled$DataLine == null ? (class$javax$sound$sampled$DataLine = HeadspaceMixer.class$("javax.sound.sampled.DataLine")) : class$javax$sound$sampled$DataLine, mixFormats, DEFAULT_BUFFER_SIZE, DEFAULT_BUFFER_SIZE);
        Platform.initialize();
        TOTAL_VOICES = HeadspaceMixer.nGetTotalVoices();
        DEFAULT_BUFFER_SIZE = HeadspaceMixer.nGetDefaultBufferSize();
        if (DEFAULT_BUFFER_SIZE == 0) {
            DEFAULT_BUFFER_SIZE = -1;
        }
        this.controls[0] = new MixerReverbControl(null);
        this.sourceLineInfo = new Line.Info[2];
        this.sourceLineInfo[0] = this.sourceDataLineInfo;
        this.sourceLineInfo[1] = this.clipInfo;
        this.targetLineInfo = new DataLine.Info[0];
        this.sampledVoices = TOTAL_VOICES / 2;
        this.midiVoices = TOTAL_VOICES / 2;
        this.mixLevel = 6;
        this.terpMode = 2;
    }

    public synchronized void implClose() {
        this.nPause();
        this.nCloseMixer();
    }

    synchronized void implStart() {
        this.setActive(true);
        this.setStarted(true);
    }

    synchronized void implStop() {
        this.setActive(false);
        this.setStarted(false);
    }

    private native void nCloseMixer();

    private native void nDrain();

    private native void nFlush();

    private native void nPause();

    private native void nResume() throws LineUnavailableException;

    static int access$400(int n2) {
        return HeadspaceMixer.nSetReverb(n2);
    }

    private static native int nSetReverb(int var0);

    private native boolean nSetInterpolation(int var1);

    private native boolean nSetMixLevel(int var1);

    public boolean setInterpolationMode(int n2) {
        if (!this.nSetInterpolation(n2)) {
            return false;
        }
        this.terpMode = n2;
        return true;
    }

    public boolean setMixLevel(int n2) {
        if (!this.nSetMixLevel(n2)) {
            return false;
        }
        this.mixLevel = n2;
        return true;
    }

    public boolean allocateVoices(int n2, int n3) {
        if (!this.nAllocateVoices(n2, n3)) {
            return false;
        }
        this.midiVoices = n2;
        this.sampledVoices = n3;
        return true;
    }

    private native boolean nAllocateVoices(int var1, int var2);

    private native boolean nSetMixerFormat(int var1, int var2, int var3);

    private native void nOpenMixer(int var1, int var2, int var3, int var4, int var5, int var6, int var7) throws LineUnavailableException;

    private native void nStopLinkedStreams(long var1);

    private native boolean nStartLinkedStreams(long var1);

    private native long nCreateLinkedStreams(long[] var1);

    static HeadspaceMixer getMixerInstance() {
        return mixerInstance;
    }

    void close(MidiDevice midiDevice) {
        this.openMidiDevices.removeElement(midiDevice);
        Line line = null;
        this.stop(line);
        this.close(line);
    }

    void open(MidiDevice midiDevice) throws MidiUnavailableException {
        if (!this.openMidiDevices.contains(midiDevice)) {
            this.openMidiDevices.addElement(midiDevice);
            try {
                this.open();
                this.start();
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.openMidiDevices.removeElement(midiDevice);
                throw new MidiUnavailableException(lineUnavailableException.getMessage());
            }
        }
    }

    public synchronized void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        this.nOpenMixer(audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), (int)audioFormat.getSampleRate(), this.terpMode, this.midiVoices, this.sampledVoices, this.mixLevel);
        this.nResume();
        this.format = audioFormat;
        this.bufferSize = HeadspaceMixer.nGetDefaultBufferSize();
        if (this.bufferSize <= 0) {
            this.bufferSize = -1;
        }
    }

    protected void close(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty() && this.openMidiDevices.isEmpty()) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(Line line) {
        if (this.equals(line)) {
            return;
        }
        Vector vector = this.sourceLines;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < this.sourceLines.size()) {
                AbstractDataLine abstractDataLine;
                if (this.sourceLines.elementAt(n2) instanceof AbstractDataLine && (abstractDataLine = (AbstractDataLine)this.sourceLines.elementAt(n2)).isStartedRunning() && !abstractDataLine.equals(line)) {
                    return;
                }
                ++n2;
            }
        }
        Vector vector2 = this.targetLines;
        synchronized (vector2) {
            int n3 = 0;
            while (n3 < this.targetLines.size()) {
                AbstractDataLine abstractDataLine = (AbstractDataLine)this.targetLines.elementAt(n3);
                if (abstractDataLine.isStartedRunning() && !abstractDataLine.equals(line)) {
                    return;
                }
                ++n3;
            }
        }
        if (!this.openMidiDevices.isEmpty()) {
            return;
        }
        this.stop();
    }

    public int getMaxLines(Line.Info info) {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            return 0;
        }
        if (info2 instanceof DataLine.Info && this.isSourceLine(info2)) {
            return this.sampledVoices;
        }
        if (info2 instanceof DataLine.Info && this.isTargetLine(info2)) {
            return 1;
        }
        return 0;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info info2 = this.getLineInfo(info);
        if (info2 == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (info2 instanceof DataLine.Info) {
            AudioFormat audioFormat;
            DataLine.Info info3 = (DataLine.Info)info2;
            int n2 = -1;
            AudioFormat[] audioFormatArray = null;
            if (info instanceof DataLine.Info) {
                audioFormatArray = ((DataLine.Info)info).getFormats();
                n2 = ((DataLine.Info)info).getMaxBufferSize();
            }
            if (audioFormatArray == null || audioFormatArray.length == 0) {
                audioFormatArray = info3.getFormats();
            }
            if ((audioFormat = audioFormatArray[audioFormatArray.length - 1]).getSampleRate() == -1.0f) {
                audioFormat = new AudioFormat(audioFormat.getEncoding(), this.getFormat().getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian());
            }
            if (n2 == -1) {
                n2 = info3.getMaxBufferSize();
            }
            if (info3.getLineClass().isAssignableFrom(class$com$sun$media$sound$MixerSourceLine == null ? (class$com$sun$media$sound$MixerSourceLine = HeadspaceMixer.class$("com.sun.media.sound.MixerSourceLine")) : class$com$sun$media$sound$MixerSourceLine)) {
                return new MixerSourceLine(this.sourceDataLineInfo, this, audioFormat, n2);
            }
            if (info3.getLineClass().isAssignableFrom(class$com$sun$media$sound$MixerClip == null ? (class$com$sun$media$sound$MixerClip = HeadspaceMixer.class$("com.sun.media.sound.MixerClip")) : class$com$sun$media$sound$MixerClip)) {
                return new MixerClip(this.clipInfo, this, audioFormat, n2);
            }
        }
        throw new SecurityException("Access to line not granted: " + info);
    }

    class 1 {
    }

    private static class MixerInfo
    extends Mixer.Info {
        private static final String name = "Java Sound Audio Engine";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software mixer and synthesizer";
        private static final String version = "1.0";

        private MixerInfo() {
            super(name, vendor, description, version);
        }

        MixerInfo(1 var1_1) {
            this();
        }
    }

    private static class MixerReverbControl
    extends EnumControl {
        private static final MixerReverbType NO_REVERB = new MixerReverbType("No Reverb", 0, 0.0f, 0, 0.0f, 0, 1, null);
        private static final MixerReverbType CLOSET = new MixerReverbType("Closet", 600, -7.0f, 2500, -10.0f, 150000, 2, null);
        private static final MixerReverbType GARAGE = new MixerReverbType("Garage", 3900, -4.0f, 14700, -6.0f, 900000, 3, null);
        private static final MixerReverbType ACOUSTIC_LAB = new MixerReverbType("Acoustic Lab", 2000, -2.0f, 8000, -3.0f, 280000, 4, null);
        private static final MixerReverbType CAVERN = new MixerReverbType("Cavern", 10300, -1.4f, 41300, -2.0f, 2250000, 5, null);
        private static final MixerReverbType DUNGEON = new MixerReverbType("Dungeon", 2600, -0.7f, 10300, -1.0f, 1600000, 6, null);
        private static final ReverbType[] types = new ReverbType[]{NO_REVERB, CLOSET, GARAGE, ACOUSTIC_LAB, CAVERN, DUNGEON};
        private static final ReverbType defaultReverb = ACOUSTIC_LAB;

        private MixerReverbControl() {
            super(EnumControl.Type.REVERB, types, defaultReverb);
        }

        private void initializeReverb() {
            try {
                this.setValue(defaultReverb);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setValue(NO_REVERB);
            }
        }

        MixerReverbControl(1 var1_1) {
            this();
        }

        public void setValue(Object object) {
            int n2;
            if (!(object instanceof ReverbType)) {
                throw new IllegalArgumentException("Value must be of type ReverbType");
            }
            ReverbType reverbType = (ReverbType)object;
            if (reverbType instanceof MixerReverbType) {
                n2 = MixerReverbType.access$300((MixerReverbType)reverbType);
            } else if (object == NO_REVERB) {
                n2 = 1;
            } else {
                throw new IllegalArgumentException("Unknown reverb value: " + object);
            }
            int n3 = HeadspaceMixer.access$400(n2);
            if (n3 == n2) {
                super.setValue(object);
            } else if (n3 != 1) {
                int n4 = 0;
                while (n4 < types.length) {
                    if (types[n4] instanceof MixerReverbType && MixerReverbType.access$300((MixerReverbType)types[n4]) == n3) {
                        super.setValue(types[n4]);
                    }
                    ++n4;
                }
            }
        }

        private static class MixerReverbType
        extends ReverbType {
            private final int reverbMode;

            private int getReverbMode() {
                return this.reverbMode;
            }

            static int access$300(MixerReverbType mixerReverbType) {
                return mixerReverbType.getReverbMode();
            }

            private MixerReverbType(String string, int n2, float f2, int n3, float f3, int n4, int n5) {
                super(string, n2, f2, n3, f3, n4);
                this.reverbMode = n5;
            }

            MixerReverbType(String string, int n2, float f2, int n3, float f3, int n4, int n5, 1 var8_8) {
                this(string, n2, f2, n3, f3, n4, n5);
            }
        }
    }
}

