/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;

abstract class AbstractMixer
extends AbstractDataLine
implements Mixer {
    protected static final int PCM = 0;
    protected static final int ULAW = 1;
    protected static final int ALAW = 2;
    private final Mixer.Info mixerInfo;
    protected Line.Info[] sourceLineInfo;
    protected Line.Info[] targetLineInfo;
    protected Vector formats = new Vector();
    protected Vector sourceLines = new Vector();
    protected Vector targetLines = new Vector();

    public synchronized void open() throws LineUnavailableException {
        try {
            this.open(this.format, this.bufferSize);
        }
        catch (LineUnavailableException lineUnavailableException) {
            AudioFormat audioFormat = null;
            audioFormat = AbstractMixer.getSystemFormat();
            if (audioFormat != null) {
                this.open(audioFormat, -1);
            }
            throw lineUnavailableException;
        }
    }

    static AudioFormat getSystemFormat() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n2 = 0;
        while (n2 < infoArray.length) {
            Mixer mixer = AudioSystem.getMixer(infoArray[n2]);
            if (mixer.isOpen() && mixer instanceof DataLine) {
                return ((DataLine)((Object)mixer)).getFormat();
            }
            ++n2;
        }
        return null;
    }

    public synchronized void open(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        AudioFormat audioFormat2 = AbstractMixer.getSystemFormat();
        if (audioFormat2 != null && !audioFormat.matches(audioFormat2)) {
            throw new LineUnavailableException("Requested format incompatible with already established device format: " + audioFormat2);
        }
        super.open(audioFormat, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getSourceLines() {
        Line[] lineArray;
        Vector vector = this.sourceLines;
        synchronized (vector) {
            lineArray = new Line[this.sourceLines.size()];
            int n2 = 0;
            while (n2 < lineArray.length) {
                lineArray[n2] = (Line)this.sourceLines.elementAt(n2);
                ++n2;
            }
        }
        return lineArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Line[] getTargetLines() {
        Line[] lineArray;
        Vector vector = this.targetLines;
        synchronized (vector) {
            lineArray = new Line[this.targetLines.size()];
            int n2 = 0;
            while (n2 < lineArray.length) {
                lineArray[n2] = (Line)this.targetLines.elementAt(n2);
                ++n2;
            }
        }
        return lineArray;
    }

    protected void close(Line line) {
        if (this.equals(line)) {
            return;
        }
        this.sourceLines.removeElement(line);
        this.targetLines.removeElement(line);
        if (this.sourceLines.isEmpty() && this.targetLines.isEmpty()) {
            this.close();
        }
    }

    protected void open(Line line) throws LineUnavailableException {
        if (this.equals(line)) {
            return;
        }
        if (this.isSourceLine(line.getLineInfo())) {
            if (!this.sourceLines.contains(line)) {
                this.open();
                this.sourceLines.addElement(line);
            }
        } else if (this.isTargetLine(line.getLineInfo()) && !this.targetLines.contains(line)) {
            this.open();
            this.targetLines.addElement(line);
        }
    }

    protected void start(Line line) {
        if (this.equals(line)) {
            return;
        }
        if (!this.isStartedRunning()) {
            this.start();
        }
    }

    protected void stop(Line line) {
        Object object;
        if (this.equals(line)) {
            return;
        }
        Vector vector = (Vector)this.sourceLines.clone();
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) instanceof AbstractDataLine && ((AbstractDataLine)(object = (AbstractDataLine)vector.elementAt(n2))).isStartedRunning() && !object.equals(line)) {
                return;
            }
            ++n2;
        }
        object = (Vector)this.targetLines.clone();
        int n3 = 0;
        while (n3 < ((Vector)object).size()) {
            AbstractDataLine abstractDataLine = (AbstractDataLine)((Vector)object).elementAt(n3);
            if (abstractDataLine.isStartedRunning() && !abstractDataLine.equals(line)) {
                return;
            }
            ++n3;
        }
        this.stop();
    }

    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public void synchronize(Line[] lineArray, boolean bl2) {
        throw new IllegalArgumentException("Synchronization not supported by this mixer.");
    }

    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl2) {
        return false;
    }

    public Line.Info[] getSourceLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.sourceLineInfo.length];
        System.arraycopy(this.sourceLineInfo, 0, infoArray, 0, this.sourceLineInfo.length);
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo() {
        Line.Info[] infoArray = new Line.Info[this.targetLineInfo.length];
        System.arraycopy(this.targetLineInfo, 0, infoArray, 0, this.targetLineInfo.length);
        return infoArray;
    }

    public abstract int getMaxLines(Line.Info var1);

    public boolean isLineSupported(Line.Info info) {
        int n2 = 0;
        while (n2 < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n2])) {
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isSourceLine(Line.Info info) {
        int n2 = 0;
        while (n2 < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isTargetLine(Line.Info info) {
        int n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Mixer.Info getMixerInfo() {
        return this.mixerInfo;
    }

    protected void open(DataLine dataLine, AudioFormat audioFormat, int n2) throws LineUnavailableException {
        this.open(dataLine);
    }

    public abstract Line getLine(Line.Info var1) throws LineUnavailableException;

    Line.Info getLineInfo(Line.Info info) {
        int n2 = 0;
        while (n2 < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n2])) {
                return this.sourceLineInfo[n2];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                return this.targetLineInfo[n2];
            }
            ++n2;
        }
        return null;
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.sourceLineInfo.length) {
            if (info.matches(this.sourceLineInfo[n2])) {
                vector.addElement(this.sourceLineInfo[n2]);
            }
            ++n2;
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        n2 = 0;
        while (n2 < infoArray.length) {
            infoArray[n2] = (Line.Info)vector.elementAt(n2);
            ++n2;
        }
        return infoArray;
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.targetLineInfo.length) {
            if (info.matches(this.targetLineInfo[n2])) {
                vector.addElement(this.targetLineInfo[n2]);
            }
            ++n2;
        }
        Line.Info[] infoArray = new Line.Info[vector.size()];
        n2 = 0;
        while (n2 < infoArray.length) {
            infoArray[n2] = (Line.Info)vector.elementAt(n2);
            ++n2;
        }
        return infoArray;
    }

    protected AbstractMixer(DataLine.Info info, Control[] controlArray, AudioFormat audioFormat, int n2, Mixer.Info info2, Line.Info[] infoArray, Line.Info[] infoArray2) {
        super(info, null, controlArray, audioFormat, n2);
        this.mixer = this;
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.mixerInfo = info2;
        this.sourceLineInfo = infoArray;
        this.targetLineInfo = infoArray2;
    }
}

