/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class WindowsTreeUI
extends BasicTreeUI {
    protected static final int HALF_SIZE = 4;
    protected static final int SIZE = 9;

    protected void ensureRowsAreVisible(int n2, int n3) {
        if (this.tree != null && n2 >= 0 && n3 < this.getRowCount(this.tree)) {
            Rectangle rectangle = this.tree.getVisibleRect();
            if (n2 == n3) {
                Rectangle rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n2));
                if (rectangle2 != null) {
                    rectangle2.x = rectangle.x;
                    rectangle2.width = rectangle.width;
                    this.tree.scrollRectToVisible(rectangle2);
                }
            } else {
                Rectangle rectangle3;
                Rectangle rectangle4 = rectangle3 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n2));
                int n4 = rectangle3.y;
                int n5 = n4 + rectangle.height;
                int n6 = n2 + 1;
                while (n6 <= n3) {
                    rectangle4 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n6));
                    if (rectangle4.y + rectangle4.height > n5) {
                        n6 = n3;
                    }
                    ++n6;
                }
                this.tree.scrollRectToVisible(new Rectangle(rectangle.x, n4, 1, rectangle4.y + rectangle4.height - n4));
            }
        }
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WindowsTreeCellRenderer(this);
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        this.drawDashedHorizontalLine(graphics, n2, n3, n4);
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        this.drawDashedVerticalLine(graphics, n2, n3, n4);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTreeUI();
    }

    public static class CollapsedIcon
    extends ExpandedIcon {
        public static Icon createCollapsedIcon() {
            return new CollapsedIcon();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            super.paintIcon(component, graphics, n2, n3);
            graphics.drawLine(n2 + 4, n3 + 2, n2 + 4, n3 + 6);
        }
    }

    public static class ExpandedIcon
    implements Icon,
    Serializable {
        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public static Icon createExpandedIcon() {
            return new ExpandedIcon();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = component.getBackground();
            if (color != null) {
                graphics.setColor(color);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillRect(n2, n3, 8, 8);
            graphics.setColor(Color.gray);
            graphics.drawRect(n2, n3, 8, 8);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 + 2, n3 + 4, n2 + 6, n3 + 4);
        }
    }

    public class WindowsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private final WindowsTreeUI this$0;

        public WindowsTreeCellRenderer(WindowsTreeUI windowsTreeUI) {
            this.this$0 = windowsTreeUI;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            if (!jTree.isEnabled()) {
                this.setEnabled(false);
                if (bl4) {
                    this.setDisabledIcon(this.getLeafIcon());
                } else if (bl2) {
                    this.setDisabledIcon(this.getOpenIcon());
                } else {
                    this.setDisabledIcon(this.getClosedIcon());
                }
            } else {
                this.setEnabled(true);
                if (bl4) {
                    this.setIcon(this.getLeafIcon());
                } else if (bl2) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            return this;
        }
    }
}

