/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuUI;

public class WindowsMenuUI
extends BasicMenuUI {
    private boolean isMouseOver = false;

    private boolean isMouseOver() {
        return this.isMouseOver;
    }

    private void setMouseOver(boolean bl2) {
        this.isMouseOver = bl2;
    }

    static void access$000(WindowsMenuUI windowsMenuUI, boolean bl2) {
        windowsMenuUI.setMouseOver(bl2);
    }

    static JMenuItem access$100(WindowsMenuUI windowsMenuUI) {
        return windowsMenuUI.menuItem;
    }

    static JMenuItem access$200(WindowsMenuUI windowsMenuUI) {
        return windowsMenuUI.menuItem;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new WindowsMouseInputHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuUI();
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (WindowsLookAndFeel.isClassicWindows() || !((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            return;
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n2 = jMenuItem.getWidth();
        int n3 = jMenuItem.getHeight();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Color color3 = uIDefaults.getColor("controlLtHighlight");
        Color color4 = uIDefaults.getColor("controlShadow");
        graphics.setColor(jMenuItem.getBackground());
        graphics.fillRect(0, 0, n2, n3);
        if (jMenuItem.isOpaque()) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color4);
                graphics.drawLine(0, 0, n2 - 1, 0);
                graphics.drawLine(0, 0, 0, n3 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 2);
                graphics.drawLine(0, n3 - 2, n2 - 1, n3 - 2);
            } else if (this.isMouseOver() && buttonModel.isEnabled()) {
                graphics.setColor(color3);
                graphics.drawLine(0, 0, n2 - 1, 0);
                graphics.drawLine(0, 0, 0, n3 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 2);
                graphics.drawLine(0, n3 - 2, n2 - 1, n3 - 2);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n2, n3);
            }
        }
        graphics.setColor(color2);
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!buttonModel.isEnabled()) {
            WindowsGraphicsUtils.paintText(graphics, jMenuItem, rectangle, string, 0);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = jMenuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                n2 = -1;
            }
            Color color = graphics.getColor();
            if (buttonModel.isSelected() && (WindowsLookAndFeel.isClassicWindows() || !((JMenu)jMenuItem).isTopLevelMenu())) {
                graphics.setColor(this.selectionForeground);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(color);
        }
    }

    protected class WindowsMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        private final WindowsMenuUI this$0;

        protected WindowsMouseInputHandler(WindowsMenuUI windowsMenuUI) {
            this.this$0 = windowsMenuUI;
            super(windowsMenuUI);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            if (!WindowsLookAndFeel.isClassicWindows()) {
                WindowsMenuUI.access$000(this.this$0, true);
                WindowsMenuUI.access$100(this.this$0).repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            if (!WindowsLookAndFeel.isClassicWindows()) {
                WindowsMenuUI.access$000(this.this$0, false);
                WindowsMenuUI.access$200(this.this$0).repaint();
            }
        }
    }
}

