/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class WindowsInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private Color selectedTitleGradientColor;
    private Color notSelectedTitleGradientColor;
    private JPopupMenu systemPopupMenu;
    private JLabel systemLabel;

    protected void addSubComponents() {
        this.add(this.systemLabel);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenu();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.systemLabel = new JLabel(this.frame.getFrameIcon());
        this.systemLabel.addMouseListener(new MouseAdapter(this){
            private final WindowsInternalFrameTitlePane this$0;
            {
                this.this$0 = windowsInternalFrameTitlePane;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = new Dimension();
                Border border = WindowsInternalFrameTitlePane.access$000(this.this$0).getBorder();
                if (border != null) {
                    dimension.width += border.getBorderInsets((Component)WindowsInternalFrameTitlePane.access$100((WindowsInternalFrameTitlePane)this.this$0)).left + border.getBorderInsets((Component)WindowsInternalFrameTitlePane.access$200((WindowsInternalFrameTitlePane)this.this$0)).right;
                    dimension.height += border.getBorderInsets((Component)WindowsInternalFrameTitlePane.access$300((WindowsInternalFrameTitlePane)this.this$0)).bottom + border.getBorderInsets((Component)WindowsInternalFrameTitlePane.access$400((WindowsInternalFrameTitlePane)this.this$0)).top;
                }
                if (!WindowsInternalFrameTitlePane.access$500(this.this$0).isIcon()) {
                    WindowsInternalFrameTitlePane.access$600(this.this$0).show(mouseEvent.getComponent(), this.this$0.getX() - dimension.width, this.this$0.getY() + this.this$0.getHeight() - dimension.height);
                } else {
                    WindowsInternalFrameTitlePane.access$600(this.this$0).show(mouseEvent.getComponent(), this.this$0.getX() - dimension.width, this.this$0.getY() - WindowsInternalFrameTitlePane.access$600((WindowsInternalFrameTitlePane)this.this$0).getPreferredSize().height - dimension.height);
                }
            }
        });
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectedTitleGradientColor = UIManager.getColor("InternalFrame.activeTitleGradient");
        this.notSelectedTitleGradientColor = UIManager.getColor("InternalFrame.inactiveTitleGradient");
        Color color = UIManager.getColor("InternalFrame.activeBorderColor");
        this.setBorder(BorderFactory.createLineBorder(color, 1));
    }

    public void paintComponent(Graphics graphics) {
        this.paintTitleBackground(graphics);
        if (this.frame.getTitle() != null) {
            int n2;
            boolean bl2 = this.frame.isSelected();
            Font font = graphics.getFont();
            graphics.setFont(this.getFont());
            if (bl2) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            String string = this.frame.getTitle();
            if (WindowsGraphicsUtils.isLeftToRight(this.frame)) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                n2 = this.systemLabel.getX() + this.systemLabel.getWidth() + 2;
                int n4 = rectangle.x - n2 - 3;
                string = this.getTitle(this.frame.getTitle(), fontMetrics, n4);
            } else {
                n2 = this.systemLabel.getX() - 2 - SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            graphics.drawString(string, n2, n3);
            graphics.setFont(font);
        }
    }

    protected void paintTitleBackground(Graphics graphics) {
        Boolean bl2 = (Boolean)LookAndFeel.getDesktopPropertyValue("win.frame.captionGradientsOn", false);
        if (bl2.booleanValue() && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            boolean bl3 = this.frame.isSelected();
            int n2 = this.getWidth();
            if (bl3) {
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.selectedTitleColor, (int)((double)n2 * 0.75), 0.0f, this.selectedTitleGradientColor);
                graphics2D.setPaint(gradientPaint);
            } else {
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.notSelectedTitleColor, (int)((double)n2 * 0.75), 0.0f, this.notSelectedTitleGradientColor);
                graphics2D.setPaint(gradientPaint);
            }
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(paint);
        } else {
            super.paintTitleBackground(graphics);
        }
    }

    protected LayoutManager createLayout() {
        return new WindowsTitlePaneLayout(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new WindowsPropertyChangeHandler(this);
    }

    public WindowsInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        this.systemPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    static JButton access$1200(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.closeButton;
    }

    static JButton access$1400(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.maxButton;
    }

    static JButton access$1600(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.iconButton;
    }

    static JButton access$800(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.closeButton;
    }

    static JInternalFrame access$000(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$100(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$1100(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$1300(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$1500(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$1700(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$200(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$300(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$400(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$500(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$700(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JInternalFrame access$900(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.frame;
    }

    static JLabel access$1000(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.systemLabel;
    }

    static JPopupMenu access$600(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
        return windowsInternalFrameTitlePane.systemPopupMenu;
    }

    public class WindowsPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        private final WindowsInternalFrameTitlePane this$0;

        public WindowsPropertyChangeHandler(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
            this.this$0 = windowsInternalFrameTitlePane;
            super(windowsInternalFrameTitlePane);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("frameIcon".equals(string) && WindowsInternalFrameTitlePane.access$1000(this.this$0) != null) {
                WindowsInternalFrameTitlePane.access$1000(this.this$0).setIcon(WindowsInternalFrameTitlePane.access$1700(this.this$0).getFrameIcon());
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    public class WindowsTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        private final WindowsInternalFrameTitlePane this$0;

        public WindowsTitlePaneLayout(WindowsInternalFrameTitlePane windowsInternalFrameTitlePane) {
            this.this$0 = windowsInternalFrameTitlePane;
            super(windowsInternalFrameTitlePane);
        }

        public void layoutContainer(Container container) {
            boolean bl2 = WindowsGraphicsUtils.isLeftToRight(WindowsInternalFrameTitlePane.access$700(this.this$0));
            int n2 = this.this$0.getWidth();
            int n3 = this.this$0.getHeight();
            int n4 = WindowsInternalFrameTitlePane.access$800(this.this$0).getIcon().getIconHeight();
            Icon icon = WindowsInternalFrameTitlePane.access$900(this.this$0).getFrameIcon();
            int n5 = 0;
            if (icon != null) {
                n5 = icon.getIconHeight();
            }
            int n6 = bl2 ? 2 : n2 - 16 - 2;
            WindowsInternalFrameTitlePane.access$1000(this.this$0).setBounds(n6, (n3 - n5) / 2, 16, 16);
            int n7 = n6 = bl2 ? n2 - 16 - 2 : 2;
            if (WindowsInternalFrameTitlePane.access$1100(this.this$0).isClosable()) {
                WindowsInternalFrameTitlePane.access$1200(this.this$0).setBounds(n6, (n3 - n4) / 2 + 1, 16, 14);
                n6 += bl2 ? -18 : 18;
            }
            if (WindowsInternalFrameTitlePane.access$1300(this.this$0).isMaximizable()) {
                WindowsInternalFrameTitlePane.access$1400(this.this$0).setBounds(n6, (n3 - n4) / 2 + 1, 16, 14);
                n6 += bl2 ? -18 : 18;
            }
            if (WindowsInternalFrameTitlePane.access$1500(this.this$0).isIconifiable()) {
                WindowsInternalFrameTitlePane.access$1600(this.this$0).setBounds(n6, (n3 - n4) / 2 + 1, 16, 14);
            }
        }
    }
}

