/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.gif;

import com.sun.imageio.plugins.gif.GIFImageMetadata;
import com.sun.imageio.plugins.gif.GIFStreamMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GIFImageReader
extends ImageReader {
    ImageInputStream stream = null;
    boolean gotHeader = false;
    GIFStreamMetadata streamMetadata = null;
    int currIndex = -1;
    GIFImageMetadata imageMetadata = null;
    List imageStartPosition = new ArrayList();
    int imageMetadataLength;
    int numImages = -1;
    byte[] block = new byte[255];
    int blockLength = 0;
    int bitPos = 0;
    int nextByte = 0;
    int initCodeSize;
    int clearCode;
    int eofCode;
    int next32Bits = 0;
    boolean lastBlockFound = false;
    BufferedImage theImage = null;
    WritableRaster theTile = null;
    int width = -1;
    int height = -1;
    int streamX = -1;
    int streamY = -1;
    int rowsDone = 0;
    int interlacePass = 0;
    static final int[] interlaceIncrement = new int[]{8, 8, 4, 2, -1};
    static final int[] interlaceOffset = new int[]{0, 4, 2, 1, -1};
    Rectangle sourceRegion;
    int sourceXSubsampling;
    int sourceYSubsampling;
    int sourceMinProgressivePass;
    int sourceMaxProgressivePass;
    Point destinationOffset;
    Rectangle destinationRegion;
    int updateMinY;
    int updateYStep;
    boolean decodeThisRow = true;
    int destY = 0;
    byte[] rowBuf;

    private void computeDecodeThisRow() {
        this.decodeThisRow = this.destY < this.destinationRegion.y + this.destinationRegion.height && this.streamY >= this.sourceRegion.y && this.streamY < this.sourceRegion.y + this.sourceRegion.height && (this.streamY - this.sourceRegion.y) % this.sourceYSubsampling == 0;
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private void outputRow() {
        int n2 = Math.min(this.sourceRegion.width, this.destinationRegion.width * this.sourceXSubsampling);
        int n3 = this.destinationRegion.x;
        if (this.sourceXSubsampling == 1) {
            this.theTile.setDataElements(n3, this.destY, n2, 1, this.rowBuf);
        } else {
            int n4 = 0;
            while (n4 < n2) {
                this.theTile.setSample(n3, this.destY, 0, this.rowBuf[n4] & 0xFF);
                n4 += this.sourceXSubsampling;
                ++n3;
            }
        }
        if (this.updateListeners != null) {
            int[] nArray = new int[]{0};
            this.processImageUpdate(this.theImage, n3, this.destY, n2, 1, 1, this.updateYStep, nArray);
        }
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new GIFStreamMetadata();
        try {
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byte[] byArray = new byte[6];
            this.stream.readFully(byArray);
            StringBuffer stringBuffer = new StringBuffer(3);
            stringBuffer.append((char)byArray[3]);
            stringBuffer.append((char)byArray[4]);
            stringBuffer.append((char)byArray[5]);
            this.streamMetadata.version = stringBuffer.toString();
            this.streamMetadata.logicalScreenWidth = this.stream.readUnsignedShort();
            this.streamMetadata.logicalScreenHeight = this.stream.readUnsignedShort();
            int n2 = this.stream.readUnsignedByte();
            boolean bl2 = (n2 & 0x80) != 0;
            this.streamMetadata.colorResolution = (n2 >> 4 & 7) + 1;
            this.streamMetadata.sortFlag = (n2 & 8) != 0;
            int n3 = 1 << (n2 & 7) + 1;
            this.streamMetadata.backgroundColorIndex = this.stream.readUnsignedByte();
            this.streamMetadata.pixelAspectRatio = this.stream.readUnsignedByte();
            if (bl2) {
                this.streamMetadata.globalColorTable = new byte[3 * n3];
                this.stream.readFully(this.streamMetadata.globalColorTable);
            } else {
                this.streamMetadata.globalColorTable = null;
            }
            this.imageStartPosition.add(new Long(this.stream.getStreamPosition()));
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading header!", iOException);
        }
        this.gotHeader = true;
    }

    private void readMetadata() throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        try {
            int n2;
            this.imageMetadata = new GIFImageMetadata();
            long l2 = this.stream.getStreamPosition();
            while (true) {
                int n3;
                if ((n2 = this.stream.readUnsignedByte()) == 44) {
                    this.imageMetadata.imageLeftPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageTopPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.imageHeight = this.stream.readUnsignedShort();
                    n3 = this.stream.readUnsignedByte();
                    boolean bl2 = (n3 & 0x80) != 0;
                    this.imageMetadata.interlaceFlag = (n3 & 0x40) != 0;
                    this.imageMetadata.sortFlag = (n3 & 0x20) != 0;
                    int n4 = 1 << (n3 & 7) + 1;
                    if (bl2) {
                        this.imageMetadata.localColorTable = new byte[3 * n4];
                        this.stream.readFully(this.imageMetadata.localColorTable);
                    } else {
                        this.imageMetadata.localColorTable = null;
                    }
                    this.imageMetadataLength = (int)(this.stream.getStreamPosition() - l2);
                    return;
                }
                if (n2 != 33) break;
                n3 = this.stream.readUnsignedByte();
                if (n3 == 249) {
                    int n5 = this.stream.readUnsignedByte();
                    int n6 = this.stream.readUnsignedByte();
                    this.imageMetadata.disposalMethod = n6 >> 2 & 3;
                    this.imageMetadata.userInputFlag = (n6 & 2) != 0;
                    this.imageMetadata.transparentColorFlag = (n6 & 1) != 0;
                    this.imageMetadata.delayTime = this.stream.readUnsignedShort();
                    this.imageMetadata.transparentColorIndex = this.stream.readUnsignedByte();
                    int n7 = this.stream.readUnsignedByte();
                    continue;
                }
                if (n3 == 1) {
                    int n8 = this.stream.readUnsignedByte();
                    this.imageMetadata.hasPlainTextExtension = true;
                    this.imageMetadata.textGridLeft = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridTop = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridHeight = this.stream.readUnsignedShort();
                    this.imageMetadata.characterCellWidth = this.stream.readUnsignedByte();
                    this.imageMetadata.characterCellHeight = this.stream.readUnsignedByte();
                    this.imageMetadata.textForegroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.textBackgroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.text = this.concatenateBlocks();
                    continue;
                }
                if (n3 == 254) {
                    byte[] byArray = this.concatenateBlocks();
                    if (this.imageMetadata.comments == null) {
                        this.imageMetadata.comments = new ArrayList();
                    }
                    this.imageMetadata.comments.add(byArray);
                    continue;
                }
                if (n3 == 255) {
                    int n9 = this.stream.readUnsignedByte();
                    byte[] byArray = new byte[8];
                    this.stream.readFully(byArray);
                    byte[] byArray2 = new byte[3];
                    this.stream.readFully(byArray2);
                    byte[] byArray3 = this.concatenateBlocks();
                    if (this.imageMetadata.applicationIDs == null) {
                        this.imageMetadata.applicationIDs = new ArrayList();
                        this.imageMetadata.authenticationCodes = new ArrayList();
                        this.imageMetadata.applicationData = new ArrayList();
                    }
                    this.imageMetadata.applicationIDs.add(byArray);
                    this.imageMetadata.authenticationCodes.add(byArray2);
                    this.imageMetadata.applicationData.add(byArray3);
                    continue;
                }
                int n10 = 0;
                do {
                    n10 = this.stream.readUnsignedByte();
                    this.stream.skipBytes(n10);
                } while (n10 > 0);
            }
            if (n2 == 59) {
                throw new IndexOutOfBoundsException("Attempt to read past end of image sequence!");
            }
            throw new IIOException("Unexpected block type " + n2 + "!");
        }
        catch (IIOException iIOException) {
            throw iIOException;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading image metadata!", iOException);
        }
    }

    public void reset() {
        super.reset();
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.gotHeader = false;
        this.streamMetadata = null;
        this.currIndex = -1;
        this.imageMetadata = null;
        this.imageStartPosition = new ArrayList();
        this.numImages = -1;
        this.blockLength = 0;
        this.bitPos = 0;
        this.nextByte = 0;
        this.next32Bits = 0;
        this.lastBlockFound = false;
        this.theImage = null;
        this.theTile = null;
        this.width = -1;
        this.height = -1;
        this.streamX = -1;
        this.streamY = -1;
        this.rowsDone = 0;
        this.interlacePass = 0;
    }

    private boolean skipImage() throws IIOException {
        try {
            while (true) {
                int n2;
                int n3;
                int n4;
                if ((n4 = this.stream.readUnsignedByte()) == 44) {
                    this.stream.skipBytes(8);
                    n3 = this.stream.readUnsignedByte();
                    if ((n3 & 0x80) != 0) {
                        n2 = (n3 & 7) + 1;
                        this.stream.skipBytes(3 * (1 << n2));
                    }
                    this.stream.skipBytes(1);
                    n2 = 0;
                    do {
                        n2 = this.stream.readUnsignedByte();
                        this.stream.skipBytes(n2);
                    } while (n2 > 0);
                    return true;
                }
                if (n4 == 59) {
                    return false;
                }
                if (n4 == 33) {
                    n3 = this.stream.readUnsignedByte();
                    n2 = 0;
                    do {
                        n2 = this.stream.readUnsignedByte();
                        this.stream.skipBytes(n2);
                    } while (n2 > 0);
                    continue;
                }
                if (n4 == 0) {
                    return false;
                }
                n3 = 0;
                do {
                    n3 = this.stream.readUnsignedByte();
                    this.stream.skipBytes(n3);
                } while (n3 > 0);
            }
        }
        catch (EOFException eOFException) {
            return false;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error locating image!", iOException);
        }
    }

    private byte[] concatenateBlocks() throws IOException {
        int n2;
        byte[] byArray = new byte[]{};
        while ((n2 = this.stream.readUnsignedByte()) != 0) {
            byte[] byArray2 = new byte[byArray.length + n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.stream.readFully(byArray2, byArray.length, n2);
            byArray = byArray2;
        }
        return byArray;
    }

    public int getHeight(int n2) throws IIOException {
        this.checkIndex(n2);
        int n3 = this.locateImage(n2);
        if (n3 != n2) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageHeight;
    }

    public int getWidth(int n2) throws IIOException {
        this.checkIndex(n2);
        int n3 = this.locateImage(n2);
        if (n3 != n2) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageWidth;
    }

    private int locateImage(int n2) throws IIOException {
        this.readHeader();
        try {
            int n3 = Math.min(n2, this.imageStartPosition.size() - 1);
            Long l2 = (Long)this.imageStartPosition.get(n3);
            this.stream.seek(l2);
            while (n3 < n2) {
                if (!this.skipImage()) {
                    return --n3;
                }
                Long l3 = new Long(this.stream.getStreamPosition());
                this.imageStartPosition.add(l3);
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Couldn't seek!", iOException);
        }
        if (this.currIndex != n2) {
            this.imageMetadata = null;
        }
        this.currIndex = n2;
        return n2;
    }

    private void checkIndex(int n2) {
        if (n2 < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = n2;
        }
    }

    private void startPass(int n2) {
        if (this.updateListeners == null) {
            return;
        }
        int n3 = 0;
        int n4 = 1;
        if (this.imageMetadata.interlaceFlag) {
            n3 = interlaceOffset[this.interlacePass];
            n4 = interlaceIncrement[this.interlacePass];
        }
        int[] nArray = GIFImageReader.computeUpdatedPixels(this.sourceRegion, this.destinationOffset, this.destinationRegion.x, this.destinationRegion.y, this.destinationRegion.x + this.destinationRegion.width - 1, this.destinationRegion.y + this.destinationRegion.height - 1, this.sourceXSubsampling, this.sourceYSubsampling, 0, n3, this.destinationRegion.width, (this.destinationRegion.height + n4 - 1) / n4, 1, n4);
        this.updateMinY = nArray[1];
        this.updateYStep = nArray[5];
        int[] nArray2 = new int[]{0};
        this.processPassStarted(this.theImage, this.interlacePass, this.sourceMinProgressivePass, this.sourceMaxProgressivePass, 0, this.updateMinY, 1, this.updateYStep, nArray2);
    }

    private int getCode(int n2, int n3) throws IOException {
        if (this.bitPos + n2 > 32) {
            return this.eofCode;
        }
        int n4 = this.next32Bits >> this.bitPos & n3;
        this.bitPos += n2;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                this.blockLength = this.stream.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    return n4;
                }
                int n5 = this.blockLength;
                int n6 = 0;
                while (n5 > 0) {
                    int n7 = this.stream.read(this.block, n6, n5);
                    n6 += n7;
                    n5 -= n7;
                }
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return n4;
    }

    private static void computeUpdatedPixels(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int[] nArray, int n11) {
        boolean bl2 = false;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = 0;
        while (n15 < n9) {
            int n16 = n8 + n15 * n10;
            if (n16 >= n2 && (n16 - n2) % n7 == 0) {
                if (n16 >= n2 + n3) break;
                int n17 = n4 + (n16 - n2) / n7;
                if (n17 >= n5) {
                    if (n17 > n6) break;
                    if (!bl2) {
                        n12 = n17;
                        bl2 = true;
                    } else if (n13 == -1) {
                        n13 = n17;
                    }
                    n14 = n17;
                }
            }
            ++n15;
        }
        nArray[n11] = n12;
        nArray[n11 + 2] = !bl2 ? 0 : n14 - n12 + 1;
        nArray[n11 + 4] = Math.max(n13 - n12, 1);
    }

    public int getNumImages(boolean bl2) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.seekForwardOnly && bl2) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (bl2) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    private void outputPixels(byte[] byArray, int n2) {
        if (this.interlacePass < this.sourceMinProgressivePass || this.interlacePass > this.sourceMaxProgressivePass) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.streamX >= this.sourceRegion.x) {
                this.rowBuf[this.streamX - this.sourceRegion.x] = byArray[n3];
            }
            ++this.streamX;
            if (this.streamX == this.width) {
                ++this.rowsDone;
                this.processImageProgress(100.0f * (float)this.rowsDone / (float)this.height);
                if (this.decodeThisRow) {
                    this.outputRow();
                }
                this.streamX = 0;
                if (this.imageMetadata.interlaceFlag) {
                    this.streamY += interlaceIncrement[this.interlacePass];
                    if (this.streamY >= this.height) {
                        if (this.updateListeners != null) {
                            this.processPassComplete(this.theImage);
                        }
                        ++this.interlacePass;
                        if (this.interlacePass > this.sourceMaxProgressivePass) {
                            return;
                        }
                        this.streamY = interlaceOffset[this.interlacePass];
                        this.startPass(this.interlacePass);
                    }
                } else {
                    ++this.streamY;
                }
                this.destY = this.destinationRegion.y + (this.streamY - this.sourceRegion.y) / this.sourceYSubsampling;
                this.computeDecodeThisRow();
            }
            ++n3;
        }
    }

    public void initializeStringTable(int[] nArray, byte[] byArray, byte[] byArray2, int[] nArray2) {
        int n2 = 1 << this.initCodeSize;
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = -1;
            byArray[n3] = (byte)n3;
            byArray2[n3] = (byte)n3;
            nArray2[n3] = 1;
            ++n3;
        }
        int n4 = n2;
        while (n4 < 4096) {
            nArray[n4] = -1;
            nArray2[n4] = 1;
            ++n4;
        }
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        super.setInput(object, bl2, bl3);
        if (object != null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)object;
        } else {
            this.stream = null;
        }
        this.resetStreamSettings();
    }

    public Iterator getImageTypes(int n2) throws IIOException {
        this.checkIndex(n2);
        int n3 = this.locateImage(n2);
        if (n3 != n2) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        ArrayList arrayList = new ArrayList(1);
        byte[] byArray = this.imageMetadata.localColorTable != null ? this.imageMetadata.localColorTable : this.streamMetadata.globalColorTable;
        int n4 = byArray.length / 3;
        int n5 = n4 == 2 ? 1 : (n4 == 4 ? 2 : (n4 == 8 || n4 == 16 ? 4 : 8));
        int n6 = 1 << n5;
        byte[] byArray2 = new byte[n6];
        byte[] byArray3 = new byte[n6];
        byte[] byArray4 = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            byArray2[n8] = byArray[n7++];
            byArray3[n8] = byArray[n7++];
            byArray4[n8] = byArray[n7++];
            ++n8;
        }
        byte[] byArray5 = null;
        if (this.imageMetadata.transparentColorFlag) {
            byArray5 = new byte[n6];
            Arrays.fill(byArray5, (byte)-1);
            int n9 = Math.min(this.imageMetadata.transparentColorIndex, n6 - 1);
            byArray5[n9] = 0;
        }
        int[] nArray = new int[]{n5};
        arrayList.add(ImageTypeSpecifier.createIndexed(byArray2, byArray3, byArray4, byArray5, n5, 0));
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getStreamMetadata() throws IIOException {
        this.readHeader();
        return this.streamMetadata;
    }

    public IIOMetadata getImageMetadata(int n2) throws IIOException {
        this.checkIndex(n2);
        int n3 = this.locateImage(n2);
        if (n3 != n2) {
            throw new IndexOutOfBoundsException("Bad image index!");
        }
        this.readMetadata();
        return this.imageMetadata;
    }

    public GIFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    private static int[] computeUpdatedPixels(Rectangle rectangle, Point point, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        int[] nArray = new int[6];
        GIFImageReader.computeUpdatedPixels(rectangle.x, rectangle.width, point.x, n2, n4, n6, n8, n10, n12, nArray, 0);
        GIFImageReader.computeUpdatedPixels(rectangle.y, rectangle.height, point.y, n3, n5, n7, n9, n11, n13, nArray, 1);
        return nArray;
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.checkIndex(n2);
        int n3 = this.locateImage(n2);
        if (n3 != n2) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        this.clearAbortRequest();
        this.readMetadata();
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        Iterator iterator = this.getImageTypes(n2);
        this.theImage = ImageReader.getDestination(imageReadParam, iterator, this.imageMetadata.imageWidth, this.imageMetadata.imageHeight);
        this.theTile = this.theImage.getWritableTile(0, 0);
        this.width = this.imageMetadata.imageWidth;
        this.height = this.imageMetadata.imageHeight;
        this.streamX = 0;
        this.streamY = 0;
        this.rowsDone = 0;
        this.interlacePass = 0;
        this.sourceRegion = new Rectangle(0, 0, 0, 0);
        this.destinationRegion = new Rectangle(0, 0, 0, 0);
        ImageReader.computeRegions(imageReadParam, this.width, this.height, this.theImage, this.sourceRegion, this.destinationRegion);
        this.destinationOffset = new Point(this.destinationRegion.x, this.destinationRegion.y);
        this.sourceXSubsampling = imageReadParam.getSourceXSubsampling();
        this.sourceYSubsampling = imageReadParam.getSourceYSubsampling();
        this.sourceMinProgressivePass = Math.max(imageReadParam.getSourceMinProgressivePass(), 0);
        this.sourceMaxProgressivePass = Math.min(imageReadParam.getSourceMaxProgressivePass(), 3);
        this.destY = this.destinationRegion.y + (this.streamY - this.sourceRegion.y) / this.sourceYSubsampling;
        this.computeDecodeThisRow();
        this.processImageStarted(n2);
        this.startPass(0);
        this.rowBuf = new byte[this.width];
        try {
            int n4;
            this.initCodeSize = this.stream.readUnsignedByte();
            int n5 = this.blockLength = this.stream.readUnsignedByte();
            int n6 = 0;
            while (n5 > 0) {
                n4 = this.stream.read(this.block, n6, n5);
                n5 -= n4;
                n6 += n4;
            }
            this.bitPos = 0;
            this.nextByte = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.initNext32Bits();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            int n7 = 0;
            int[] nArray = new int[4096];
            byte[] byArray = new byte[4096];
            byte[] byArray2 = new byte[4096];
            int[] nArray2 = new int[4096];
            byte[] byArray3 = new byte[4096];
            this.initializeStringTable(nArray, byArray, byArray2, nArray2);
            int n8 = (1 << this.initCodeSize) + 2;
            int n9 = this.initCodeSize + 1;
            int n10 = (1 << n9) - 1;
            while (!this.abortRequested()) {
                int n11;
                int n12;
                int n13;
                n4 = this.getCode(n9, n10);
                if (n4 == this.clearCode) {
                    this.initializeStringTable(nArray, byArray, byArray2, nArray2);
                    n8 = (1 << this.initCodeSize) + 2;
                    n9 = this.initCodeSize + 1;
                    n10 = (1 << n9) - 1;
                    n4 = this.getCode(n9, n10);
                    if (n4 == this.eofCode) {
                        this.processImageComplete();
                        return this.theImage;
                    }
                } else {
                    if (n4 == this.eofCode) {
                        this.processImageComplete();
                        return this.theImage;
                    }
                    if (n4 < n8) {
                        n13 = n4;
                    } else {
                        n13 = n7;
                        if (n4 != n8) {
                            this.processWarningOccurred("Out-of-sequence code!");
                        }
                    }
                    n12 = n8++;
                    nArray[n12] = n11 = n7;
                    byArray[n12] = byArray2[n13];
                    byArray2[n12] = byArray2[n11];
                    nArray2[n12] = nArray2[n11] + 1;
                    if (n8 == 1 << n9 && n8 < 4096) {
                        n10 = (1 << ++n9) - 1;
                    }
                }
                n13 = n4;
                n12 = nArray2[n13];
                n11 = n12 - 1;
                while (n11 >= 0) {
                    byArray3[n11] = byArray[n13];
                    n13 = nArray[n13];
                    --n11;
                }
                this.outputPixels(byArray3, n12);
                n7 = n4;
            }
            this.processReadAborted();
            return this.theImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IIOException("I/O error reading image!", iOException);
        }
    }
}

