/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.orbutil.Collision;

class FastCacheTable {
    static final int kGrowthRate = 101;
    static final int kMaxCacheSize = 30;
    static final int kKeysPos = 0;
    static final int kValsPos = 1;
    static final int kHashCodesPos = 2;
    static final int kCollisionsPos = 3;
    static final Object[][] cache = new Object[31][4];
    static int cacheIndex = -1;
    Object[] keys = null;
    int[] vals;
    int[] hashCodes;
    Collision[] collisions;
    int count;
    int threshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkForGrowth() {
        if (this.keys == null) {
            this.count = 0;
            Object[][] objectArray = cache;
            synchronized (cache) {
                if (cacheIndex > -1) {
                    this.keys = (Object[])cache[cacheIndex][0];
                    this.vals = (int[])cache[cacheIndex][1];
                    this.hashCodes = (int[])cache[cacheIndex][2];
                    this.collisions = (Collision[])cache[cacheIndex][3];
                    int n2 = this.keys.length;
                    while (n2 > 0) {
                        this.keys[n2 - 1] = null;
                        --n2;
                    }
                    --cacheIndex;
                    this.threshold = 3 * this.keys.length / 4;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.keys = new Object[101];
                this.vals = new int[101];
                this.hashCodes = new int[101];
                this.collisions = null;
                this.threshold = 3 * this.keys.length / 4;
                return;
            }
        }
        if (this.threshold != this.count) return;
        int n3 = this.keys.length;
        int n4 = n3 + 101;
        Object[] objectArray = new Object[n4];
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        Collision[] collisionArray = null;
        int n5 = 0;
        while (n5 < n3) {
            if (this.keys[n5] != null) {
                Collision collision;
                int n6 = this.hashCodes[n5];
                int n7 = (n6 & Integer.MAX_VALUE) % n4;
                if (objectArray[n7] == null) {
                    objectArray[n7] = this.keys[n5];
                    nArray[n7] = this.vals[n5];
                    nArray2[n7] = n6;
                    if (collisionArray != null) {
                        collisionArray[n7] = null;
                    }
                } else {
                    collision = new Collision();
                    collision.key = this.keys[n5];
                    collision.val = this.vals[n5];
                    collision.hash = n6;
                    if (collisionArray == null) {
                        collisionArray = new Collision[n4];
                    }
                    collision.next = collisionArray[n7];
                    collisionArray[n7] = collision;
                }
                if (this.collisions != null) {
                    collision = this.collisions[n5];
                    while (collision != null) {
                        n6 = collision.hash;
                        n7 = (n6 & Integer.MAX_VALUE) % n4;
                        if (objectArray[n7] == null) {
                            objectArray[n7] = collision.key;
                            nArray[n7] = collision.val;
                            nArray2[n7] = n6;
                            if (collisionArray != null) {
                                collisionArray[n7] = null;
                            }
                        } else {
                            Collision collision2 = new Collision();
                            collision2.key = collision.key;
                            collision2.val = collision.val;
                            collision2.hash = n6;
                            if (collisionArray == null) {
                                collisionArray = new Collision[n4];
                            }
                            collision2.next = collisionArray[n7];
                            collisionArray[n7] = collision2;
                        }
                        collision = collision.next;
                    }
                }
            }
            ++n5;
        }
        Object[][] objectArray2 = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
            }
            // ** MonitorExit[var8_12] (shouldn't be in output)
            this.keys = objectArray;
            this.vals = nArray;
            this.hashCodes = nArray2;
            this.collisions = collisionArray;
            this.threshold = 3 * this.keys.length / 4;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object[][] objectArray = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.keys = null;
            this.vals = null;
            this.hashCodes = null;
            this.collisions = null;
            return;
        }
    }

    public final int getVal(Object object) {
        Collision collision;
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n3] == null) {
            return -1;
        }
        if (this.keys[n3] == object) {
            return this.vals[n3];
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n3];
        if (collision == null) {
            return -1;
        }
        do {
            if (collision.key != object) continue;
            return collision.val;
        } while ((collision = collision.next) != null);
        return -1;
    }

    public final boolean containsKey(Object object) {
        Collision collision;
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n3] == null) {
            return false;
        }
        if (this.keys[n3] == object) {
            return true;
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n3];
        if (collision == null) {
            return false;
        }
        do {
            if (collision.key != object) continue;
            return true;
        } while ((collision = collision.next) != null);
        return false;
    }

    public final void put(Object object, int n2) {
        this.checkForGrowth();
        int n3 = System.identityHashCode(object);
        int n4 = (n3 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n4] == null) {
            this.keys[n4] = object;
            this.vals[n4] = n2;
            this.hashCodes[n4] = n3;
            if (this.collisions != null) {
                this.collisions[n4] = null;
            }
        } else {
            Collision collision = new Collision();
            collision.key = object;
            collision.val = n2;
            collision.hash = n3;
            if (this.collisions == null) {
                this.collisions = new Collision[this.keys.length];
            }
            collision.next = this.collisions[n4];
            this.collisions[n4] = collision;
        }
        ++this.count;
    }
}

