/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.core;

import com.sun.corba.se.internal.core.CodeSetCache;
import com.sun.corba.se.internal.core.CodeSetComponentInfo;
import com.sun.corba.se.internal.core.OSFCodeSetRegistry;
import java.io.UnsupportedEncodingException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CodeSetConversion {
    private static CodeSetConversion implementation;
    private static final int FALLBACK_CODESET = 0;
    private CodeSetCache cache = new CodeSetCache();

    private CodeSetConversion() {
    }

    public static final CodeSetConversion impl() {
        return CodeSetConversionHolder.csc;
    }

    CodeSetConversion(1 var1_1) {
        this();
    }

    static CodeSetCache access$000(CodeSetConversion codeSetConversion) {
        return codeSetConversion.cache;
    }

    private int selectEncoding(CodeSetComponentInfo.CodeSetComponent codeSetComponent, CodeSetComponentInfo.CodeSetComponent codeSetComponent2) {
        int n2 = codeSetComponent2.nativeCodeSet;
        if (n2 == 0) {
            if (codeSetComponent2.conversionCodeSets.length > 0) {
                n2 = codeSetComponent2.conversionCodeSets[0];
            } else {
                return 0;
            }
        }
        if (codeSetComponent.nativeCodeSet == n2) {
            return n2;
        }
        int n3 = 0;
        while (n3 < codeSetComponent.conversionCodeSets.length) {
            if (n2 == codeSetComponent.conversionCodeSets[n3]) {
                return n2;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < codeSetComponent2.conversionCodeSets.length) {
            if (codeSetComponent.nativeCodeSet == codeSetComponent2.conversionCodeSets[n4]) {
                return codeSetComponent.nativeCodeSet;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < codeSetComponent2.conversionCodeSets.length) {
            int n6 = 0;
            while (n6 < codeSetComponent.conversionCodeSets.length) {
                if (codeSetComponent2.conversionCodeSets[n5] == codeSetComponent.conversionCodeSets[n6]) {
                    return codeSetComponent2.conversionCodeSets[n5];
                }
                ++n6;
            }
            ++n5;
        }
        return 0;
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry entry) {
        return new JavaBTCConverter(this, entry);
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry entry, boolean bl2) {
        if (entry == OSFCodeSetRegistry.UTF_16 || entry == OSFCodeSetRegistry.UCS_2) {
            return new UTF16BTCConverter(this, bl2);
        }
        return new JavaBTCConverter(this, entry);
    }

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry entry) {
        int n2 = !entry.isFixedWidth() ? 1 : entry.getMaxBytesPerChar();
        return new JavaCTBConverter(this, entry, n2);
    }

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry entry, boolean bl2, boolean bl3) {
        if (entry == OSFCodeSetRegistry.UCS_2) {
            return new UTF16CTBConverter(this, bl2);
        }
        if (entry == OSFCodeSetRegistry.UTF_16) {
            if (bl3) {
                return new UTF16CTBConverter(this);
            }
            return new UTF16CTBConverter(this, bl2);
        }
        int n2 = !entry.isFixedWidth() ? 1 : entry.getMaxBytesPerChar();
        return new JavaCTBConverter(this, entry, n2);
    }

    public CodeSetComponentInfo.CodeSetContext negotiate(CodeSetComponentInfo codeSetComponentInfo, CodeSetComponentInfo codeSetComponentInfo2) {
        int n2;
        int n3 = this.selectEncoding(codeSetComponentInfo.getCharComponent(), codeSetComponentInfo2.getCharComponent());
        if (n3 == 0) {
            n3 = OSFCodeSetRegistry.UTF_8.getNumber();
        }
        if ((n2 = this.selectEncoding(codeSetComponentInfo.getWCharComponent(), codeSetComponentInfo2.getWCharComponent())) == 0) {
            n2 = OSFCodeSetRegistry.UTF_16.getNumber();
        }
        return new CodeSetComponentInfo.CodeSetContext(n3, n2);
    }

    class 1 {
    }

    public static abstract class BTCConverter {
        public abstract int getFixedCharWidth();

        public abstract int getNumChars();

        public abstract boolean isFixedWidthEncoding();

        public abstract char[] getChars(byte[] var1, int var2, int var3);
    }

    public static abstract class CTBConverter {
        public abstract int getAlignment();

        public abstract int getMaxBytesPerChar();

        public abstract int getNumBytes();

        public abstract boolean isFixedWidthEncoding();

        public abstract byte[] getBytes();

        public abstract void convert(char var1);

        public abstract void convert(String var1);
    }

    private static class CodeSetConversionHolder {
        static final CodeSetConversion csc = new CodeSetConversion(null);

        private CodeSetConversionHolder() {
        }
    }

    private class JavaBTCConverter
    extends BTCConverter {
        protected ByteToCharConverter btc;
        private char[] buffer;
        private int resultingNumChars;
        private OSFCodeSetRegistry.Entry codeset;
        private final CodeSetConversion this$0;

        public final int getFixedCharWidth() {
            return this.codeset.getMaxBytesPerChar();
        }

        public final int getNumChars() {
            return this.resultingNumChars;
        }

        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        public char[] getChars(byte[] byArray, int n2, int n3) {
            if (this.buffer == null || this.buffer.length < n3 * this.btc.getMaxCharsPerByte()) {
                this.buffer = new char[n3 * this.btc.getMaxCharsPerByte()];
            }
            try {
                this.btc.reset();
                this.resultingNumChars = this.btc.convert(byArray, n2, n2 + n3, this.buffer, 0, this.buffer.length);
                this.resultingNumChars += this.btc.flush(this.buffer, 0, this.buffer.length);
                return this.buffer;
            }
            catch (MalformedInputException malformedInputException) {
                throw new DATA_CONVERSION(malformedInputException.getMessage(), 1398079694, CompletionStatus.COMPLETED_NO);
            }
            catch (UnknownCharacterException unknownCharacterException) {
                throw new DATA_CONVERSION(unknownCharacterException.getMessage(), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                throw new INTERNAL(conversionBufferFullException.getMessage(), 1398079715, CompletionStatus.COMPLETED_NO);
            }
        }

        public JavaBTCConverter(CodeSetConversion codeSetConversion, OSFCodeSetRegistry.Entry entry) {
            this.this$0 = codeSetConversion;
            this.btc = this.getConverter(entry.getName());
            this.codeset = entry;
        }

        protected ByteToCharConverter getConverter(String string) {
            try {
                ByteToCharConverter byteToCharConverter = CodeSetConversion.access$000(this.this$0).getByteToCharConverter(string);
                if (byteToCharConverter == null) {
                    byteToCharConverter = ByteToCharConverter.getConverter(string);
                    CodeSetConversion.access$000(this.this$0).setConverter((Object)string, byteToCharConverter);
                    byteToCharConverter.setSubstitutionMode(false);
                }
                return byteToCharConverter;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new INTERNAL("Invalid converter name: " + string);
            }
        }
    }

    private class JavaCTBConverter
    extends CTBConverter {
        private CharToByteConverter ctb;
        private int alignment;
        private char[] chars;
        private int numBytes;
        private int numChars;
        private byte[] buffer;
        private OSFCodeSetRegistry.Entry codeset;
        private final CodeSetConversion this$0;

        public final int getAlignment() {
            return this.alignment;
        }

        public final int getMaxBytesPerChar() {
            return this.ctb.getMaxBytesPerChar();
        }

        public final int getNumBytes() {
            return this.numBytes;
        }

        private void convertCharArray() {
            try {
                if (this.buffer == null || this.buffer.length < this.numChars * this.ctb.getMaxBytesPerChar()) {
                    this.buffer = new byte[this.numChars * this.ctb.getMaxBytesPerChar()];
                }
                this.ctb.reset();
                this.numBytes = this.ctb.convert(this.chars, 0, this.numChars, this.buffer, 0, this.buffer.length);
                this.numBytes += this.ctb.flush(this.buffer, 0, this.buffer.length);
            }
            catch (MalformedInputException malformedInputException) {
                throw new DATA_CONVERSION(malformedInputException.getMessage(), 1398079694, CompletionStatus.COMPLETED_NO);
            }
            catch (UnknownCharacterException unknownCharacterException) {
                throw new DATA_CONVERSION(unknownCharacterException.getMessage(), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                throw new INTERNAL(conversionBufferFullException.getMessage(), 1398079714, CompletionStatus.COMPLETED_NO);
            }
        }

        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        public byte[] getBytes() {
            return this.buffer;
        }

        public void convert(char c2) {
            if (this.chars == null) {
                this.chars = new char[1];
            }
            this.chars[0] = c2;
            this.numChars = 1;
            this.convertCharArray();
        }

        public void convert(String string) {
            if (this.chars == null || this.chars.length < string.length()) {
                this.chars = new char[string.length()];
            }
            this.numChars = string.length();
            string.getChars(0, this.numChars, this.chars, 0);
            this.convertCharArray();
        }

        public JavaCTBConverter(CodeSetConversion codeSetConversion, OSFCodeSetRegistry.Entry entry, int n2) {
            this.this$0 = codeSetConversion;
            this.chars = null;
            this.numBytes = 0;
            this.numChars = 0;
            try {
                this.ctb = CodeSetConversion.access$000(codeSetConversion).getCharToByteConverter(entry.getName());
                if (this.ctb == null) {
                    this.ctb = CharToByteConverter.getConverter(entry.getName());
                    CodeSetConversion.access$000(codeSetConversion).setConverter((Object)entry.getName(), this.ctb);
                    this.ctb.setSubstitutionMode(false);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new INTERNAL("Invalid converter name: " + entry.getName());
            }
            this.codeset = entry;
            this.alignment = n2;
        }
    }

    private class UTF16BTCConverter
    extends JavaBTCConverter {
        private boolean defaultToLittleEndian;
        private boolean converterUsesBOM;
        private static final char UTF16_BE_MARKER = '\ufeff';
        private static final char UTF16_LE_MARKER = '\ufffe';
        private final CodeSetConversion this$0;

        private boolean hasUTF16ByteOrderMarker(byte[] byArray, int n2, int n3) {
            if (n3 >= 4) {
                int n4 = byArray[n2] & 0xFF;
                int n5 = byArray[n2 + 1] & 0xFF;
                char c2 = (char)(n4 << 8 | n5 << 0);
                return c2 == '\ufeff' || c2 == '\ufffe';
            }
            return false;
        }

        public char[] getChars(byte[] byArray, int n2, int n3) {
            if (this.hasUTF16ByteOrderMarker(byArray, n2, n3)) {
                if (!this.converterUsesBOM) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16);
                }
                this.converterUsesBOM = true;
                return super.getChars(byArray, n2, n3);
            }
            if (this.converterUsesBOM) {
                if (this.defaultToLittleEndian) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16LE);
                } else {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16BE);
                }
                this.converterUsesBOM = false;
            }
            return super.getChars(byArray, n2, n3);
        }

        public UTF16BTCConverter(CodeSetConversion codeSetConversion, boolean bl2) {
            this.this$0 = codeSetConversion;
            super(codeSetConversion, OSFCodeSetRegistry.UTF_16);
            this.converterUsesBOM = true;
            this.defaultToLittleEndian = bl2;
        }

        private void switchToConverter(OSFCodeSetRegistry.Entry entry) {
            this.btc = this.getConverter(entry.getName());
        }
    }

    private class UTF16CTBConverter
    extends JavaCTBConverter {
        private final CodeSetConversion this$0;

        public UTF16CTBConverter(CodeSetConversion codeSetConversion) {
            this.this$0 = codeSetConversion;
            super(codeSetConversion, OSFCodeSetRegistry.UTF_16, 2);
        }

        public UTF16CTBConverter(CodeSetConversion codeSetConversion, boolean bl2) {
            this.this$0 = codeSetConversion;
            super(codeSetConversion, bl2 ? OSFCodeSetRegistry.UTF_16LE : OSFCodeSetRegistry.UTF_16BE, 2);
        }
    }
}

