/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.IOException;
import java.io.Serializable;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import sun.plugin.security.CertificateStore;
import sun.plugin.security.DeniedCertificateStore;
import sun.plugin.security.PluginCertificateStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.security.SessionCertificateStore;
import sun.plugin.security.TrustDeciderDialog;
import sun.plugin.usability.Trace;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.NetscapeCertTypeExtension;

public class TrustDecider {
    private static CertificateStore rootStore = new RootCACertificateStore();
    private static CertificateStore permanentStore = new PluginCertificateStore();
    private static CertificateStore sessionStore = new SessionCertificateStore();
    private static CertificateStore deniedStore = new DeniedCertificateStore();
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_KEY_USAGE = "2.5.29.15";
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_OBJECT_SIGNING = "object_signing";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";

    public static void reset() {
        rootStore = new RootCACertificateStore();
        permanentStore = new PluginCertificateStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        int n;
        Certificate[] certificateArray = codeSource.getCertificates();
        String string = codeSource.getLocation().toString();
        if (certificateArray == null) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        LinkedList<Boolean> linkedList = new LinkedList<Boolean>();
        rootStore.load();
        permanentStore.load();
        sessionStore.load();
        deniedStore.load();
        while (n3 < certificateArray.length) {
            n = n2;
            while (n + 1 < certificateArray.length) {
                if (!(certificateArray[n] instanceof X509Certificate) || !(certificateArray[n + 1] instanceof X509Certificate) || !TrustDecider.isIssuerOf((X509Certificate)certificateArray[n], (X509Certificate)certificateArray[n + 1])) break;
                ++n;
            }
            n3 = n + 1;
            if (deniedStore.contains(certificateArray[n2])) {
                linkedList.add(n4, new Boolean(true));
            } else {
                linkedList.add(n4, new Boolean(false));
                if (permanentStore.contains(certificateArray[n2])) {
                    return true;
                }
                if (sessionStore.contains(certificateArray[n2])) {
                    return true;
                }
            }
            n2 = n3;
            ++n4;
        }
        n = 0;
        boolean bl = false;
        boolean bl2 = false;
        n2 = 0;
        n3 = 0;
        n4 = 0;
        while (n3 < certificateArray.length) {
            Serializable serializable;
            int n5 = n2;
            CertificateExpiredException certificateExpiredException = null;
            CertificateNotYetValidException certificateNotYetValidException = null;
            n5 = n2;
            while (n5 < certificateArray.length) {
                Serializable serializable2;
                block29: {
                    serializable = null;
                    serializable2 = null;
                    if (certificateArray[n5] instanceof X509Certificate) {
                        serializable = (X509Certificate)certificateArray[n5];
                    }
                    serializable2 = n5 + 1 < certificateArray.length && certificateArray[n5 + 1] instanceof X509Certificate ? (X509Certificate)certificateArray[n5 + 1] : serializable;
                    try {
                        ((X509Certificate)serializable).checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException2) {
                        if (certificateExpiredException == null) {
                            certificateExpiredException = certificateExpiredException2;
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                        if (certificateNotYetValidException != null) break block29;
                        certificateNotYetValidException = certificateNotYetValidException2;
                    }
                }
                if (!rootStore.contains((Certificate)serializable)) {
                    Set set = serializable.getCriticalExtensionOIDs();
                    if (set == null) {
                        set = Collections.EMPTY_SET;
                    }
                    if (!TrustDecider.checkBasicConstraints((X509Certificate)serializable, set, n5 - n2)) {
                        return false;
                    }
                    if (n5 == n2 ? !TrustDecider.checkLeafKeyUsage((X509Certificate)serializable, set) : !TrustDecider.checkSignerKeyUsage((X509Certificate)serializable, set)) {
                        return false;
                    }
                    if (!set.isEmpty()) {
                        return false;
                    }
                }
                if (!TrustDecider.isIssuerOf((X509Certificate)serializable, (X509Certificate)serializable2)) break;
                try {
                    ((Certificate)serializable).verify(((Certificate)serializable2).getPublicKey());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    return false;
                }
                ++n5;
            }
            n3 = n5 < certificateArray.length ? n5 + 1 : n5;
            serializable = (Boolean)linkedList.get(n4);
            if (!((Boolean)serializable).booleanValue()) {
                int n6;
                if (!rootStore.verify(certificateArray[n3 - 1])) {
                    n = 1;
                }
                if (certificateExpiredException != null || certificateNotYetValidException != null) {
                    bl = true;
                }
                if ((n6 = TrustDecider.showSecurityDialog(codeSource, n2, n3, n != 0, bl)) == 0) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                    sessionStore.add(certificateArray[n2]);
                    sessionStore.save();
                    bl2 = true;
                } else if (n6 == 2) {
                    Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                    permanentStore.add(certificateArray[n2]);
                    permanentStore.save();
                    bl2 = true;
                } else {
                    Trace.msgSecurityPrintln("trustdecider.user.deny");
                    deniedStore.add(certificateArray[n2]);
                    deniedStore.save();
                }
                if (bl2) {
                    return true;
                }
            }
            n2 = n3;
            ++n4;
        }
        return false;
    }

    static int showSecurityDialog(CodeSource codeSource, int n, int n2, boolean bl, boolean bl2) {
        TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(codeSource.getCertificates(), n, n2, bl, bl2);
        return trustDeciderDialog.DoModal();
    }

    private static boolean getNetscapeCertTypeBit(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return principal2.equals(principal = x509Certificate2.getSubjectDN());
    }

    private static boolean checkLeafKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        List<String> list;
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                return false;
            }
            boolean bl = blArray[0];
            if (!bl) {
                return false;
            }
        }
        if ((list = x509Certificate.getExtendedKeyUsage()) != null && set.contains(OID_EXTENDED_KEY_USAGE)) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE) && !list.contains(OID_EKU_CODE_SIGNING)) {
                return false;
            }
        }
        return x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) == null || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING);
    }

    private static boolean checkSignerKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            return false;
        }
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list != null && set.contains(OID_EXTENDED_KEY_USAGE)) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE)) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkBasicConstraints(X509Certificate x509Certificate, Set set, int n) throws CertificateException, IOException {
        set.remove(OID_BASIC_CONSTRAINTS);
        set.remove(OID_NETSCAPE_CERT_TYPE);
        if (n == 0) {
            return true;
        }
        if (x509Certificate.getExtensionValue(OID_BASIC_CONSTRAINTS) == null) {
            if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) == null) return false;
            if (TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) return true;
            return false;
        }
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CA) || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_S_MIME_CA) || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) && !TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) {
            return false;
        }
        int n2 = x509Certificate.getBasicConstraints();
        if (n2 < 0) {
            return false;
        }
        if (n - 1 <= n2) return true;
        return false;
    }
}

