/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import sun.plugin.net.proxy.BrowserProxyInfo;
import sun.plugin.net.proxy.ProxyUtils;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.usability.Trace;

public class ProxyPanel
extends ActivatorSubPanel
implements ActionListener,
KeyListener,
TableModelListener {
    private JTable table;
    private JTextField proxyByPass = new JTextField();
    private JTextField autoProxyURL = new JTextField();
    private JCheckBox useDefault;
    private MessageHandler mh = new MessageHandler("proxy");

    private void initProxySettings() {
        block7: {
            this.proxyByPass.setText(this.model.getProxyByPass());
            this.autoProxyURL.setText(this.model.getAutoProxyURL());
            String string = this.model.getProxySettingsString();
            if (string == null || string.length() == 0) break block7;
            try {
                BrowserProxyInfo browserProxyInfo = new BrowserProxyInfo();
                ProxyUtils.parseProxyServer(string, browserProxyInfo);
                TableModel tableModel = this.table.getModel();
                tableModel.setValueAt(browserProxyInfo.getHttpHost(), 0, 1);
                if (browserProxyInfo.getHttpPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getHttpPort()), 0, 2);
                }
                tableModel.setValueAt(browserProxyInfo.getHttpsHost(), 1, 1);
                if (browserProxyInfo.getHttpsPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getHttpsPort()), 1, 2);
                }
                tableModel.setValueAt(browserProxyInfo.getFtpHost(), 2, 1);
                if (browserProxyInfo.getFtpPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getFtpPort()), 2, 2);
                }
                tableModel.setValueAt(browserProxyInfo.getGopherHost(), 3, 1);
                if (browserProxyInfo.getGopherPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getGopherPort()), 3, 2);
                }
                tableModel.setValueAt(browserProxyInfo.getSocksHost(), 4, 1);
                if (browserProxyInfo.getSocksPort() != -1) {
                    tableModel.setValueAt(new Integer(browserProxyInfo.getSocksPort()), 4, 2);
                }
            }
            catch (Exception exception) {
                Trace.printException(this, exception);
            }
        }
    }

    public void reset() {
        boolean bl = this.model.useDefaultProxy();
        this.useDefault.setSelected(bl);
        boolean bl2 = !bl;
        this.setEnabled(this.table, bl2);
        this.setEnabled(this.proxyByPass, bl2);
        this.setEnabled(this.autoProxyURL, bl2);
        this.initProxySettings();
    }

    private void setProxySettings() {
        int n;
        Object object;
        this.model.setProxyByPass(this.proxyByPass.getText());
        this.model.setAutoProxyURL(this.autoProxyURL.getText());
        StringBuffer stringBuffer = new StringBuffer();
        TableModel tableModel = this.table.getModel();
        String string = (String)tableModel.getValueAt(0, 1);
        if (string != null && !string.equals("")) {
            stringBuffer.append("http=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(0, 2);
            try {
                if (object != null && (n = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((string = (String)tableModel.getValueAt(1, 1)) != null && !string.equals("")) {
            stringBuffer.append(";");
            stringBuffer.append("https=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(1, 2);
            try {
                if (object != null && (n = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((string = (String)tableModel.getValueAt(2, 1)) != null && !string.equals("")) {
            stringBuffer.append(";");
            stringBuffer.append("ftp=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(2, 2);
            try {
                int n2;
                if (object != null && (n2 = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((string = (String)tableModel.getValueAt(3, 1)) != null && !string.equals("")) {
            stringBuffer.append(";");
            stringBuffer.append("gopher=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(3, 2);
            try {
                int n3;
                if (object != null && (n3 = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((string = (String)tableModel.getValueAt(4, 1)) != null && !string.equals("")) {
            stringBuffer.append(";");
            stringBuffer.append("socks=");
            stringBuffer.append(string);
            object = tableModel.getValueAt(4, 2);
            try {
                int n4;
                if (object != null && (n4 = Integer.parseInt(object.toString())) != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (((String)(object = stringBuffer.toString())).length() != 0) {
            this.model.setProxySettingsString((String)object);
        } else {
            this.model.setProxySettingsString(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.useDefault) {
            boolean bl = this.useDefault.isSelected();
            this.model.setDefaultProxySettings(bl);
            this.reset();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.setProxySettings();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.setProxySettings();
    }

    private void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        jComponent.repaint();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setProxySettings();
    }

    public ProxyPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.useDefault = new JCheckBox(this.mh.getMessage("use_browser"));
        this.useDefault.addActionListener(this);
        jPanel.add(this.useDefault);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(new EmptyBorder(4, 4, 4, 4));
        Object[] objectArray = new Object[]{this.mh.getMessage("proxy_protocol"), this.mh.getMessage("proxy_address"), this.mh.getMessage("proxy_port")};
        Object[][] objectArray2 = new Object[][]{{this.mh.getMessage("http"), null, null}, {this.mh.getMessage("https"), null, null}, {this.mh.getMessage("ftp"), null, null}, {this.mh.getMessage("gopher"), null, null}, {this.mh.getMessage("socks"), null, null}};
        DefaultTableModel defaultTableModel = new DefaultTableModel(this, objectArray2, objectArray){
            private final ProxyPanel this$0;

            public boolean isCellEditable(int n, int n2) {
                if (n2 < 1) {
                    return false;
                }
                return super.isCellEditable(n, n2);
            }
            {
                this.this$0 = proxyPanel;
                super(objectArray, objectArray2);
            }
        };
        this.table = new JTable(defaultTableModel);
        this.table.getModel().addTableModelListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jPanel2.add(jScrollPane);
        this.add(jPanel2);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(new JLabel(this.mh.getMessage("bypass")));
        jPanel3.add(this.proxyByPass);
        jPanel3.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.proxyByPass.addKeyListener(this);
        this.add(jPanel3);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(new JLabel(this.mh.getMessage("autourl")));
        jPanel4.add(this.autoProxyURL);
        jPanel4.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.autoProxyURL.addKeyListener(this);
        this.add(jPanel4);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        this.reset();
    }
}

