/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.protocol.socks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class SocksSocket
extends Socket {
    private Socket socket = null;
    private static final int SOCKS_PROTO_VERS = 4;
    private static final int SOCKS_REPLY_VERS = 4;
    private static final int COMMAND_CONNECT = 1;
    private static final int COMMAND_BIND = 2;
    private static final int REQUEST_GRANTED = 90;
    private static final int REQUEST_REJECTED = 91;
    private static final int REQUEST_REJECTED_NO_IDENTD = 92;
    private static final int REQUEST_REJECTED_DIFF_IDENTS = 93;
    public static final int socksDefaultPort = 1080;
    InetAddress address = null;
    int port = -1;

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public int getPort() {
        return this.port;
    }

    private int getSOCKSReply() throws IOException {
        InputStream inputStream = this.getInputStream();
        byte[] byArray = new byte[8];
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n < n2 && n3 < 3) {
            int n4 = inputStream.read(byArray, n, n2 - n);
            if (n4 < 0) {
                throw new SocketException("Malformed reply from SOCKS server");
            }
            n += n4;
            ++n3;
        }
        if (n != n2) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n);
        }
        if (byArray[0] != 0) {
            throw new SocketException("Reply from SOCKS server has bad version " + byArray[0]);
        }
        return byArray[1];
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public synchronized void close() throws IOException {
        this.socket.close();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.socket.setSoLinger(bl, n);
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public String toString() {
        return "SocksSocket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    private void sendSOCKSCommandPacket(int n, InetAddress inetAddress, int n2) throws IOException {
        byte[] byArray = this.makeCommandPacket(n, inetAddress, n2);
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
    }

    private byte[] makeCommandPacket(int n, InetAddress inetAddress, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(9);
        byteArrayOutputStream.write(4);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(n2 >> 8 & 0xFF);
        byteArrayOutputStream.write(n2 >> 0 & 0xFF);
        byte[] byArray = inetAddress.getAddress();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        String string = AccessController.doPrivileged(new GetPropertyAction("user.name"));
        byte[] byArray2 = new byte[string.length()];
        byArray2 = string.getBytes();
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(0);
        return byteArrayOutputStream.toByteArray();
    }

    public SocksSocket(String string, int n, String string2, int n2) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string), n, InetAddress.getByName(string2), n2);
    }

    public SocksSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this.connect(inetAddress, n, inetAddress2, n2);
    }

    private void connect(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        if (n2 == -1) {
            n2 = 1080;
        }
        this.address = inetAddress;
        this.port = n;
        if (inetAddress2 != null) {
            this.socket = new Socket(inetAddress2, n2);
            this.sendSOCKSCommandPacket(1, inetAddress, n);
            int n3 = this.getSOCKSReply();
            switch (n3) {
                case 90: {
                    return;
                }
                case 91: 
                case 92: {
                    throw new SocketException("SOCKS server cannot conect to identd");
                }
                case 93: {
                    throw new SocketException("User name does not match identd name");
                }
            }
        } else {
            this.socket = new Socket(inetAddress, n);
        }
    }
}

